/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.uri.OcaURI;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.LogonEx4Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.LogonEx4Operations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqOctetHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_id;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_type;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.IEnterpriseLogonInformation;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.EnterpriseLogonInformation;
import com.crystaldecisions.sdk.occa.security.internal.ILogonService;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityPlugIn;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.LogonCred;
import com.crystaldecisions.sdk.occa.security.internal.PlugInLoader;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import com.crystaldecisions.sdk.occa.security.internal._LogonEx4Proxy;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class LogonService
implements ILogonService {
    private static final ILogger LOG;
    private LogonEx4Operations m_stub;
    private LogonEx4Operations m_stubForToken;
    private String m_aps;
    private PlugInLoader m_loader;
    private IManagedService m_handler;
    private static final int LOGON_INSANITY_LOOP = 2;
    private static final int FAILOVER_INSANITY_LOOP = 20;
    private static final String LOGON_WITH_TOKEN_ID = "1";
    private static final String USER_LOGON_ID = "2";
    private static final String s_hostname;
    private static final String s_ip;

    LogonService(String aps) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LogonService(): aps=" + aps));
        }
        this.m_aps = aps;
        this.m_loader = new PlugInLoader();
    }

    public ISecuritySession logonWithToken(String token) throws SDKException {
        return this.logonWithToken(token, this.getCurrentLogonIPInfo());
    }

    IEnterpriseLogonInformation getCurrentLogonIPInfo() {
        EnterpriseLogonInformation info = new EnterpriseLogonInformation(true);
        info.setReportedHostname(s_hostname);
        info.setReportedIP(s_ip);
        return info;
    }

    private String getLogonInfoURL(IEnterpriseLogonInformation info) {
        EnterpriseLogonInformation _info = info == null ? new EnterpriseLogonInformation() : (EnterpriseLogonInformation)info;
        if (_info.isSDKSet()) {
            return _info.getURL();
        }
        try {
            String ip1 = _info.getReportedIP();
        }
        catch (SDKException e) {
            try {
                String hostname1 = _info.getReportedHostname();
            }
            catch (SDKException e1) {
                _info.setReportedIP("");
            }
        }
        try {
            String ip2 = _info.getResolvedIP();
        }
        catch (SDKException e) {
            try {
                String hostname2 = _info.getResolvedHostname();
            }
            catch (SDKException e2) {
                _info.setResolvedIP("");
            }
        }
        return _info.getURL();
    }

    public ISecuritySession userLogon(String user, String pwd, String auth) throws SDKException {
        return this.doUserLogon(new LogonCred(user, pwd), auth, this.getCurrentLogonIPInfo());
    }

    private void checkVersionCompatibility(ISecuritySession session) throws SDKException {
        if (session.getAPSVersion(true) < session.getSDKVersion()) {
            throw new SDKException.UnsupportedEnterpriseVersion(session.getSDKVersion(), session.getAPSVersion());
        }
    }

    private ISecuritySession doLogon(String auth, ISecurityPlugIn plugin, LogonCred logonCred, IEnterpriseLogonInformation info) throws oca_abuse, SDKException {
        StringHolder paramsHolder = new StringHolder();
        this.m_stub.GetParamsEx3(1200, auth, paramsHolder);
        LOG.assertNotNull((Object)paramsHolder.value, "params is null.");
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(paramsHolder.value);
        SDKPropertyBag paramsBag = new SDKPropertyBag();
        paramsBag.unpack(unpacker);
        if (this.m_loader.needParams(auth)) {
            this.m_loader.setParams(auth, paramsBag);
        }
        ByteArrayOutputStream tokenStream = new ByteArrayOutputStream();
        String serverName = this.m_handler.getSvr().getCluster();
        if (serverName != null && !serverName.equals("")) {
            int index = serverName.indexOf(64);
            serverName = serverName.substring(index + 1);
        } else {
            serverName = this.m_handler.getAPS();
        }
        int pluginStatus = logonCred.UsePassword() ? plugin.startLogin(logonCred.GetUsername(), logonCred.GetPassword(), serverName, (OutputStream)tokenStream) : plugin.startLogin(logonCred.GetGSSCredential(), logonCred.GetGSSManager(), serverName, (OutputStream)tokenStream);
        StringHolder logonPropHolder = new StringHolder();
        SeqOctetHolder logonBytesHolder = new SeqOctetHolder();
        String linfo = this.getLogonInfoURL(info);
        int serverStatus = this.m_stub.UserLogonEx4(1200, linfo, tokenStream.toByteArray(), auth, logonPropHolder, logonBytesHolder);
        while (serverStatus == 1) {
            ByteArrayOutputStream continueStream = new ByteArrayOutputStream();
            pluginStatus = plugin.continueLogin(logonBytesHolder.value, continueStream);
            serverStatus = this.m_stub.ContinueLogonEx4(1200, linfo, continueStream.toByteArray(), auth, logonPropHolder, logonBytesHolder);
            LOG.assertTrue(serverStatus == pluginStatus, "Assertion failed");
        }
        ISecuritySession session = this.createSession(this.m_handler.getAPS(), this.m_handler.getSvr().getCluster(), logonPropHolder.value);
        this.checkVersionCompatibility(session);
        if (this.checkNeedsPropagateCredentials(paramsBag) && logonCred.UsePassword()) {
            IUserInfo userInfo = session.getUserInfo();
            userInfo.setProfileString("DBUSER", logonCred.GetUsername());
            userInfo.setSecondaryCredentialEx("DBPASS", logonCred.GetPassword());
        }
        return session;
    }

    private ISecuritySession createSession(String server, String cluster, String props) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"createSession(): enter");
        }
        ISecuritySession session = null;
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(props);
        SDKPropertyBag pbh = new SDKPropertyBag();
        pbh.unpack(unpacker);
        String userHandle = pbh.getString(PropertyIDs.SESSIONID);
        String userID = pbh.getString(PropertyIDs.USERID);
        String token = server + '@' + pbh.getString(PropertyIDs.SI_FAILOVER_TOKEN);
        OcaURI userURI = new OcaURI(server, PropertyIDs.SESSIONID, userHandle);
        String userURIString = userURI.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createSession(): userID=" + userID + ",userHandler=" + userHandle + ",token=" + token + ",uri=" + userURIString));
        }
        session = pbh.getBoolean(PropertyIDs.SI_SERVER_LOGON_SESSION) ? SecurityFactory.getFactory().makeServerLogonSession(server, userURIString, token, cluster, pbh) : SecurityFactory.getFactory().makeSecuritySession(server, userURIString, token, cluster, pbh);
        LOG.assertNotNull((Object)session, "session is null.");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"createSession(): exit");
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTokenServiceStub() throws SDKException {
        _LogonEx4Proxy stub;
        IManagedService handler;
        LogonService logonService = this;
        synchronized (logonService) {
            if (this.m_stubForToken != null) {
                return;
            }
        }
        try {
            ServerSpec svrSpec = null;
            svrSpec = this.m_aps.charAt(0) == '@' ? new ServerSpec("", "aps", "", this.m_aps, null, true, false) : new ServerSpec(this.m_aps, "aps", this.m_aps, true, true);
            handler = ServiceMgrFactory.getServiceMgr().getManagedService(LOGON_WITH_TOKEN_ID, "Logon", svrSpec, "", "", new IManagedService.IHelperFactory(){

                public IManagedService.IStubHelper makeHelper() {
                    return new AbstractStubHelper(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                            return LogonEx4Helper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
                        }

                        public void release(Object object) {
                            ((LogonEx4Operations)object).free();
                        }
                    };
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getServiceStub(): got APS=" + handler.getAPS()));
            }
            stub = new _LogonEx4Proxy(handler);
        }
        catch (OCAFrameworkException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("getServiceStub(): failed to obtain logon service for " + this.m_aps), (Throwable)((Object)e));
            }
            throw SDKException.map(e);
        }
        LogonService logonService2 = this;
        synchronized (logonService2) {
            if (this.m_stubForToken != null) {
                return;
            }
            this.m_stubForToken = stub;
            this.m_handler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureServiceStub() throws SDKException {
        _LogonEx4Proxy stub;
        IManagedService handler;
        LogonService logonService = this;
        synchronized (logonService) {
            if (this.m_stub != null) {
                return;
            }
        }
        try {
            ServerSpec svrSpec = null;
            svrSpec = this.m_aps.charAt(0) == '@' ? new ServerSpec("", "aps", "", this.m_aps, null, true, false) : new ServerSpec(this.m_aps, "aps", this.m_aps, true, false);
            handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "Logon", svrSpec, "", "", new IManagedService.IHelperFactory(){

                public IManagedService.IStubHelper makeHelper() {
                    return new AbstractStubHelper(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                            return LogonEx4Helper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
                        }

                        public void release(Object object) {
                            ((LogonEx4Operations)object).free();
                        }
                    };
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getServiceStub(): got APS=" + handler.getAPS()));
            }
            stub = new _LogonEx4Proxy(handler);
        }
        catch (OCAFrameworkException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("getServiceStub(): failed to obtain logon service for " + this.m_aps), (Throwable)((Object)e));
            }
            if (e.getCause() instanceof connection_failure) {
                connection_failure cause = (connection_failure)e.getCause();
                if (cause.reason.endsWith("(FWB 00024)")) {
                    throw new SDKException.CMSDatabaseUnavailable(e);
                }
            }
            throw SDKException.map(e);
        }
        LogonService logonService2 = this;
        synchronized (logonService2) {
            if (this.m_stub != null) {
                return;
            }
            this.m_stub = stub;
            this.m_handler = handler;
        }
    }

    public String toString() {
        return "(LogonService:aps=" + this.m_aps + ", realAPS=" + this.m_handler.getAPS() + ")";
    }

    private boolean checkNeedsPropagateCredentials(IProperties props) {
        block3: {
            try {
                IProperty prop = props.getProperty(PropertyIDs.SI_UPDATE_DB_CREDENTIAL);
                if (prop != null) {
                    return (Boolean)prop.getValue();
                }
            }
            catch (ClassCastException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)"Could not cast the value of SI_UPDATE_DB_CREDENTIAL to a Boolean.", (Throwable)e);
            }
        }
        return false;
    }

    public ISecuritySession logonWithToken(String token, IEnterpriseLogonInformation info) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logonWithToken(): token=" + token + ",aps=" + this.m_aps));
        }
        this.ensureTokenServiceStub();
        Object sess = null;
        int delim = token.indexOf(64);
        String actualToken = token.substring(delim + 1);
        String linfo = this.getLogonInfoURL(info);
        try {
            StringHolder logonPropsHolder = new StringHolder();
            int status = this.m_stubForToken.LogonWithTokenEx4(1200, linfo, actualToken, logonPropsHolder);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("logonWithToken(): status=" + status));
            }
            ISecuritySession result = this.createSession(this.m_handler.getAPS(), this.m_handler.getSvr().getCluster(), logonPropsHolder.value);
            return result;
        }
        catch (oca_abuse e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("logonWithToken(): failed to logon, token=" + token), (Throwable)e);
            }
            throw SDKException.map(e);
        }
    }

    public ISecuritySession userLogon(String user, String pwd, String auth, IEnterpriseLogonInformation info) throws SDKException {
        return this.doUserLogon(new LogonCred(user, pwd), auth, info);
    }

    public ISecuritySession userLogon(GSSCredential userCreds, GSSManager manager, String auth) throws SDKException {
        return this.doUserLogon(new LogonCred(userCreds, manager), auth, this.getCurrentLogonIPInfo());
    }

    private ISecuritySession doUserLogon(LogonCred logonCred, String auth, IEnterpriseLogonInformation info) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doUserLogon(): logonCred=" + logonCred + ",auth=" + auth));
        }
        try {
            this.ensureServiceStub();
        }
        catch (SDKException.OCAFramework e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getDetailMessage());
                LOG.error((Object)"Is the CMS alive? Ensure the CMS supports SDK version 1200");
            }
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doUserLogon(): aps=" + this.m_handler.getAPS()));
        }
        ISecurityPlugIn plugin = null;
        try {
            plugin = this.m_loader.getClientAuthentication(this.m_handler.getAPS(), this.m_handler.getSvr().getCluster(), auth);
        }
        catch (SDKException.OCAFramework se) {
            if (se.getCause() instanceof OCAFrameworkException.CommunicationError) {
                throw new SDKException.UnsupportedEnterpriseVersion(1200, 900);
            }
            throw se;
        }
        LOG.assertNotNull((Object)plugin, "plugin is null.");
        ISecuritySession session = null;
        int failoverRetries = 0;
        int transientRetries = 0;
        do {
            try {
                session = this.doLogon(auth, plugin, logonCred, info);
            }
            catch (oca_abuse e) {
                message_union msg;
                message_union[] msgs;
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("doUserLogon(): failed to logon, logonCred=" + logonCred + ",auth=" + auth + ",aps=" + this.m_handler.getAPS()), (Throwable)((Object)SDKException.map(e)));
                }
                if (failoverRetries >= 2) {
                    throw SDKException.map(e);
                }
                if (e.errCode == 10499 && (msgs = e.messages).length > 0 && (msg = msgs[0]).discriminator().equals(message_type.mt_id)) {
                    message_id msg_id = msg.msgId();
                    if (msg_id.msgId == 42006) {
                        ++failoverRetries;
                        transientRetries = 0;
                        continue;
                    }
                }
                throw SDKException.map(e);
            }
            catch (IManagedService.ManagedServiceRetryException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("doUserLogon(): failed to logon, logonCred=" + logonCred + ",auth=" + auth + ",aps=" + this.m_handler.getAPS()), (Throwable)e);
                }
                if (transientRetries++ < 20) continue;
                throw new SDKException.CORBASystem(e);
            }
            catch (SDKException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("doUserLogon(): failed to logon, logonCred=" + logonCred + ",auth=" + auth + ",aps=" + this.m_handler.getAPS()), (Throwable)((Object)e));
                }
                throw e;
            }
        } while (session == null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"doUserLogon(): exit");
        }
        return session;
    }

    static {
        String hostName;
        String ip;
        LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.LogonService");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            ip = "";
            hostName = "";
        }
        s_hostname = hostName;
        s_ip = ip;
    }
}

