/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionCode;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CallFailureResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CallFailureWithMessages;
import com.crystaldecisions.sdk.occa.security.internal.serializer.ErrorStruct;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;

public class SecurityException
extends SDKException {
    public SecurityException(String[] message, Exception cause, int errorCode) {
        super(message, cause, errorCode);
    }

    public static class ErrorCode {
        public static final int Error_Unknown = 0;
        public static final int Error_BatchState = 1;
        public static final int Error_BatchFailure = 2;
    }

    public static class BatchFailure
    extends SecurityException {
        private static final String RESOURCES = "com/crystaldecisions/sdk/occa/security/internal/SecurityExceptionResources";
        private static final String ERROR_ENTRY = "ErrorEntry";
        private HashMap m_errors;

        public BatchFailure(HashMap errorResults) {
            super(new String[]{null}, null, SDKExceptionCode.Error_BatchFailure);
            this.m_errors = errorResults;
        }

        public String getDetailMessage(Locale locale) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.getDetailMessage(locale));
            buffer.append('\n');
            this.formatErrorString(locale, buffer);
            return buffer.toString();
        }

        public String getMessage(Locale locale) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.getMessage(locale));
            buffer.append('\n');
            this.formatErrorString(locale, buffer);
            return buffer.toString();
        }

        private void formatErrorString(Locale locale, StringBuffer buffer) {
            String errorEntryPattern = ResourceBundle.getBundle(RESOURCES, locale).getString(ERROR_ENTRY);
            Iterator iter = this.m_errors.values().iterator();
            while (iter.hasNext()) {
                Iterator iter1;
                String serverErrMsg;
                Object next = iter.next();
                if (next instanceof CallFailureWithMessages) {
                    CallFailureWithMessages failure = (CallFailureWithMessages)next;
                    serverErrMsg = "";
                    iter1 = failure.errorMessages.iterator();
                    while (iter1.hasNext()) {
                        ErrorStruct error = (ErrorStruct)iter1.next();
                        Object[] params = new String[error.stringReplacements.size()];
                        int i = 0;
                        Iterator iter2 = error.stringReplacements.iterator();
                        while (iter2.hasNext()) {
                            params[i] = (String)iter2.next();
                        }
                        String msgPattern = ServerMsgResourcesBundle.getString(Integer.toString(error.msgId), locale);
                        serverErrMsg = serverErrMsg + MessageFormat.format(msgPattern, params);
                        serverErrMsg = serverErrMsg + "\n";
                    }
                    buffer.append(MessageFormat.format(errorEntryPattern, new Integer(failure.index), new Byte(failure.callType), "", serverErrMsg));
                    continue;
                }
                if (!(next instanceof CallFailureResult)) continue;
                CallFailureResult error = (CallFailureResult)next;
                serverErrMsg = "";
                iter1 = error.stringResIDs.iterator();
                while (iter1.hasNext()) {
                    Integer resID = (Integer)iter1.next();
                    serverErrMsg = serverErrMsg + ServerMsgResourcesBundle.getString(resID.toString(), locale);
                    serverErrMsg = serverErrMsg + "\n";
                }
                buffer.append(MessageFormat.format(errorEntryPattern, new Integer(error.index), new Byte(error.callType), new Integer(error.errNumber), serverErrMsg));
            }
        }
    }

    public static class BatchState
    extends SecurityException {
        public BatchState() {
            super(null, null, SDKExceptionCode.Error_BatchState);
        }
    }
}

