/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.IEnterpriseLogonInformation;
import com.crystaldecisions.sdk.occa.security.internal.EnterpriseLogonInformation;
import com.crystaldecisions.sdk.occa.security.internal.ILogonService;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.PlugInLoader;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class SecurityMgr
implements ISecurityMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.SecurityMgr");
    private IServiceMgr m_serviceFactory;
    private PlugInLoader m_loader = new PlugInLoader();
    private boolean m_isServerSide = false;

    SecurityMgr() {
        this.m_serviceFactory = ServiceMgrFactory.getServiceMgr();
    }

    public ISecuritySession logonWithToken(String token, String socksURI) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logonWithToken(): token=" + token));
        }
        int delim = token.indexOf(64);
        String aps = token.substring(0, delim);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logonWithToken(): aps=" + aps + ",token=" + token));
        }
        ILogonService logon = SecurityFactory.getFactory().makeLogonService(aps);
        return logon.logonWithToken(token);
    }

    public ISecuritySession userLogon(String user, String pwd, String aps, String socksURI, String cluster, String auth) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userLogon(): user=" + user + ",aps=" + aps + ",auth=" + auth + ",cluster=" + cluster + ",socketsURI=" + socksURI));
        }
        ILogonService logon = SecurityFactory.getFactory().makeLogonService(aps);
        return logon.userLogon(user, pwd, auth);
    }

    public ISecuritySession userLogon(GSSCredential userCreds, GSSManager manager, String aps, String socksURI, String cluster, String auth) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userLogon(): aps=" + aps + ",auth=" + auth + ",cluster=" + cluster + ",socketsURI=" + socksURI));
        }
        ILogonService logon = SecurityFactory.getFactory().makeLogonService(aps);
        return logon.userLogon(userCreds, manager, auth);
    }

    public ISecuritySession getSession(String sessionID) throws SDKException {
        return SecurityFactory.getFactory().makeSecuritySession(sessionID);
    }

    public ISecuritySession getServerSession(String aps, String cluster) throws SDKException {
        return SecurityFactory.getFactory().makeServerSession(aps, cluster);
    }

    public ISecuritySession logonWithToken(String token, String socksURI, IEnterpriseLogonInformation logonInfo) throws SDKException {
        if (token.length() <= 0) {
            LOG.error((Object)("logonWithToken(): invalid logon token, token=" + token));
            throw new SDKException.InvalidLogonToken(token);
        }
        int delim = token.indexOf(64);
        if (delim == -1) {
            LOG.error((Object)("logonWithToken(): invalid logon token, token=" + token));
            throw new SDKException.InvalidLogonToken(token);
        }
        String aps = token.substring(0, delim);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logonWithToken(): aps=" + aps + ",token=" + token));
        }
        ILogonService logon = SecurityFactory.getFactory().makeLogonService(aps);
        return logon.logonWithToken(token, logonInfo);
    }

    public ISecuritySession userLogon(String user, String pwd, String server, String socksURI, String cluster, String auth, IEnterpriseLogonInformation logonInfo) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userLogon(): user=" + user + ",aps=" + server + ",auth=" + auth + ",cluster=" + cluster + ",socketsURI=" + socksURI));
        }
        ILogonService logon = SecurityFactory.getFactory().makeLogonService(server);
        return logon.userLogon(user, pwd, auth, logonInfo);
    }

    public IEnterpriseLogonInformation createLogonInfo() {
        return new EnterpriseLogonInformation();
    }
}

