/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.EmptyCollections;
import com.crystaldecisions.celib.collections.ISupportObjectLocal;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs._SessionBatchStub;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.ILogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRights;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoMgr;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.ICacheController;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRights;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

class ServerSession
implements ISecuritySession,
Externalizable,
ISupportObjectLocal {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.SecuritySession");
    private IManagedService m_handler;
    private Map m_objectLocals = EmptyCollections.MAP;

    ServerSession(String aps, String cluster) throws SDKException {
        try {
            this.init(aps, cluster);
        }
        catch (OCAFrameworkException e) {
            throw SDKException.map(e);
        }
    }

    public ServerSession() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getAPSName());
        out.writeUTF(this.getClusterName());
        out.writeObject(ServiceMgrFactory.getServiceMgr());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String aps = in.readUTF();
        String cluster = in.readUTF();
        in.readObject();
        try {
            this.init(aps, cluster);
        }
        catch (OCAFrameworkException e) {
            throw new SDKException.Serialization(e);
        }
    }

    public String getAPSName() {
        return this.m_handler.getAPS();
    }

    public int getAPSVersion() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public int getAPSVersion(boolean majorOnly) throws SDKException {
        throw new SDKException.Unexpected();
    }

    public String getAPSVersionString() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public String getClusterName() {
        return this.m_handler.getSvr().getCluster();
    }

    public IRights getRights() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public IRightsAdmin getRightsAdmin() throws SDKException {
        throw new SDKException.RightsAdmin();
    }

    public ILogonTokenMgr getLogonTokenMgr() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ICacheController getSecCache() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ICacheControllerAdmin getSecCacheAdmin() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ISecRights getRightsEx() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ISecRightsAdmin getRightsAdminEx() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ISecCacheController getSecCacheEx() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public ISecCacheControllerAdmin getSecCacheAdminEx() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public IUserInfo getUserInfo() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public String getUserURI() {
        return "osca:iiop://;S2SDSCVRY=true";
    }

    public String getLogonToken() {
        return "";
    }

    public String getSessionToken() {
        return "";
    }

    public void logoff() {
    }

    public String toString() {
        return "(ServerSession:userInfo=" + this.getAPSName() + ")";
    }

    private void init(String aps, String cluster) throws OCAFrameworkException {
        this.m_handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "Session", new ServerSpec(aps, "aps", aps, cluster), this.getUserURI(), this.getLogonToken(), new IManagedService.IHelperFactory(){

            public IManagedService.IStubHelper makeHelper() {
                return new AbstractStubHelper(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                        return object;
                    }

                    public void release(Object object) {
                    }

                    public com.crystaldecisions.thirdparty.org.omg.CORBA.Object getService(String svc, ServerSpec spec, String uri, String token) throws OCAFrameworkException {
                        return new _SessionBatchStub();
                    }
                };
            }
        });
    }

    public Map getObjectLocals() {
        return this.m_objectLocals;
    }

    public void setObjectLocals(Map sessionLocals) {
        this.m_objectLocals = sessionLocals;
    }

    public int getSDKVersion() {
        return 1200;
    }

    public String getSessionID() {
        StringBuffer sessionID = new StringBuffer();
        sessionID.append(this.getAPSName());
        sessionID.append(',');
        sessionID.append(this.getUserURI());
        sessionID.append(',');
        sessionID.append(this.getLogonToken());
        sessionID.append(',');
        sessionID.append(this.getClusterName());
        return sessionID.toString();
    }

    public int getSessionFolderID() {
        return 0;
    }

    public boolean isSessionLoggedOff() {
        return false;
    }

    public boolean isSessionExpired() {
        return false;
    }

    public void setSessionFolderID(int folderID) {
    }

    public boolean isServerLogonSession() {
        return false;
    }

    public void expire() {
    }

    public ISecurityInfoMgr getSecurityInfoMgr() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public boolean isUserDefaultLocale() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public void setUserDefaultLocale() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public Locale getLocale() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public void setLocale(Locale value) throws SDKException {
        throw new SDKException.Unexpected();
    }

    public Locale getEffectivePreferredViewingLocale() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public Map getExecutionInfo() throws SDKException {
        throw new SDKException.Unexpected();
    }

    public String getTrustedToken(String[] inputStrings, String timestampString) throws SDKException {
        throw new SDKException.Unexpected();
    }

    public IProperties getSystemInfoProperties() throws SDKException {
        throw new SDKException.Unexpected();
    }
}

