/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal.serializer;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityType;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SerializableCommand;
import java.io.NotSerializableException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public class SecuritySerializer {
    private static final int INT_LENGTH = 4;
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.serializer.SecuritySerializer");
    private byte[] m_bytes = new byte[10];
    private int m_pos = 0;

    public void writeInt(int in) {
        this.writeByte((byte)(0xFF & in >> 24));
        this.writeByte((byte)(0xFF & in >> 16));
        this.writeByte((byte)(0xFF & in >> 8));
        this.writeByte((byte)(0xFF & in));
    }

    public void writeBool(boolean in) {
        byte boolVal = (byte)(in ? 1 : 0);
        this.writeByte(boolVal);
    }

    public void writeString(String in) {
        try {
            byte[] utf8 = in.getBytes("UTF-8");
            this.writeInt(utf8.length);
            for (int i = 0; i < utf8.length; ++i) {
                byte b = utf8[i];
                this.writeByte(b);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"SecuritySerializer::writeString: java.lang.String should support UTF-8");
        }
    }

    public void writeList(List in) throws NotSerializableException {
        this.writeInt(in.size());
        if (in.size() != 0) {
            SecurityType containedType = SecuritySerializer.getType(in.get(0));
            this.writeByte(containedType.getTag());
            Iterator iter = in.iterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (containedType == SecurityType.BoolTag) {
                    this.writeBool((Boolean)val);
                    continue;
                }
                if (containedType == SecurityType.Int32Tag) {
                    this.writeInt((Integer)val);
                    continue;
                }
                if (containedType == SecurityType.Int8Tag) {
                    this.writeByte((Byte)val);
                    continue;
                }
                if (containedType == SecurityType.ListTag) {
                    this.writeList((List)val);
                    continue;
                }
                if (containedType == SecurityType.StringTag) {
                    this.writeString((String)val);
                    continue;
                }
                SerializableCommand sc = (SerializableCommand)val;
                this.writeObject(sc);
            }
        }
    }

    public void writeObject(SerializableCommand in) throws NotSerializableException {
        in.write(this);
    }

    public void writeByte(byte in) {
        if (this.m_pos >= this.m_bytes.length) {
            byte[] swap = this.m_bytes;
            this.m_bytes = new byte[this.m_bytes.length * 2];
            System.arraycopy(swap, 0, this.m_bytes, 0, swap.length);
        }
        this.m_bytes[this.m_pos] = in;
        ++this.m_pos;
    }

    public byte[] retrieveBuffer() {
        byte[] retval = new byte[this.m_pos];
        System.arraycopy(this.m_bytes, 0, retval, 0, this.m_pos);
        this.m_bytes = new byte[10];
        this.m_pos = 0;
        return retval;
    }

    private static SecurityType getType(Object val) throws NotSerializableException {
        if (val instanceof List) {
            return SecurityType.ListTag;
        }
        if (val instanceof Boolean) {
            return SecurityType.BoolTag;
        }
        if (val instanceof Long) {
            return SecurityType.Int32Tag;
        }
        if (val instanceof Byte) {
            return SecurityType.Int8Tag;
        }
        if (val instanceof String) {
            return SecurityType.StringTag;
        }
        if (val instanceof SerializableCommand) {
            return ((SerializableCommand)val).getTypeTag();
        }
        LOG.assertTrue(true, "Cannot find type tag for class " + val.getClass().getName());
        throw new NotSerializableException(val.getClass().getName());
    }
}

