/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.DirectManagedService;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.BIPTransportPOA;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.Channel;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedInputStream;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedPayload;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedRequest;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedResponse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedResponseHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.IdentityPayload;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamImpl;
import com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamStubWrapper;
import com.crystaldecisions.sdk.occa.transport.internal.EncodeableTransportEntity;
import com.crystaldecisions.sdk.occa.transport.internal.EncodingStyle;
import com.crystaldecisions.sdk.occa.transport.internal.IChannel;
import com.crystaldecisions.sdk.occa.transport.internal.IEncodingSupport;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportRequestHandler;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportService;
import com.crystaldecisions.sdk.occa.transport.internal.InputStreamCleanUp;
import com.crystaldecisions.sdk.occa.transport.internal.TransportServiceFactory;
import com.crystaldecisions.sdk.occa.transport.internal.TransportUtils;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_MEMORY;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UNKNOWN;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POA;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.WrongPolicy;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.Servant;
import java.io.IOException;
import java.io.InputStream;

public class BIPTransportImpl
extends BIPTransportPOA {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.transport.internal.BIPTransportImpl");
    private boolean m_server;
    private ITransportRequestHandler m_handler;
    private POA m_poa;
    private static InputStreamCleanUp m_streamCleanUp = InputStreamCleanUp.getInputStreamCleanUpObject();
    private static final int DEFAULT_FIRST_CHUNK_SIZE = 8192;
    private static final Any ANY_NULL = ServiceMgrFactory.getServiceMgr().getORB().create_any();

    public BIPTransportImpl(boolean server, ITransportRequestHandler handler) {
        this.m_server = server;
        this.m_handler = handler;
    }

    public BIPTransportImpl(boolean server, ITransportRequestHandler handler, POA poa) {
        this.m_server = server;
        this.m_handler = handler;
        this.m_poa = poa;
    }

    public void setHandler(ITransportRequestHandler handler) {
        this.m_handler = handler;
    }

    public POA _default_POA() {
        if (this.m_poa != null) {
            return this.m_poa;
        }
        return super._default_POA();
    }

    public int post(EncodedRequest request, EncodedResponseHolder reply) throws oca_abuse {
        ITransportEntity transportRequest = BIPTransportImpl.createTransportEntity(request);
        try {
            ITransportEntity response = this.m_handler.process(transportRequest);
            if (response == null) {
                reply.value = new EncodedResponse();
                reply.value.identityPayload(new IdentityPayload("", new byte[0]));
                return 0;
            }
            EncodingStyle style = EncodingStyle.IDENTITY;
            if (response instanceof IEncodingSupport) {
                IEncodingSupport encodingResponse = (IEncodingSupport)((Object)response);
                style = encodingResponse.getEncodingStyle();
            }
            String packedHeader = TransportUtils.packTransportHeaders(response);
            EncodedResponse encodedResponse = new EncodedResponse();
            if (style == EncodingStyle.IDENTITY) {
                byte[] out = response.getBodyAsBytes();
                IdentityPayload payload = new IdentityPayload(packedHeader, out);
                encodedResponse.identityPayload(payload);
            }
            if (style == EncodingStyle.PULLSTREAM) {
                InputStream stream = response.getBodyAsInputStream();
                int chunkSize = 8192;
                try {
                    chunkSize = stream.available();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("(post:110) chunkSize:" + chunkSize));
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Failed to retrieve chunksize.", (Throwable)ioe);
                    throw new oca_abuse(0, new message_union[0], "", ANY_NULL);
                }
                ChunkedInputStreamImpl cunkedInputStream = this.createChukedInputStreamServant(stream);
                ChunkedPayload chunkedPayLoad = new ChunkedPayload(packedHeader, chunkSize, cunkedInputStream._this());
                encodedResponse.chunkedPayload(chunkedPayLoad);
                m_streamCleanUp.addStream(cunkedInputStream);
            }
            reply.value = encodedResponse;
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"(post:129): exception from the handler", (Throwable)((Object)e));
            }
            throw new oca_abuse(0, new message_union[0], BIPTransportImpl.serializeException(e), ANY_NULL);
        }
        catch (OutOfMemoryError e) {
            LOG.warn((Object)"(post:138): out of memory error", (Throwable)e);
            throw new NO_MEMORY(e.getLocalizedMessage());
        }
        catch (SystemException t) {
            LOG.warn((Object)"(post:143): allow corba system exception to pass through", (Throwable)t);
            throw t;
        }
        catch (Throwable t) {
            LOG.warn((Object)"(post:137): unchecked exception from the handler. Convert to UNKNOWN", t);
            throw new UNKNOWN(t.getLocalizedMessage());
        }
        return 0;
    }

    private ChunkedInputStreamImpl createChukedInputStreamServant(InputStream stream) throws SDKException {
        ChunkedInputStreamImpl cunkedInputStreamServant = new ChunkedInputStreamImpl(stream);
        try {
            this._poa().activate_object((Servant)cunkedInputStreamServant);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            LOG.error((Object)"(createChukedInputStreamServant:172): ", (Throwable)servantAlreadyActive);
            throw new SDKException.Unexpected();
        }
        catch (WrongPolicy wrongPolicy) {
            LOG.error((Object)"(createChukedInputStreamServant:177): ", (Throwable)wrongPolicy);
            throw new SDKException.Unexpected();
        }
        return cunkedInputStreamServant;
    }

    public void asyncPost(EncodedRequest request, Channel callback) {
        ITransportEntity transportRequest = BIPTransportImpl.createTransportEntity(request);
        IChannel backChannel = null;
        if (this.m_server && callback != null) {
            backChannel = BIPTransportImpl.createCallbackChannel(callback);
        }
        try {
            this.m_handler.asyncProcess(transportRequest, backChannel);
        }
        catch (OutOfMemoryError e) {
            throw new NO_MEMORY(e.getLocalizedMessage());
        }
        catch (SDKException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(asyncPost:200) process error");
            }
            throw new UNKNOWN(BIPTransportImpl.serializeException(e));
        }
        catch (Throwable e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(asyncPost:174) process error", e);
            }
            throw new UNKNOWN(e.getLocalizedMessage());
        }
    }

    public void send(EncodedRequest request) {
        ITransportEntity transportRequest = BIPTransportImpl.createTransportEntity(request);
        try {
            this.m_handler.send(transportRequest);
        }
        catch (OutOfMemoryError e) {
            throw new NO_MEMORY(e.getLocalizedMessage());
        }
        catch (SDKException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(send:221) send error", (Throwable)((Object)e));
            }
            throw new UNKNOWN(BIPTransportImpl.serializeException(e));
        }
        catch (Throwable e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(send:182) unable to send back. Log ", e);
            }
            throw new UNKNOWN(e.getLocalizedMessage());
        }
    }

    public void setCallback(Channel callback) {
        if (this.m_server) {
            try {
                this.m_handler.setCallbackChannel(BIPTransportImpl.createCallbackChannel(callback));
            }
            catch (SDKException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"(setCallback:239) ", (Throwable)((Object)e));
                }
                throw new UNKNOWN(BIPTransportImpl.serializeException(e));
            }
            catch (Throwable e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"(setCallback:195) unable to set callback channel", e);
                }
                throw new UNKNOWN(e.getLocalizedMessage());
            }
        }
    }

    private static ITransportEntity createTransportEntity(EncodedRequest request) {
        EncodeableTransportEntity transportRequest = null;
        String headerBag = "";
        transportRequest = new EncodeableTransportEntity();
        if (request.discriminator().value() == 0) {
            IdentityPayload identityPayload = request.identityPayload();
            headerBag = identityPayload.headerBag;
            transportRequest.setBody(identityPayload.body);
        } else {
            ChunkedPayload chunkedPayload = request.chunkedPayload();
            headerBag = chunkedPayload.headerBag;
            ChunkedInputStream chunkedIn = chunkedPayload.body;
            ChunkedInputStreamStubWrapper wrapper = new ChunkedInputStreamStubWrapper(chunkedIn);
            transportRequest.setBody(wrapper);
        }
        TransportUtils.extractTransportHeaders(headerBag, transportRequest);
        return transportRequest;
    }

    private static IChannel createCallbackChannel(Channel callback) {
        ITransportService transportService = (ITransportService)TransportServiceFactory.getFactory().makeOCCA(new DirectManagedService((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)callback), "");
        IChannel callbackChannel = null;
        try {
            callbackChannel = transportService.createChannel("", null);
        }
        catch (SDKException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(createCallbackChannel:275) ", (Throwable)((Object)e));
            }
            throw new UNKNOWN(BIPTransportImpl.serializeException(e));
        }
        catch (Throwable e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(createCallbackChannel:231) unable to create chnnale", e);
            }
            throw new UNKNOWN(e.getLocalizedMessage());
        }
        return callbackChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String serializeException(SDKException e) {
        String serializedException;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader currentClassLoader = ITransportRequestHandler.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(currentClassLoader);
        try {
            serializedException = e.serialize();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return serializedException;
    }
}

