/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqOctetHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedInputStream;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;

public class ChunkedInputStreamStubWrapper
extends InputStream {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamStubWrapper");
    int m_available;
    private ChunkedInputStream m_inputStream;

    public ChunkedInputStreamStubWrapper(ChunkedInputStream in) {
        this.m_inputStream = in;
        this.m_available = -1;
    }

    public int read() {
        try {
            int i;
            SeqOctetHolder chunk = new SeqOctetHolder();
            StringHolder trailer = new StringHolder();
            this.m_available = i = this.m_inputStream.readChunk(1, chunk, trailer);
            byte[] value = chunk.value;
            if (value.length == 1) {
                return Array.getInt(value, 0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.readBytes(b, off, len);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        int first = this.read();
        if (first == -1) {
            return -1;
        }
        b[off] = (byte)first;
        ++off;
        int readBytes = 1;
        while (readBytes < len) {
            int leftBytes = len - readBytes;
            int shouldReadBytes = leftBytes > this.available() ? this.available() : leftBytes;
            SeqOctetHolder chunk = new SeqOctetHolder();
            StringHolder trailer = new StringHolder();
            try {
                this.m_available = this.m_inputStream.readChunk(shouldReadBytes, chunk, trailer);
            }
            catch (oca_abuse e) {
                throw new IOException(e.details);
            }
            byte[] value = chunk.value;
            System.arraycopy(value, 0, b, off, shouldReadBytes);
            if ((readBytes += shouldReadBytes) >= len || this.m_available != 0) continue;
            break;
        }
        return readBytes;
    }

    public int available() throws IOException {
        if (this.m_available == -1) {
            try {
                SeqOctetHolder chunk = new SeqOctetHolder();
                StringHolder trailer = new StringHolder();
                this.m_available = this.m_inputStream.readChunk(0, chunk, trailer);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.m_available;
    }

    public void close() throws IOException {
        if (this.m_inputStream != null) {
            this.m_inputStream.close();
        }
    }
}

