/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.transport.internal.IChannel;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportSender;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportService;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.TransportSender;

public class TransportService
implements ITransportService {
    private ISecuritySession m_session;
    private IManagedService m_stub;
    private String m_address;

    public TransportService(ISecuritySession session) {
        this.m_session = session;
    }

    public IChannel createChannel(String serviceAddress, IChannel backChannel) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, backChannel, serviceAddress, true, null);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, backChannel, this.m_address);
        }
        throw new SDKException.Unexpected();
    }

    public IChannel createChannel(String serviceAddress, IChannel backChannel, ITransportServiceHelper.IFactory helperFactory) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, backChannel, serviceAddress, true, helperFactory);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, backChannel, this.m_address);
        }
        throw new SDKException.Unexpected();
    }

    public TransportService(IManagedService stub, String address) {
        this.m_stub = stub;
        this.m_address = address;
    }

    public ITransportSender getSender(String serviceAddress) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, null, serviceAddress, false, null);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, null, this.m_address);
        }
        throw new SDKException.Unexpected();
    }

    public ITransportSender getSender(String serviceAddress, ITransportServiceHelper.IFactory helperFactory) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, null, serviceAddress, false, helperFactory);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, null, this.m_address);
        }
        throw new SDKException.Unexpected();
    }

    public ITransportSender createSender(String serviceAddress) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, null, serviceAddress, true, null);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, null, this.m_address);
        }
        throw new SDKException.Unexpected();
    }

    public ITransportSender createSender(String serviceAddress, ITransportServiceHelper.IFactory helperFactory) throws SDKException {
        if (this.m_session != null) {
            return new TransportSender(this.m_session, null, serviceAddress, true, helperFactory);
        }
        if (this.m_stub != null) {
            return new TransportSender(this.m_stub, null, this.m_address);
        }
        throw new SDKException.Unexpected();
    }
}

