/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceSpec;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class TransportUtils {
    public static final String BIP_PROTOCOL = "bip";
    public static final String LOCAL_PROTOCOL = "local";
    public static final String SERVICES_FOLDER = "services";
    public static final String SERVERS = "servers";
    public static final String DEFAULT_SERVER_KIND = "pjs";
    private static final char COOKIE_DELIMITER = '#';
    public static final String REPLACEABLE = "replaceable".toLowerCase(Locale.ENGLISH);
    public static final String PREFERABLE = "preferable".toLowerCase(Locale.ENGLISH);
    public static final String GROUP = "group".toLowerCase(Locale.ENGLISH);
    public static final String GROUP_MODE = "group_mode".toLowerCase(Locale.ENGLISH);
    public static final String CRITERIA = "criteria".toLowerCase(Locale.ENGLISH);

    /*
     * WARNING - void declaration
     */
    public static ServiceSpec parseAddress(String address) throws SDKException {
        if (address == null || address.trim().length() == 0) {
            throw new SDKException.InvalidArg();
        }
        int index = (address = address.trim()).indexOf("://");
        if (index == -1) {
            throw new SDKException.InvalidArg();
        }
        String protocol = address.substring(0, index);
        if (protocol.equalsIgnoreCase(BIP_PROTOCOL)) {
            void var12_32;
            void var10_31;
            void var11_30;
            String serviceID;
            String serviceName;
            void var26_25;
            boolean serviceShift;
            String serverName;
            String discriminator;
            String cookie;
            String clusterName;
            String apsName;
            String hostAndPath = address.substring(index + 3);
            StringTokenizer tokens = new StringTokenizer(hostAndPath, "/");
            String[] pathElements = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                pathElements[i++] = tokens.nextToken();
            }
            if (pathElements.length < 3) {
                throw new SDKException.InvalidArg();
            }
            String apsAndclusterName = pathElements[0].trim();
            if (apsAndclusterName.length() == 0) {
                throw new SDKException.InvalidArg();
            }
            int atIndex = apsAndclusterName.indexOf(64);
            if (atIndex == -1) {
                apsName = apsAndclusterName;
                clusterName = "";
            } else {
                apsName = apsAndclusterName.substring(0, atIndex).trim();
                clusterName = apsAndclusterName.substring(atIndex).trim();
            }
            String lastPart = pathElements[pathElements.length - 1].trim();
            int cookieIndex = lastPart.lastIndexOf(35);
            if (cookieIndex != -1) {
                cookie = lastPart.substring(cookieIndex + 1);
                lastPart = lastPart.substring(0, cookieIndex);
            } else {
                cookie = "";
            }
            int queryIndex = lastPart.indexOf(63);
            boolean replaceable = true;
            boolean preferable = true;
            boolean nogroup = true;
            int group = 0;
            boolean noGroupMode = true;
            int groupMode = 0;
            String criteria = "";
            if (queryIndex != -1) {
                Object groupModeStr;
                String queryStr = lastPart.substring(queryIndex + 1);
                lastPart = lastPart.substring(0, queryIndex);
                Map query = TransportUtils.parseURIQuery(queryStr);
                replaceable = TransportUtils.parseBoolean((String)query.get(REPLACEABLE), replaceable);
                preferable = TransportUtils.parseBoolean((String)query.get(PREFERABLE), preferable);
                Object groupStr = query.get(GROUP.toLowerCase(Locale.ENGLISH));
                if (groupStr != null) {
                    try {
                        group = Integer.parseInt((String)groupStr);
                        nogroup = false;
                    }
                    catch (NumberFormatException e) {
                        nogroup = true;
                        group = 0;
                    }
                } else {
                    nogroup = true;
                    group = 0;
                }
                if ((groupModeStr = query.get(GROUP_MODE)) != null) {
                    try {
                        groupMode = Integer.parseInt((String)groupModeStr);
                        noGroupMode = false;
                    }
                    catch (NumberFormatException e) {
                        noGroupMode = true;
                        groupMode = 0;
                    }
                } else {
                    noGroupMode = true;
                    groupMode = 0;
                }
                criteria = (String)query.get(CRITERIA);
            }
            if ((discriminator = pathElements[1]).equalsIgnoreCase(SERVICES_FOLDER)) {
                serverName = "";
                serviceShift = false;
            } else if (discriminator.equalsIgnoreCase(SERVERS)) {
                serverName = pathElements[2].trim();
                serviceShift = true;
            } else {
                throw new SDKException.InvalidArg();
            }
            if (pathElements.length == 4 + var26_25) {
                serviceName = pathElements[2 + var26_25];
                serviceID = lastPart;
            } else if (pathElements.length == 3 + var26_25) {
                serviceName = lastPart;
                serviceID = "";
            } else {
                throw new SDKException.InvalidArg();
            }
            if (var11_30.length() == 0) {
                replaceable = true;
            }
            ServerSpec serverSpec = new ServerSpec((String)var11_30, DEFAULT_SERVER_KIND, apsName, replaceable, preferable);
            serverSpec.setCookie(cookie);
            serverSpec.setCluster(clusterName);
            if (!nogroup) {
                serverSpec.setGroup(group);
            }
            if (!noGroupMode) {
                serverSpec.setGroupMode(groupMode);
            }
            if (criteria != null && criteria.length() != 0) {
                serverSpec.setCriteria(criteria);
            }
            ServiceSpec svcSpec = new ServiceSpec((String)var10_31, serverSpec, protocol);
            svcSpec.setId((String)var12_32);
            return svcSpec;
        }
        if (protocol.equalsIgnoreCase(LOCAL_PROTOCOL)) {
            String serviceName = address.substring(index + 3);
            return new ServiceSpec(serviceName, protocol);
        }
        throw new SDKException.InvalidArg();
    }

    private static boolean parseBoolean(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        return defaultValue;
    }

    private static Map parseURIQuery(String query) {
        if (query == null || query.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringTokenizer tokens = new StringTokenizer(query, "&");
        HashMap<String, String> parased = new HashMap<String, String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            String pair = tokens.nextToken();
            int index = pair.indexOf(61);
            if (index == -1) continue;
            try {
                parased.put(URLDecoder.decode(pair.substring(0, index), "UTF-8").toLowerCase(Locale.ENGLISH), URLDecoder.decode(pair.substring(index + 1), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return parased;
    }

    private static String toURIQuery(Map parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        StringBuffer query = new StringBuffer();
        Set keys = parameters.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)parameters.get(key);
            query.append(key).append('=').append(value);
            if (!iter.hasNext()) continue;
            query.append('&');
        }
        return query.toString();
    }

    public static String toLocalAddress(String serviceName) throws SDKException {
        return TransportUtils.toAddress(LOCAL_PROTOCOL, null, serviceName, null);
    }

    public static String toAddress(String protocol, ServerSpec spec, String serviceName, String id) throws SDKException {
        return TransportUtils.toAddress(protocol, spec, serviceName, id, null);
    }

    public static String toAddress(String protocol, ServerSpec spec, String serviceName, String id, String queryString) throws SDKException {
        if (BIP_PROTOCOL.equalsIgnoreCase(protocol)) {
            String cookie;
            String clusterName = spec.getCluster();
            String apsName = spec.getAPS();
            StringBuffer host = new StringBuffer();
            if (apsName != null && apsName.trim().length() != 0) {
                host.append(apsName);
            }
            if (clusterName != null && clusterName.trim().length() != 0) {
                if (!clusterName.startsWith("@")) {
                    host.append('@');
                }
                host.append(clusterName);
            }
            if (host.length() == 0) {
                throw new SDKException.InvalidArg();
            }
            StringBuffer address = new StringBuffer();
            address.append(BIP_PROTOCOL).append("://").append(host).append('/');
            String serverName = spec.getName();
            if (serverName != null && serverName.length() != 0) {
                address.append(SERVERS).append('/').append(serverName).append('/');
            } else {
                address.append(SERVICES_FOLDER).append('/');
            }
            if (serviceName == null || serviceName.length() == 0) {
                throw new SDKException.InvalidArg();
            }
            address.append(serviceName);
            if (id != null && id.length() != 0) {
                address.append('/').append(id);
            }
            if (queryString == null || queryString.length() == 0) {
                Map query = TransportUtils.getQueryMap(spec);
                queryString = TransportUtils.toURIQuery(query);
            }
            if (queryString != null && queryString.length() != 0) {
                address.append('?').append(queryString);
            }
            if ((cookie = spec.getCookie()) != null && cookie.length() != 0) {
                address.append('#').append(cookie);
            }
            return address.toString();
        }
        if (LOCAL_PROTOCOL.equalsIgnoreCase(protocol)) {
            if (serviceName != null && serviceName.length() != 0) {
                return "local://" + serviceName;
            }
            throw new SDKException.InvalidArg();
        }
        throw new SDKException.InvalidArg();
    }

    private static Map getQueryMap(ServerSpec spec) {
        String criteria;
        boolean preferable;
        boolean replaceable;
        HashMap<String, String> query = new HashMap<String, String>(4);
        int groupMode = spec.getGroupMode();
        if (groupMode != 0) {
            int group = spec.getGroup();
            query.put(GROUP, Integer.toString(group));
            query.put(GROUP_MODE, Integer.toString(groupMode));
        }
        if (!(replaceable = spec.isReplaceable())) {
            query.put(REPLACEABLE, Boolean.FALSE.toString());
        }
        if (!(preferable = spec.isPreferred())) {
            query.put(PREFERABLE, Boolean.FALSE.toString());
        }
        if ((criteria = spec.getCriteria()) != null && criteria.length() != 0) {
            try {
                query.put(CRITERIA, URLEncoder.encode(criteria, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return query;
    }

    public static String setQueryString(String original, String name, String value) throws SDKException {
        ServiceSpec svcSpec = TransportUtils.parseAddress(original);
        Map parameters = TransportUtils.getQueryMap(svcSpec.getServerSpec());
        String existedValue = (String)parameters.get(name);
        if (existedValue == null) {
            if (value != null && value.length() != 0) {
                parameters.put(name, value);
            }
        } else if (value == null || value.length() == 0) {
            parameters.remove(name);
        } else if (!value.equalsIgnoreCase(existedValue)) {
            parameters.put(name, value);
        }
        String query = TransportUtils.toURIQuery(parameters);
        return TransportUtils.toAddress(svcSpec.getProtocol(), svcSpec.getServerSpec(), svcSpec.getName(), svcSpec.getId(), query);
    }

    public static String packTransportHeaders(ITransportEntity request) {
        PropertyBag bag = new PropertyBag();
        Map headers = request.getHeaders();
        Set headerSet = headers.entrySet();
        Iterator iterator = headerSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            bag.addItem((Object)name, value, 0);
        }
        WireOb3Packer packer = new WireOb3Packer();
        String packedHeader = packer.pack(bag, 0, 0, true);
        return packedHeader;
    }

    public static void extractTransportHeaders(String headerBag, ITransportEntity transportRequest) {
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(headerBag);
        PropertyBag headers = new PropertyBag();
        headers.unpack((IBagUnpacker)unpacker);
        Collection props = headers.values();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Property property2 = (Property)iter.next();
            transportRequest.addHeader(PropertyIDs.idToName(property2.getID()), property2.getValue());
        }
    }
}

