/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.auditadmin.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServerAdmin;
import com.crystaldecisions.sdk.occa.enadmin.internal.IInternalAdminService;
import com.crystaldecisions.sdk.occa.enadmin.internal.IInternalServiceAdmin;
import com.crystaldecisions.sdk.occa.enadmin.internal.IServiceAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.IAuditAdmin;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.internal.IAuditAdminFactory;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class AuditAdmin
extends AbstractServerAdmin
implements IAuditAdmin,
IInternalAdminService {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.admin.auditadmin.internal.AuditAdmin");
    private static final String PROP_AUDIT_STATUS = "AuditStatus";
    private static final String PROP_AUDIT_LOG_DIR = "AuditLogFilesDirectory";
    private static Map s_factoriesByClassLoader = new HashMap(1);
    private String m_serverKind;
    private IServer m_server;
    private IInternalInfoStore m_infoStore;
    private IInternalServiceAdmin m_serverAuditAdmin;
    private IConfigProperties m_configProps = null;

    AuditAdmin() {
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        IServiceAdmin sadmin;
        super.initialize(name, admin, uri, serverObj, infoStore);
        this.initServiceAdmin("AuditAdmin");
        IProperties properties = serverObj.properties();
        IProperty serverKindProp = properties.getProperty(PropertyIDs.SI_SERVER_KIND);
        this.m_serverKind = serverKindProp != null ? (String)serverKindProp.getValue() : "";
        this.m_server = (IServer)serverObj;
        this.m_infoStore = infoStore;
        if (serverObj instanceof IServer && (sadmin = this.getServiceAdmin()) != null) {
            try {
                this.m_configProps = sadmin.getConfigProperties((IServer)serverObj, "AeQVheJwf41Bvnk6Ww1vbYs");
            }
            catch (SDKException.MissingEdge e) {
                // empty catch block
            }
        }
    }

    public void commit() throws SDKException {
        this.getServiceAdmin().commit();
    }

    public String getLogDir() throws SDKException {
        try {
            return this.getStringProp(PROP_AUDIT_LOG_DIR, this.m_configProps);
        }
        catch (NullPointerException e) {
            throw new SDKException.InvalidOperation();
        }
    }

    public Object getServerAuditAdmin() throws SDKException {
        if (this.m_serverAuditAdmin != null) {
            return this.m_serverAuditAdmin;
        }
        String kind = this.getServerKind();
        if ("".equals(kind)) {
            throw new SDKException.UnexpectedValue(PropertyIDs.SI_SERVER_KIND, (Object)"");
        }
        IAuditAdminFactory factory = this.getFactory(kind);
        if (factory == null) {
            throw new SDKException.Unexpected();
        }
        this.m_serverAuditAdmin = (IInternalServiceAdmin)factory.makeAuditAdmin();
        this.m_serverAuditAdmin.initialize(this.getServiceAdmin());
        this.getServiceAdmin().setServerObject(this.m_server);
        this.getServiceAdmin().setInfoStore(this.m_infoStore);
        return this.m_serverAuditAdmin;
    }

    public String getServerKind() throws SDKException {
        return this.m_serverKind;
    }

    public boolean getStatus() throws SDKException {
        return this.getBoolProp(PROP_AUDIT_STATUS, this.m_configProps);
    }

    public void setLogDir(String logDir) throws SDKException {
        this.getServiceAdmin().setServerProperty(PROP_AUDIT_LOG_DIR, logDir, this.m_configProps);
    }

    public void setStatus(boolean status) throws SDKException {
        this.getServiceAdmin().setServerProperty(PROP_AUDIT_STATUS, status ? new Integer(1) : new Integer(0), this.m_configProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAuditAdminFactory getFactory(String serverKind) throws SDKException {
        IAuditAdminFactory factory = null;
        Map map = s_factoriesByClassLoader;
        synchronized (map) {
            String propFileName;
            InputStream propertyStream;
            HashMap<String, IAuditAdminFactory> factories = (HashMap<String, IAuditAdminFactory>)s_factoriesByClassLoader.get(Thread.currentThread().getContextClassLoader());
            if (factories == null) {
                factories = new HashMap<String, IAuditAdminFactory>();
                s_factoriesByClassLoader.put(Thread.currentThread().getContextClassLoader(), factories);
            }
            if ((factory = (IAuditAdminFactory)factories.get(serverKind)) == null && (propertyStream = ClassLoaderHelper.getResourceAsStream((String)(propFileName = "META-INF/CrystalEnterprise.AuditAdmins/" + serverKind + ".properties"))) != null) {
                Properties infoProperties = new Properties();
                try {
                    infoProperties.load(propertyStream);
                    propertyStream.close();
                    String factoryName = infoProperties.getProperty("factory");
                    if (factoryName != null) {
                        Class clazz = ClassLoaderHelper.loadClass((String)factoryName);
                        Method method = null;
                        method = clazz.getMethod("getFactory", null);
                        factory = (IAuditAdminFactory)method.invoke(null, null);
                        factories.put(serverKind, factory);
                    }
                }
                catch (IOException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (ClassNotFoundException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (NoSuchMethodException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (SecurityException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (IllegalAccessException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (IllegalArgumentException e) {
                    throw new SDKException.Unexpected(e);
                }
                catch (InvocationTargetException e) {
                    throw new SDKException.Unexpected(e);
                }
            }
            LOG.assertNotNull((Object)factory, "factory is null.");
            return factory;
        }
    }

    public IServer getServerObject() {
        return this.m_server;
    }
}

