/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.auditadmin.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServiceAdmin;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.ICMSAuditAdmin;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.internal.AdminHelper;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

public class CMSAuditAdmin
extends AbstractServiceAdmin
implements ICMSAuditAdmin {
    private static final int eAPS_AuditBase = 65536;
    private static final int eAPS_ConcLogonSucceeded = 65537;
    private static final int eAPS_NamedLogonSucceeded = 65538;
    private static final int eAPS_LogonFailed = 65539;
    private static final int eAPS_UserLogoff = 65540;
    private static final int eAPS_PasswordChanged = 65541;
    private static final int eAPS_ObjectCreation = 65542;
    private static final int eAPS_ObjectDeletion = 65543;
    private static final int eAPS_ObjectModification = 65544;
    private static final int eAPS_JobFailsUnresponsiveJSC = 65545;
    private static final int eAPS_RightsModification = 65546;
    private static final int eAPS_MetNumSessions = 65546;
    private static final Integer CONC_LOGON_SUCCEEDED = PropertyIDs.define(Integer.toString(65537));
    private static final Integer NAMED_LOGON_SUCCEEDED = PropertyIDs.define(Integer.toString(65538));
    private static final Integer LOGON_FAILED = PropertyIDs.define(Integer.toString(65539));
    private static final Integer USER_LOGOFF = PropertyIDs.define(Integer.toString(65540));
    private static final Integer PASSWORD_CHANGED = PropertyIDs.define(Integer.toString(65541));
    private static final Integer OBJECT_CREATION = PropertyIDs.define(Integer.toString(65542));
    private static final Integer OBJECT_DELETION = PropertyIDs.define(Integer.toString(65543));
    private static final Integer OBJECT_MODIFICATION = PropertyIDs.define(Integer.toString(65544));
    private static final Integer JobFailsUnresponsiveJSC = PropertyIDs.define(Integer.toString(65545));
    private static final Integer RIGHTS_MODIFICATION = PropertyIDs.define(Integer.toString(65546));
    private static final String MET_NUM_SESSIONS = Integer.toString(65546);
    private AdminHelper m_adminHelper = new AdminHelper("AXUaxM4wcwtLqqcn7.eB5bQ", this);

    public boolean isConcurrentLogonSucceeded() throws SDKException {
        return this.m_adminHelper.isEventEnabled(CONC_LOGON_SUCCEEDED);
    }

    public void setConcurrentLogonSucceeded(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(CONC_LOGON_SUCCEEDED, value);
    }

    public boolean isNamedLogonSucceeded() throws SDKException {
        return this.m_adminHelper.isEventEnabled(NAMED_LOGON_SUCCEEDED);
    }

    public void setNamedLogonSucceeded(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(NAMED_LOGON_SUCCEEDED, value);
    }

    public boolean isLogonFailed() throws SDKException {
        return this.m_adminHelper.isEventEnabled(LOGON_FAILED);
    }

    public void setLogonFailed(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(LOGON_FAILED, value);
    }

    public boolean isUserLogoff() throws SDKException {
        return this.m_adminHelper.isEventEnabled(USER_LOGOFF);
    }

    public void setUserLogoff(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(USER_LOGOFF, value);
    }

    public boolean isPasswordChanged() throws SDKException {
        return this.m_adminHelper.isEventEnabled(PASSWORD_CHANGED);
    }

    public void setPasswordChanged(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(PASSWORD_CHANGED, value);
    }

    public boolean isFolderCreation() throws SDKException {
        return this.isObjectCreation();
    }

    public void setFolderCreation(boolean value) throws SDKException {
        this.setObjectCreation(value);
    }

    public boolean isFolderDeletion() throws SDKException {
        return this.isObjectDeletion();
    }

    public void setFolderDeletion(boolean value) throws SDKException {
        this.setObjectDeletion(value);
    }

    public boolean isFolderModification() throws SDKException {
        return this.isObjectModification();
    }

    public void setFolderModification(boolean value) throws SDKException {
        this.setObjectModification(value);
    }

    public boolean isJobIncomplete() throws SDKException {
        return this.m_adminHelper.isEventEnabled(JobFailsUnresponsiveJSC);
    }

    public void setJobIncomplete(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(JobFailsUnresponsiveJSC, value);
    }

    public boolean isObjectCreation() throws SDKException {
        return this.m_adminHelper.isEventEnabled(OBJECT_CREATION);
    }

    public void setObjectCreation(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(OBJECT_CREATION, value);
    }

    public boolean isObjectDeletion() throws SDKException {
        return this.m_adminHelper.isEventEnabled(OBJECT_DELETION);
    }

    public void setObjectDeletion(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(OBJECT_DELETION, value);
    }

    public boolean isObjectModification() throws SDKException {
        return this.m_adminHelper.isEventEnabled(OBJECT_MODIFICATION);
    }

    public void setObjectModification(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(OBJECT_MODIFICATION, value);
    }

    public boolean isRightsModification() throws SDKException {
        return this.m_adminHelper.isEventEnabled(RIGHTS_MODIFICATION);
    }

    public void setRightsModification(boolean value) throws SDKException {
        this.m_adminHelper.setAuditEvent(RIGHTS_MODIFICATION, value);
    }
}

