/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.fileserveradmin.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServerAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.admin.fileserveradmin.IFRSAdminFile;
import com.crystaldecisions.sdk.plugin.admin.fileserveradmin.IFileServerAdmin;
import com.crystaldecisions.sdk.plugin.admin.fileserveradmin.internal.FRSAdminFile;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Iterator;

class FileServerAdmin
extends AbstractServerAdmin
implements IFileServerAdmin {
    private IConfigProperties m_configProps = null;

    FileServerAdmin() {
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        super.initialize(name, admin, uri, serverObj, infoStore);
        this.initServiceAdmin("FileServerAdmin");
        String cuid = null;
        if (((IServer)serverObj).getFriendlyName().startsWith("Input")) {
            cuid = "AS_dBBbeTzhHsHnTq8C1Zr8";
        } else if (((IServer)serverObj).getFriendlyName().startsWith("Output")) {
            cuid = "Ab398Kjs_91JgsTdTWDUWQc";
        } else {
            throw new SDKException.ServiceNotFound("InputFileService/OutputFileService", null);
        }
        if (serverObj instanceof IServer) {
            this.m_configProps = this.getServiceAdmin().getConfigProperties((IServer)serverObj, cuid);
        }
    }

    public String getRootDirectory() throws SDKException {
        return this.getStringProp("RootDirectory", this.m_configProps);
    }

    public void setRootDirectory(String s) throws SDKException {
        this.getServiceAdmin().setServerProperty("RootDirectory", s, this.m_configProps);
    }

    public int getMaxIdleTime() throws SDKException {
        return this.getIntProp("ServerMaxIdleTime", this.m_configProps);
    }

    public void setMaxIdleTimeUpdate(int n) throws SDKException {
        this.getServiceAdmin().setServerProperty("ServerMaxIdleTime", new Integer(n), this.m_configProps);
    }

    public int getMaxIdleTimeUpdate() throws SDKException {
        return this.getIntProp("ServerMaxIdleTime", this.m_configProps);
    }

    public void commit() throws SDKException {
        this.getServiceAdmin().commit();
    }

    public String getHostname() throws SDKException {
        return this.getStringMetric("FRSHostname");
    }

    public double getBytesWritten() throws SDKException {
        return this.getDoubleMetric("FRSNumBytesWritten");
    }

    public double getBytesSent() throws SDKException {
        return this.getDoubleMetric("FRSNumBytesSent");
    }

    public int getClientConnections() throws SDKException {
        return this.getIntMetric("FRSNumClientConnections");
    }

    public double getAvailableDiskSpace() throws SDKException {
        return this.getDoubleMetric("FRSAvailableDiskSpace");
    }

    public double getDiskSpaceLeft() throws SDKException {
        return this.getDoubleMetric("FRSDiskSpaceLeft");
    }

    public double getTotalDiskSpace() throws SDKException {
        return this.getDoubleMetric("FRSTotalDiskSpace");
    }

    public double getAvailableDiskPercent() throws SDKException {
        return this.getDoubleMetric("FRSAvailableDiskPercent");
    }

    public IFRSAdminFile[] getListActiveFiles() throws SDKException {
        String uri = this.getStringMetric("FRSListActiveFiles");
        if (uri != null) {
            WireOb3Unpacker unpacker = new WireOb3Unpacker();
            unpacker.initialize(uri);
            SDKPropertyBag connectionsBag = new SDKPropertyBag();
            connectionsBag.merge(unpacker);
            PropertyArrayHelper pahOuter = new PropertyArrayHelper((PropertyBag)connectionsBag, PropertyIDs.SI_TOTAL);
            if (pahOuter == null) {
                return null;
            }
            int size = pahOuter.size();
            if (size == 0) {
                return null;
            }
            Iterator outerIter = pahOuter.iterator();
            int i = 0;
            IFRSAdminFile[] activeFiles = new FRSAdminFile[size];
            while (outerIter.hasNext()) {
                Object x = outerIter.next();
                if (x != null) {
                    PropertyBag bag = (PropertyBag)x;
                    activeFiles[i] = new FRSAdminFile(bag);
                }
                ++i;
            }
            return activeFiles;
        }
        return null;
    }
}

