/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.ldap.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import com.crystaldecisions.sdk.plugin.authentication.ldap.IsecLDAP;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPHostInfoHelper;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

class LDAPDesktop
extends AbstractInfoObject
implements IsecLDAP {
    private static final Integer AUTHPLUGINS = new Integer(26);

    private IProperty getPropertyWrapper(Integer id) throws SDKException {
        IProperty prop = this.getProperty(id);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(id);
        }
        return prop;
    }

    LDAPDesktop() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, AUTHPLUGINS);
    }

    public void setServerAdminPassword(String password) {
        this.setProperty((Object)PropertyIDs.SI_APS_ADMIN_PWD, AuthUtil.encryptPassword(password));
    }

    public void setReferralAdminPassword(String password) {
        this.setProperty((Object)PropertyIDs.SI_REFERRAL_PWD, AuthUtil.encryptPassword(password));
    }

    public void setImportUsers(boolean bImportUsers) {
        this.setProperty((Object)PropertyIDs.SI_IMPORT_USERS, bImportUsers ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getServerAuthStrength() throws SDKException {
        Integer strength = (Integer)this.getPropertyWrapper(PropertyIDs.SI_SSL_SERVER_AUTH_STRENGTH).getValue();
        return strength;
    }

    public void setServerAuthStrength(int strength) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_SSL_SERVER_AUTH_STRENGTH, new Integer(strength));
    }

    public String getCertificateDBPath() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_CERTIFICATE_DB_PATH).getValue();
    }

    public void setCertificateDBPath(String path) {
        this.setProperty((Object)PropertyIDs.SI_CERTIFICATE_DB_PATH, path);
    }

    public String getKeyDBPath() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_KEY_DB_PATH).getValue();
    }

    public void setKeyDBPath(String path) {
        this.setProperty((Object)PropertyIDs.SI_KEY_DB_PATH, path);
    }

    public String getKeyDBPassword() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_KEY_DB_PWD).getValue();
    }

    public void setKeyDBPassword(String password) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_KEY_DB_PWD, LDAPHostInfoHelper.validateUserInput(password, true));
    }

    public boolean isImportUsers() throws SDKException {
        Boolean bIsImportUsers = (Boolean)this.getPropertyWrapper(PropertyIDs.SI_IMPORT_USERS).getValue();
        return bIsImportUsers;
    }

    public void setCreateNamedUsers(boolean bCreateNamedUsers) {
        this.setProperty((Object)PropertyIDs.SI_CREATE_NAMEDUSERS, bCreateNamedUsers ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isCreateNamedUsers() throws SDKException {
        Boolean bCreateNamedUsers = (Boolean)this.getPropertyWrapper(PropertyIDs.SI_CREATE_NAMEDUSERS).getValue();
        return bCreateNamedUsers;
    }

    public int getAuthType() throws SDKException {
        Integer type = (Integer)this.getPropertyWrapper(PropertyIDs.SI_AUTH_TYPE).getValue();
        return type;
    }

    public void setAuthType(int type) {
        this.setProperty((Object)PropertyIDs.SI_AUTH_TYPE, new Integer(type));
    }

    public String getClientCertificateNickName() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_CLIENT_CERT_NICKNAME).getValue();
    }

    public void setClientCertificateNickName(String path) {
        this.setProperty((Object)PropertyIDs.SI_CLIENT_CERT_NICKNAME, path);
    }

    public int getAvailability() throws SDKException {
        return (Integer)this.getPropertyWrapper(PropertyIDs.SI_AVAIL).getValue();
    }

    public void setAvailability(int value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_AVAIL, new Integer(value));
    }

    public String getHostAndPort() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_HOST_AND_PORT).getValue();
    }

    public void setHostAndPort(String value) {
        this.setProperty((Object)PropertyIDs.SI_HOST_AND_PORT, value);
    }

    public String getBaseDN() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_BASE_DN).getValue();
    }

    public void setBaseDN(String value) {
        this.setProperty((Object)PropertyIDs.SI_BASE_DN, value);
    }

    public String getMappedGroups() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_MAPPED_GROUPS).getValue();
    }

    public void setMappedGroups(String value) {
        this.setProperty((Object)PropertyIDs.SI_MAPPED_GROUPS, value);
    }

    public String getReferralDN() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_REFERRAL_DN).getValue();
    }

    public void setReferralDN(String value) {
        this.setProperty((Object)PropertyIDs.SI_REFERRAL_DN, value);
    }

    public String getServerAdminDN() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_APS_ADMIN_DN).getValue();
    }

    public void setServerAdminDN(String value) {
        this.setProperty((Object)PropertyIDs.SI_APS_ADMIN_DN, value);
    }

    public int getMaxReferralHops() throws SDKException {
        return (Integer)this.getPropertyWrapper(PropertyIDs.SI_MAX_REFERRAL_HOPS).getValue();
    }

    public void setMaxReferralHops(int value) {
        this.setProperty((Object)PropertyIDs.SI_MAX_REFERRAL_HOPS, new Integer(value));
    }

    public String getUserObjectClass() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_USER_ATTR).getValue();
    }

    public void setUserObjectClass(String value) {
        this.setProperty((Object)PropertyIDs.SI_USER_ATTR, value);
    }

    public String getStaticGroupObjectClass() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_STATIC_GROUP_ATTR).getValue();
    }

    public void setStaticGroupObjectClass(String value) {
        this.setProperty((Object)PropertyIDs.SI_STATIC_GROUP_ATTR, value);
    }

    public String getDynamicGroupObjectClass() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_DYNAMIC_GROUP_ATTR).getValue();
    }

    public void setDynamicGroupObjectClass(String value) {
        this.setProperty((Object)PropertyIDs.SI_DYNAMIC_GROUP_ATTR, value);
    }

    public String getGroupMemberAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_STATIC_GROUP_MEMBER_ATTR).getValue();
    }

    public void setGroupMemberAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_STATIC_GROUP_MEMBER_ATTR, value);
    }

    public String getGroupMemberUrlAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_DYNAMIC_GROUP_URL_ATTR).getValue();
    }

    public void setGroupMemberUrlAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_DYNAMIC_GROUP_URL_ATTR, value);
    }

    public String getDefaultUserSearchAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_DEFAULT_USER_SEARCH_ATTR).getValue();
    }

    public void setDefaultUserSearchAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_DEFAULT_USER_SEARCH_ATTR, value);
    }

    public String getDefaultGroupSearchAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_DEFAULT_GROUP_SEARCH_ATTR).getValue();
    }

    public void setDefaultGroupSearchAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_DEFAULT_GROUP_SEARCH_ATTR, value);
    }

    public String getUserDescriptionAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_USER_DESC_ATTR).getValue();
    }

    public void setUserDescriptionAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_USER_DESC_ATTR, value);
    }

    public String getGroupDescriptionAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_GROUP_DESC_ATTR).getValue();
    }

    public void setGroupDescriptionAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_GROUP_DESC_ATTR, value);
    }

    public String getObjectClassAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_OBJECT_CLASS_ATTR).getValue();
    }

    public void setObjectClassAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_OBJECT_CLASS_ATTR, value);
    }

    public int getMaxEntriesPerOrQuery() throws SDKException {
        return (Integer)this.getPropertyWrapper(PropertyIDs.SI_MAX_ENTRIES_PER_OR_QUERY).getValue();
    }

    public void setMaxEntriesPerOrQuery(int value) {
        this.setProperty((Object)PropertyIDs.SI_MAX_ENTRIES_PER_OR_QUERY, new Integer(value));
    }

    public boolean isAliasAutoAdd() throws SDKException {
        return (Boolean)this.getPropertyWrapper(PropertyIDs.SI_ALIAS_AUTOADD).getValue();
    }

    public void setAliasAutoAdd(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_ALIAS_AUTOADD, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSSOEnabled() throws SDKException {
        Integer ssoEnabled = (Integer)this.getPropertyWrapper(PropertyIDs.SI_SSO_ENABLED).getValue();
        return ssoEnabled != 0;
    }

    public void setSSOEnabled(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_ENABLED, value ? new Integer(1) : new Integer(0));
    }

    public int getSSOVendor() throws SDKException {
        Integer ssoVendor = (Integer)this.getPropertyWrapper(PropertyIDs.SI_SSO_VENDOR).getValue();
        return ssoVendor;
    }

    public void setSSOVendor(int value) throws SDKException {
        if (value < 0 || value > 1) {
            throw new SDKException.InvalidArg(value);
        }
        this.setProperty((Object)PropertyIDs.SI_SSO_VENDOR, new Integer(value));
    }

    public String getSSOServersAndPorts() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_SSO_SERVERS_AND_PORTS).getValue();
    }

    public void setSSOServersAndPorts(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_SERVERS_AND_PORTS, value);
    }

    public void setSSOSharedSecret(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_SHARED_SECRET, AuthUtil.encryptPassword(value));
    }

    public String getSSOAgent() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_SSO_AGENT).getValue();
    }

    public void setSSOAgent(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_AGENT, value);
    }

    public int getSSOAccessMode() throws SDKException {
        return (Integer)this.getPropertyWrapper(PropertyIDs.SI_SSO_ACCESS_MODE).getValue();
    }

    public void setSSOAccessMode(int value) throws SDKException {
        if (value < 0 || value > 2) {
            throw new SDKException.InvalidArg(value);
        }
        this.setProperty((Object)PropertyIDs.SI_SSO_ACCESS_MODE, new Integer(value));
    }

    public String getUserNameAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_USER_NAME_ATTR).getValue();
    }

    public void setUserNameAttribute(String value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_USER_NAME_ATTR, value);
    }

    public String getUserFullNameAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_USER_FULL_NAME_ATTR).getValue();
    }

    public void setUserFullNameAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_USER_FULL_NAME_ATTR, value);
    }

    public String getUserEmailAttribute() throws SDKException {
        return (String)this.getPropertyWrapper(PropertyIDs.SI_USER_EMAIL_ATTR).getValue();
    }

    public void setUserEmailAttribute(String value) {
        this.setProperty((Object)PropertyIDs.SI_USER_EMAIL_ATTR, value);
    }

    public boolean isAttributeBindingEnabled() throws SDKException {
        return (Boolean)this.getPropertyWrapper(PropertyIDs.SI_ENABLE_ATTR_BINDING).getValue();
    }

    public void setAttributeBindingEnabled(boolean isEnabled) {
        this.setProperty((Object)PropertyIDs.SI_ENABLE_ATTR_BINDING, isEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getAttributeBindingPriority() throws SDKException {
        return (Integer)this.getPropertyWrapper(PropertyIDs.SI_ATTR_BINDING_PRIORITY).getValue();
    }

    public void setAttributeBindingPriority(int value) {
        this.setProperty((Object)PropertyIDs.SI_ATTR_BINDING_PRIORITY, new Integer(value));
    }
}

