/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.ldap.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.misc.CharacterHelper;
import com.crystaldecisions.celib.misc.StringPatternHelper;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class LDAPHostInfoHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPHostInfoHelper");
    static final char ESCAPE_CHAR = '^';
    static final char HOST_SEPARATOR = '*';
    static final char HOST_DB_ELEMENT_SEPARATOR = '=';
    static final char UNENCRYPTED_PWD_INDICATOR = '&';
    static final String HOST_SEPARATOR_STR = CharacterHelper.toString((char)'*');
    static final String HOST_DB_ELEMENT_SEPARATOR_STR = CharacterHelper.toString((char)'=');
    static final String UNENCRYPTED_PWD_INDICATOR_STR = CharacterHelper.toString((char)'&');
    static final char[] SYMBOLS = new char[]{'*', '=', '&'};
    private static String s_shortHostName;
    private static String s_fqHostName;
    private static String s_ip;

    LDAPHostInfoHelper() {
    }

    static String validateUserInput(String userInput, boolean doEncrypt) {
        if (userInput == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        List hosts = StringPatternHelper.split((String)userInput, (String)HOST_SEPARATOR_STR, (char)'^');
        Iterator iter = hosts.iterator();
        while (iter.hasNext()) {
            String hostInfo = (String)iter.next();
            List dbElement = StringPatternHelper.split((String)hostInfo, (String)HOST_DB_ELEMENT_SEPARATOR_STR, (char)'^');
            String host = null;
            String element = null;
            if (dbElement.size() == 1) {
                element = (String)dbElement.get(0);
            } else {
                LOG.assertTrue(dbElement.size() == 2, "validateUserInput(): element isn't parsed correctly");
                host = (String)dbElement.get(0);
                element = (String)dbElement.get(1);
            }
            if (doEncrypt && !"".equals(element) && element.charAt(0) == '&') {
                String realElement = StringPatternHelper.unformat((String)element.substring(1), (char)'^');
                element = StringPatternHelper.format((String)AuthUtil.encryptPassword(realElement), (char)'^', (char[])SYMBOLS);
            }
            if (ret.length() > 0) {
                ret.append(HOST_SEPARATOR_STR);
            }
            if (host != null) {
                ret.append(host);
                ret.append(HOST_DB_ELEMENT_SEPARATOR_STR);
            }
            ret.append(element);
        }
        return ret.toString();
    }

    static String findBestMatch(String hostInfoString, boolean doDecrypt, String matchPath) throws SDKException {
        List matches = LDAPHostInfoHelper.findHostElement(hostInfoString, doDecrypt);
        int numHosts = matches.size();
        if (matchPath != null && numHosts > 1) {
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                String nextPath = (String)iter.next();
                File file = new File(nextPath, matchPath);
                if (!file.isFile()) continue;
                return nextPath;
            }
        } else if (numHosts > 0) {
            return (String)matches.get(0);
        }
        return "";
    }

    static List findHostElement(String hostInfoString, boolean doDecrypt) throws SDKException {
        ArrayList<String> matches = new ArrayList<String>();
        List hosts = StringPatternHelper.split((String)hostInfoString, (String)HOST_SEPARATOR_STR, (char)'^');
        Iterator iter = hosts.iterator();
        while (iter.hasNext()) {
            String hostInfo = (String)iter.next();
            List dbElement = StringPatternHelper.split((String)hostInfo, (String)HOST_DB_ELEMENT_SEPARATOR_STR, (char)'^');
            String host = null;
            String element = null;
            if (dbElement.size() == 1) {
                element = (String)dbElement.get(0);
            } else if (dbElement.size() == 2) {
                host = (String)dbElement.get(0);
                element = (String)dbElement.get(1);
            } else {
                LOG.assertTrue(dbElement.size() <= 2, "Input host string error");
            }
            if (element == null || host != null && !host.equals(s_shortHostName) && !host.equals(s_fqHostName) && !host.equals(s_ip)) continue;
            String bestMatch = StringPatternHelper.unformat((String)element, (char)'^');
            if (doDecrypt) {
                bestMatch = AuthUtil.decryptPassword(bestMatch);
            }
            matches.add(bestMatch);
        }
        return matches;
    }

    static {
        try {
            InetAddress netAddr = InetAddress.getLocalHost();
            s_shortHostName = netAddr.getHostName();
            try {
                Method method = InetAddress.class.getMethod("getCanonicalHostName", null);
                s_fqHostName = (String)method.invoke(null, null);
            }
            catch (Exception e) {
                s_fqHostName = s_shortHostName;
            }
            s_ip = netAddr.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Fail to get local host", (Throwable)e);
        }
    }
}

