/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.calendar.internal;

import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.SDate;
import java.util.Comparator;

public class SCalendarDay {
    private int m_WeekOfMonth;
    private int m_DayOfWeek;
    private int m_Group;
    private SDate m_StartDate;
    private SDate m_EndDate;

    SCalendarDay(int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear, int dayOfWeek, int weekOfMonth, int group) {
        this.m_DayOfWeek = dayOfWeek;
        this.m_WeekOfMonth = weekOfMonth;
        this.m_Group = group;
        this.m_StartDate = new SDate(startDay, startMonth, startYear, true);
        this.m_EndDate = new SDate(endDay, endMonth, endYear, false);
    }

    SCalendarDay(SCalendarDay inDay) {
        this.m_StartDate = inDay.getStartDate();
        this.m_EndDate = inDay.getEndDate();
        this.m_DayOfWeek = inDay.getDayOfWeek();
        this.m_WeekOfMonth = inDay.getWeekOfMonth();
        this.m_Group = inDay.getGroup();
    }

    public static int calculateWeekOfMonth(int day) {
        return (day - 1) / 7 + 1;
    }

    public int getStartDay() {
        return this.m_StartDate.getDay();
    }

    public int getStartMonth() {
        return this.m_StartDate.getMonth();
    }

    public int getStartYear() {
        return this.m_StartDate.getYear();
    }

    public int getEndDay() {
        return this.m_EndDate.getDay();
    }

    public int getEndMonth() {
        return this.m_EndDate.getMonth();
    }

    public int getEndYear() {
        return this.m_EndDate.getYear();
    }

    public int getWeekOfMonth() {
        return this.m_WeekOfMonth;
    }

    public int getDayOfWeek() {
        return this.m_DayOfWeek;
    }

    public int getGroup() {
        return this.m_Group;
    }

    public SDate getStartDate() {
        return this.m_StartDate;
    }

    public SDate getEndDate() {
        return this.m_EndDate;
    }

    public boolean isPattern() {
        return this.m_StartDate.isPattern() && this.m_EndDate.isPattern();
    }

    public boolean equals(Object obj) {
        SCalendarDay inCal = (SCalendarDay)obj;
        return inCal.getStartDate().equals(this.m_StartDate) && inCal.getEndDate().equals(this.m_EndDate) && inCal.getDayOfWeek() == this.m_DayOfWeek && inCal.getWeekOfMonth() == this.m_WeekOfMonth && inCal.getGroup() == this.m_Group;
    }

    public int hashCode() {
        return this.getStartDay() + this.getStartMonth() + this.getStartYear() + this.getEndDay() + this.getEndMonth() + this.getEndYear() + this.m_DayOfWeek + this.m_WeekOfMonth + this.m_Group;
    }

    public static int sortBy_StartDate_EndDate_WeekOfMonth_DayOfWeek(SCalendarDay left, SCalendarDay right) {
        if (left.getGroup() < right.getGroup()) {
            return -1;
        }
        if (left.getGroup() > right.getGroup()) {
            return 1;
        }
        if (left.getStartYear() < right.getStartYear()) {
            return -1;
        }
        if (left.getStartYear() > right.getStartYear()) {
            return 1;
        }
        if (left.getStartMonth() < right.getStartMonth()) {
            return -1;
        }
        if (left.getStartMonth() > right.getStartMonth()) {
            return 1;
        }
        if (left.getStartDay() < right.getStartDay()) {
            return -1;
        }
        if (left.getStartDay() > right.getStartDay()) {
            return 1;
        }
        if (left.getEndYear() < right.getEndYear()) {
            return -1;
        }
        if (left.getEndYear() > right.getEndYear()) {
            return 1;
        }
        if (left.getEndMonth() < right.getEndMonth()) {
            return -1;
        }
        if (left.getEndMonth() > right.getEndMonth()) {
            return 1;
        }
        if (left.getEndDay() < right.getEndDay()) {
            return -1;
        }
        if (left.getEndDay() > right.getEndDay()) {
            return 1;
        }
        if (left.getWeekOfMonth() < right.getWeekOfMonth()) {
            return -1;
        }
        if (left.getWeekOfMonth() > right.getWeekOfMonth()) {
            return 1;
        }
        if (left.getDayOfWeek() < right.getDayOfWeek()) {
            return -1;
        }
        if (left.getDayOfWeek() > right.getDayOfWeek()) {
            return 1;
        }
        return 0;
    }

    public static int sortBy_StartDate_EndDate_DayOfWeek_WeekOfMonth(SCalendarDay left, SCalendarDay right) {
        if (left.getGroup() < right.getGroup()) {
            return -1;
        }
        if (left.getGroup() > right.getGroup()) {
            return 1;
        }
        if (left.getStartYear() < right.getStartYear()) {
            return -1;
        }
        if (left.getStartYear() > right.getStartYear()) {
            return 1;
        }
        if (left.getStartMonth() < right.getStartMonth()) {
            return -1;
        }
        if (left.getStartMonth() > right.getStartMonth()) {
            return 1;
        }
        if (left.getStartDay() < right.getStartDay()) {
            return -1;
        }
        if (left.getStartDay() > right.getStartDay()) {
            return 1;
        }
        if (left.getEndYear() < right.getEndYear()) {
            return -1;
        }
        if (left.getEndYear() > right.getEndYear()) {
            return 1;
        }
        if (left.getEndMonth() < right.getEndMonth()) {
            return -1;
        }
        if (left.getEndMonth() > right.getEndMonth()) {
            return 1;
        }
        if (left.getEndDay() < right.getEndDay()) {
            return -1;
        }
        if (left.getEndDay() > right.getEndDay()) {
            return 1;
        }
        if (left.getDayOfWeek() < right.getDayOfWeek()) {
            return -1;
        }
        if (left.getDayOfWeek() > right.getDayOfWeek()) {
            return 1;
        }
        if (left.getWeekOfMonth() < right.getWeekOfMonth()) {
            return -1;
        }
        if (left.getWeekOfMonth() > right.getWeekOfMonth()) {
            return 1;
        }
        return 0;
    }

    public static int sortBy_DayOfWeek_WeekOfMonth_StartDate_EndDate(SCalendarDay left, SCalendarDay right) {
        if (left.getGroup() < right.getGroup()) {
            return -1;
        }
        if (left.getGroup() > right.getGroup()) {
            return 1;
        }
        if (left.getDayOfWeek() < right.getDayOfWeek()) {
            return -1;
        }
        if (left.getDayOfWeek() > right.getDayOfWeek()) {
            return 1;
        }
        if (left.getWeekOfMonth() < right.getWeekOfMonth()) {
            return -1;
        }
        if (left.getWeekOfMonth() > right.getWeekOfMonth()) {
            return 1;
        }
        if (left.getStartYear() < right.getStartYear()) {
            return -1;
        }
        if (left.getStartYear() > right.getStartYear()) {
            return 1;
        }
        if (left.getStartMonth() < right.getStartMonth()) {
            return -1;
        }
        if (left.getStartMonth() > right.getStartMonth()) {
            return 1;
        }
        if (left.getStartDay() < right.getStartDay()) {
            return -1;
        }
        if (left.getStartDay() > right.getStartDay()) {
            return 1;
        }
        if (left.getEndYear() < right.getEndYear()) {
            return -1;
        }
        if (left.getEndYear() > right.getEndYear()) {
            return 1;
        }
        if (left.getEndMonth() < right.getEndMonth()) {
            return -1;
        }
        if (left.getEndMonth() > right.getEndMonth()) {
            return 1;
        }
        if (left.getEndDay() < right.getEndDay()) {
            return -1;
        }
        if (left.getEndDay() > right.getEndDay()) {
            return 1;
        }
        return 0;
    }

    public static class DayofweekWeekofmonthStartdateEnddate
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return SCalendarDay.sortBy_DayOfWeek_WeekOfMonth_StartDate_EndDate((SCalendarDay)o1, (SCalendarDay)o2);
        }
    }

    public static class BegindateEnddateDayofweekWeekofmonth
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return SCalendarDay.sortBy_StartDate_EndDate_DayOfWeek_WeekOfMonth((SCalendarDay)o1, (SCalendarDay)o2);
        }
    }

    public static class BegindateEnddateWeekofmonthDayofweek
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return SCalendarDay.sortBy_StartDate_EndDate_WeekOfMonth_DayOfWeek((SCalendarDay)o1, (SCalendarDay)o2);
        }
    }
}

