/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.ICategoryContent;
import com.crystaldecisions.sdk.occa.infostore.IContent;
import com.crystaldecisions.sdk.occa.infostore.IFile;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSchedulableObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.common.IDestinationProgIDs;
import com.crystaldecisions.sdk.plugin.desktop.common.IDynamicRecipientVariableMappings;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationDocumentVariableMappings;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.PublicationInfoHelper;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractContentObject
extends AbstractSchedulableObject
implements IInfoObject,
IContent,
ICategoryContent {
    private String m_mimeType;
    private IPublicationInfo m_publicationInfoHelper;
    private int m_fileIndex;

    protected AbstractContentObject(int fileIndex, String mimeType) {
        this.m_fileIndex = fileIndex;
        this.m_mimeType = mimeType;
    }

    protected void setMimeType(String mimeType) {
        this.m_mimeType = mimeType;
    }

    private IPublicationInfo getPubInfoHelper() {
        if (this.m_publicationInfoHelper == null) {
            this.m_publicationInfoHelper = new PublicationInfoHelper(this.properties(), this.isNew());
        }
        return this.m_publicationInfoHelper;
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
    }

    public void unpack(ISecuritySession session, IInfoObjects collection, info_wire_ob3 obj) {
        super.unpack(session, collection, obj);
    }

    public byte[] getContent() throws SDKException {
        byte[] data;
        IFiles files = this.getFiles();
        IRemoteFile contentFile = (IRemoteFile)files.get(this.m_fileIndex);
        if (contentFile.download(data = new byte[(int)contentFile.getSize()])) {
            contentFile.commit();
            return data;
        }
        return null;
    }

    public InputStream getInputStream() throws SDKException {
        IFiles files = this.getFiles();
        IRemoteFile contentFile = (IRemoteFile)files.get(this.m_fileIndex);
        return contentFile.getInputStream();
    }

    public void writeContent(OutputStream output) throws SDKException {
        IFiles files = this.getFiles();
        IRemoteFile contentFile = (IRemoteFile)files.get(this.m_fileIndex);
        if (contentFile.download(output)) {
            contentFile.commit();
        }
    }

    public long getContentLength() throws SDKException {
        IFiles files = this.getFiles();
        IFile contentFile = (IFile)files.get(this.m_fileIndex);
        return contentFile.getSize();
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public boolean isUnmanagedDestinationSupported() {
        return true;
    }

    public Object getPluginProcessingInterface(String kind) throws SDKException {
        IPluginInfo pluginInfo;
        String scheduleProgID = this.getScheduleProgID();
        IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA("", this.getSession());
        if (kind == null || kind.length() == 0) {
            if (scheduleProgID == null && (scheduleProgID = this.getProgID()) == null) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_PROGID);
            }
            kind = scheduleProgID;
        }
        if ((pluginInfo = pluginMgr.getPluginInfo(kind)).isSchedulable() && !pluginInfo.getProgID().equals("CrystalEnterprise.Destination")) {
            if (pluginInfo.getProgID().equals(this.getProgID())) {
                return this;
            }
            if (null != scheduleProgID && pluginInfo.getProgID().equals(scheduleProgID) || null == scheduleProgID) {
                IInternalInfoObject obj = (IInternalInfoObject)pluginMgr.getPluginInterface(pluginInfo.getProgID(), "desktop");
                obj.useAsDelegate(this);
                return obj;
            }
        }
        throw new SDKException.InvalidOperation();
    }

    protected String getScheduleProgID() {
        IProperties props = this.properties();
        IProperty prop = props.getProperty(PropertyIDs.SI_PROGID_MACHINE);
        return prop != null ? (String)prop.getValue() : null;
    }

    public Set getCorporateCategories() throws SDKException {
        return super.getCorporateCategories();
    }

    public Set getPersonalCategories() throws SDKException {
        return super.getPersonalCategories();
    }

    public boolean isPublicationJob() throws SDKException {
        return this.getPubInfoHelper().isPublicationJob();
    }

    public void setPublicationJob(boolean value) {
        this.getPubInfoHelper().setPublicationJob(value);
    }

    public boolean isPublicationGlobalDeliveryRuleJob() throws SDKException {
        return this.getPubInfoHelper().isPublicationGlobalDeliveryRuleJob();
    }

    public void setPublicationGlobalDeliveryRuleJob(boolean value) {
        this.getPubInfoHelper().setPublicationGlobalDeliveryRuleJob(value);
    }

    public boolean isShowAllDataForNullProfileValues() throws SDKException {
        return this.getPubInfoHelper().isShowAllDataForNullProfileValues();
    }

    public void setShowAllDataForNullProfileValues(boolean value) throws SDKException {
        this.getPubInfoHelper().setShowAllDataForNullProfileValues(value);
    }

    public int getScopeID() throws SDKException {
        return this.getPubInfoHelper().getScopeID();
    }

    public void setScopeID(int scopeID) {
        this.getPubInfoHelper().setScopeID(scopeID);
    }

    public long getMultiPassBursting() throws SDKException {
        return this.getPubInfoHelper().getMultiPassBursting();
    }

    public void setMultiPassBursting(long multiPassBursting) {
        this.getPubInfoHelper().setMultiPassBursting(multiPassBursting);
    }

    public boolean isPluginArtifact() throws SDKException {
        return this.getPubInfoHelper().isPluginArtifact();
    }

    public void setPluginArtifact(boolean bIsMergedArtifact) {
        this.getPubInfoHelper().setPluginArtifact(bIsMergedArtifact);
    }

    public Collection getScopeBatchDocArtifacts() throws SDKException {
        return this.getPubInfoHelper().getScopeBatchDocArtifacts();
    }

    public IDestinationProgIDs getDestinationProgIDs() {
        return this.getPubInfoHelper().getDestinationProgIDs();
    }

    public Collection getSourceDocuments() throws SDKException {
        return this.getPubInfoHelper().getSourceDocuments();
    }

    public int getScopeBatch() throws SDKException {
        return this.getPubInfoHelper().getScopeBatch();
    }

    public void setScopeBatch(int scopeBatchID) throws SDKException {
        this.getPubInfoHelper().setScopeBatch(scopeBatchID);
    }

    public IDynamicRecipientVariableMappings getDynamicRecipientVariableMappings() throws SDKException {
        return this.getPubInfoHelper().getDynamicRecipientVariableMappings();
    }

    public IPublicationDocumentVariableMappings getPublicationDocumentVariableMappings() throws SDKException {
        return this.getPubInfoHelper().getPublicationDocumentVariableMappings();
    }

    public void setPublicationDocumentVariableMappings(IPublicationDocumentVariableMappings variableMappings) throws SDKException {
        this.getPubInfoHelper().setPublicationDocumentVariableMappings(variableMappings);
    }

    public int getArtifactParentID() throws SDKException {
        return this.getPubInfoHelper().getArtifactParentID();
    }

    public void setArtifactParentID(int artifactParentID) throws SDKException {
        this.getPubInfoHelper().setArtifactParentID(artifactParentID);
    }

    public String getFormat() {
        return this.getPubInfoHelper().getFormat();
    }

    public void setFormat(String format) {
        this.getPubInfoHelper().setFormat(format);
    }

    protected void prepareForSerialization() {
        super.prepareForSerialization();
        this.m_serBag.addItem((Object)PropertyIDs.SI_CONTENT_MIME_TYPE, (Object)this.m_mimeType, 0);
        this.m_serBag.addItem((Object)PropertyIDs.SI_CONTENT_FILE_INDEX, (Object)new Integer(this.m_fileIndex), 0);
    }

    public void initFromSerialization(ISecuritySession session, String packedRootProps, String packedSerProps, IFiles files, ISecurityInfo securityInfo, ISecurityInfo2 securityInfo2) throws SDKException {
        Property fileIndexProp;
        super.initFromSerialization(session, packedRootProps, packedSerProps, files, securityInfo, securityInfo2);
        Property mimeTypeProp = this.m_serBag.getItem((Object)PropertyIDs.SI_CONTENT_MIME_TYPE);
        if (mimeTypeProp != null) {
            this.m_mimeType = mimeTypeProp.getString();
        }
        if ((fileIndexProp = this.m_serBag.getItem((Object)PropertyIDs.SI_CONTENT_FILE_INDEX)) != null) {
            this.m_fileIndex = fileIndexProp.getInt();
        }
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (AbstractContentObject.this.isNew()) {
                        AbstractContentObject.this.getScopeBatch();
                        AbstractContentObject.this.getSourceDocuments();
                        PropertyBag thisbag = (PropertyBag)AbstractContentObject.this.properties();
                        Property fileprop = thisbag.getItem((Object)PropertyIDs.SI_FILES);
                        if (fileprop == null) {
                            PropertyBag bag = thisbag.addItem((Object)PropertyIDs.SI_FILES, null, 0x8000000).getPropertyBag();
                            bag.addItem((Object)PropertyIDs.SI_NUM_FILES, (Object)new Integer(0), 0);
                            IInternalInfoObject internalobj = (IInternalInfoObject)event.getInfoObject();
                            String pathURL = internalobj.createFrsUrl();
                            bag.addItem((Object)PropertyIDs.SI_PATH, (Object)pathURL, 0);
                        }
                    } else {
                        IProperty filesProp = AbstractContentObject.this.properties().getProperty(PropertyIDs.SI_FILES);
                        if (filesProp != null && (filesProp.getFlags() & 0x8000000) == 0) {
                            throw new SDKException.InvalidFilesStructure();
                        }
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }
}

