/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IContent;
import com.crystaldecisions.sdk.occa.infostore.internal.IProxyHandler;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.AbstractContentObject;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ContentProcessingHandler
implements IProxyHandler,
Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.common.internal.ContentProcessingHandler");
    private IContent m_contentObject;
    private Set m_processInterfaces;
    private transient Object m_processingInfo;
    public static final String BOBJ_LEGACYSUPPORT = "bobj.legacysupport";
    private static Class s_processingClass;
    private static Set s_rptProcessingInfts;
    private static Map s_cache;
    private static transient boolean s_proxyTurnon;
    static /* synthetic */ Class class$com$crystaldecisions$sdk$exception$SDKException;

    private static void staticInit() {
        block3: {
            try {
                s_processingClass = Thread.currentThread().getContextClassLoader().loadClass("com.crystaldecisions.sdk.plugin.desktop.common.IReportProcessingInfo");
            }
            catch (Throwable e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info((Object)"(getProxy:65) couldn't find report processingInfo", e);
            }
        }
        if (s_processingClass != null) {
            s_rptProcessingInfts = new HashSet(2);
            s_rptProcessingInfts.add(s_processingClass);
            ContentProcessingHandler.getInterfaces(s_processingClass, s_rptProcessingInfts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProxy(AbstractContentObject contentObject) {
        HashSet rptProcIntfs;
        Class[] interfaces;
        if (!s_proxyTurnon) {
            return contentObject;
        }
        if ("false".equalsIgnoreCase(System.getProperty(BOBJ_LEGACYSUPPORT)) || "off".equalsIgnoreCase(System.getProperty(BOBJ_LEGACYSUPPORT))) {
            s_proxyTurnon = false;
            return contentObject;
        }
        Map map = s_cache;
        synchronized (map) {
            ContentProcessingHandler.checkProcessingClass();
            if (s_processingClass == null || s_processingClass.isInstance(contentObject)) {
                return contentObject;
            }
            Class<?> contentClass = contentObject.getClass();
            String type = contentObject.getScheduleProgID();
            if (type != null && type.length() != 0 && !"CrystalEnterprise.Report".equals(type)) {
                return contentObject;
            }
            CacheEntry entry = (CacheEntry)s_cache.get(contentClass);
            if (entry != null) {
                interfaces = entry.interfaces;
                rptProcIntfs = entry.processingInterfaces;
            } else {
                rptProcIntfs = new HashSet(s_rptProcessingInfts.size());
                rptProcIntfs.addAll(s_rptProcessingInfts);
                HashSet contextClasses = new HashSet();
                ContentProcessingHandler.getInterfaces(contentClass, contextClasses);
                rptProcIntfs.removeAll(contextClasses);
                ArrayList interfacesList = new ArrayList();
                interfacesList.addAll(contextClasses);
                interfacesList.addAll(rptProcIntfs);
                interfaces = interfacesList.toArray(new Class[interfacesList.size()]);
                s_cache.put(contentClass, new CacheEntry(interfaces, rptProcIntfs));
            }
        }
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new ContentProcessingHandler(contentObject, rptProcIntfs));
    }

    public Object getObject() {
        return this.m_contentObject;
    }

    private static void getInterfaces(Class clazz, Set interfaces) {
        Class<?>[] directInterfaces = clazz.getInterfaces();
        interfaces.addAll(Arrays.asList(directInterfaces));
        for (int i = 0; i < directInterfaces.length; ++i) {
            Class<?> intf = directInterfaces[i];
            ContentProcessingHandler.getInterfaces(intf, interfaces);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ContentProcessingHandler.getInterfaces(superClass, interfaces);
        }
    }

    public ContentProcessingHandler(IContent object, Set processClasses) {
        this.m_contentObject = object;
        this.m_processInterfaces = processClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        Object invokedObject;
        Class<?> declaringClass = method.getDeclaringClass();
        if (this.m_processInterfaces.contains(declaringClass)) {
            ContentProcessingHandler contentProcessingHandler = this;
            synchronized (contentProcessingHandler) {
                if (this.m_processingInfo == null) {
                    this.m_processingInfo = this.m_contentObject.getPluginProcessingInterface("CrystalReport");
                }
                if (this.m_processingInfo == null) {
                    Class<?>[] exceptionTypes = method.getExceptionTypes();
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        Class<?> exception = exceptionTypes[i];
                        if (!exception.equals(class$com$crystaldecisions$sdk$exception$SDKException == null ? ContentProcessingHandler.class$("com.crystaldecisions.sdk.exception.SDKException") : class$com$crystaldecisions$sdk$exception$SDKException)) continue;
                        throw new SDKException.InvalidOperation();
                    }
                    throw new IllegalAccessError();
                }
                invokedObject = this.m_processingInfo;
            }
        } else {
            invokedObject = this.m_contentObject;
        }
        try {
            ret = method.invoke(invokedObject, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"(invoke:154) exception being thrown from proxy", t);
            }
            throw t;
        }
        if (ret == this.m_contentObject) {
            return proxy;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkProcessingClass() {
        Class<?> processingClass = null;
        try {
            processingClass = Thread.currentThread().getContextClassLoader().loadClass("com.crystaldecisions.sdk.plugin.desktop.common.IReportProcessingInfo");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (processingClass != null && !processingClass.equals(s_processingClass)) {
            ContentProcessingHandler.staticInit();
            Map map = s_cache;
            synchronized (map) {
                s_cache.clear();
            }
        }
    }

    static {
        s_rptProcessingInfts = Collections.EMPTY_SET;
        s_cache = new WeakHashMap();
        s_proxyTurnon = true;
        ContentProcessingHandler.staticInit();
    }

    private static class CacheEntry {
        private Class[] interfaces;
        private Set processingInterfaces;

        private CacheEntry(Class[] interfaces, Set processingInterfaces) {
            this.interfaces = interfaces;
            this.processingInterfaces = processingInterfaces;
        }
    }
}

