/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.desktop.common.IDynamicRecipientInfos;
import com.crystaldecisions.sdk.plugin.desktop.common.IDynamicRecipientProfileValuesSet;
import com.crystaldecisions.sdk.plugin.desktop.common.IScopeBatchScope;
import com.crystaldecisions.sdk.plugin.desktop.common.IScopePrincipals;
import com.crystaldecisions.sdk.plugin.desktop.common.IScopeProfileValues;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.DynamicRecipientInfos;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.DynamicRecipientProfileValuesSet;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.ScopePrincipals;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.ScopeProfileValues;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

public class ScopeBatchScope
implements IScopeBatchScope {
    private IProperties m_bag;
    private IScopePrincipals m_principals = null;
    private IDynamicRecipientInfos m_dynamicRecipientInfos = null;
    private IDynamicRecipientProfileValuesSet m_dynamicRecipientProfileValues = null;
    private String m_kind;

    public ScopeBatchScope() {
    }

    public ScopeBatchScope(IProperties bag, String kind) {
        this.m_bag = bag;
        this.m_kind = kind;
    }

    public IScopePrincipals getPrincipals() {
        if (this.m_principals == null) {
            PropertyBag principalsBag = ((PropertyBag)this.m_bag).getPropertyBag((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_PRINCIPALS);
            if (principalsBag == null) {
                principalsBag = ((PropertyBag)this.m_bag).addArray((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_PRINCIPALS).getPropertyBag();
            }
            this.m_principals = new ScopePrincipals(principalsBag);
        }
        return this.m_principals;
    }

    public IScopeProfileValues getDocumentProfileValues(int documentID) {
        PropertyBag documentProfileValues = ((PropertyBag)this.m_bag).getPropertyBag((Object)new Integer(documentID));
        if (documentProfileValues == null) {
            documentProfileValues = ((PropertyBag)this.m_bag).addArray((Object)new Integer(documentID)).getPropertyBag();
        }
        return new ScopeProfileValues(documentProfileValues);
    }

    public IScopeProfileValues getDocumentProfileValues() {
        PropertyBag documentProfileValues = ((PropertyBag)this.m_bag).getPropertyBag((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_PROFILEVALUES);
        if (documentProfileValues == null) {
            documentProfileValues = ((PropertyBag)this.m_bag).addArray((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_PROFILEVALUES).getPropertyBag();
        }
        return new ScopeProfileValues(documentProfileValues);
    }

    public IDynamicRecipientInfos getDynamicRecipientInfos() {
        if (this.m_dynamicRecipientInfos == null) {
            PropertyBag propBag = ((PropertyBag)this.m_bag).getPropertyBag((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_RECIPIENTINFOS);
            if (propBag == null) {
                propBag = ((PropertyBag)this.m_bag).addArray((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_RECIPIENTINFOS).getPropertyBag();
            }
            this.m_dynamicRecipientInfos = new DynamicRecipientInfos(propBag);
        }
        return this.m_dynamicRecipientInfos;
    }

    public IDynamicRecipientProfileValuesSet getDynamicRecipientProfileValuesSet() {
        if (this.m_dynamicRecipientProfileValues == null) {
            PropertyBag propBag = ((PropertyBag)this.m_bag).getPropertyBag((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_RECIPIENTVALUESSET);
            if (propBag == null) {
                propBag = ((PropertyBag)this.m_bag).addArray((Object)PropertyIDs.SI_SCOPEBATCH_SCOPE_RECIPIENTVALUESSET).getPropertyBag();
            }
            this.m_dynamicRecipientProfileValues = new DynamicRecipientProfileValuesSet(propBag);
        }
        return this.m_dynamicRecipientProfileValues;
    }

    public boolean isGenerateArtifacts() {
        return this.m_bag.getBoolean(PropertyIDs.SI_PRINCIPALS_RERUN);
    }

    public void setGenerateArtifacts(boolean value) throws SDKException {
        this.m_bag.setProperty((Object)PropertyIDs.SI_PRINCIPALS_RERUN, value);
    }

    public void initialize() {
        if (this.m_bag == null) {
            this.m_bag = new SDKPropertyBag();
        }
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_SCOPEBATCH_SCOPE_PRINCIPALS, bag);
        this.copyProperty(PropertyIDs.SI_SCOPEBATCH_SCOPE_RECIPIENTINFOS, bag);
        this.copyProperty(PropertyIDs.SI_DYNAMIC_RECIPIENTS_PROFILE_VALUES, bag);
        this.copyProperty(PropertyIDs.SI_PRINCIPALS_RERUN, bag);
        this.m_bag = bag;
    }

    private void copyProperty(Integer id, IProperties bag) {
        Property property2 = (Property)this.m_bag.get(id);
        if (property2 != null) {
            bag.setProperty((Object)id, property2.getValue());
        }
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_bag);
    }
}

