/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.event.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.event.IEvent;
import com.crystaldecisions.sdk.plugin.desktop.event.internal.FileEvent;
import com.crystaldecisions.sdk.plugin.desktop.event.internal.ScheduleEvent;
import com.crystaldecisions.sdk.plugin.desktop.event.internal.UserEvent;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

class Event
extends AbstractInfoObject
implements IEvent {
    public static final Integer SEC_ID_EVENT_FOLDER = new Integer(21);

    Event() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_EVENT_FOLDER);
    }

    public String getEventName() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_NAME);
        return prop.getString();
    }

    public void setEventName(String newEventName) {
        this.setProperty((Object)PropertyIDs.SI_NAME, newEventName);
    }

    public int getEventType() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_TYPE);
        return prop.getInt();
    }

    public void setEventType(int newEventType) {
        this.setProperty((Object)PropertyIDs.SI_TYPE, new Integer(newEventType));
    }

    public Object getEventInterface() throws SDKException {
        int eventType = this.getEventType();
        Object result = null;
        switch (eventType) {
            case 1: {
                result = new FileEvent(this.properties());
                break;
            }
            case 0: {
                result = new UserEvent(this.properties());
                break;
            }
            case 2: {
                result = new ScheduleEvent(this.properties());
                break;
            }
            default: {
                throw new SDKException.UnexpectedValue(PropertyIDs.SI_TYPE, eventType);
            }
        }
        return result;
    }

    protected void prepareCommit() throws SDKException {
        IProperty prop;
        if (this.isNew() && (prop = this.getProperty(PropertyIDs.SI_TYPE)) == null) {
            throw new SDKException.UnexpectedValue(PropertyIDs.SI_TYPE, null);
        }
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    Event.this.prepareCommit();
                }
            };
        }
        return superListener;
    }
}

