/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.licensekey.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.licensekey.ILicenseKey;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Date;
import java.util.Locale;

class LicenseKey
extends AbstractInfoObject
implements ILicenseKey {
    private static final Locale[] s_Languages = new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, new Locale("es", ""), Locale.ITALIAN, Locale.JAPANESE, new Locale("pt", ""), Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.KOREAN, new Locale("nl", ""), new Locale("da", "")};
    public static final Integer SEC_ID_LICENSES = new Integer(24);

    LicenseKey() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_LICENSES);
    }

    public String getLicenseKey() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_LICENSE_KEY);
        return prop.getString();
    }

    public void setLicenseKey(String newLicenseKey) {
        this.setProperty((Object)PropertyIDs.SI_LICENSE_KEY, newLicenseKey);
        this.setProperty((Object)PropertyIDs.SI_NAME, newLicenseKey);
    }

    public int getProductName() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_PRODUCT_NAME);
        return prop.getInt();
    }

    public int getProductLevel() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_PRODUCT_LEVEL);
        return prop.getInt();
    }

    public int getProductVersion() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_PRODUCT_VERSION);
        return prop.getInt();
    }

    public int getUserLicenseType() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_LICENSE_TYPE);
        return prop.getInt();
    }

    public int getLicenseCount() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_LICENSE_COUNT);
        return prop.getInt();
    }

    public Date getExpiryDate() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_EXPIRY_DATE);
        return prop.getDate();
    }

    public Locale getLanguage() {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_LANGUAGE);
        int language = prop.getInt();
        Locale result = null;
        if (0 <= language && language < s_Languages.length) {
            result = s_Languages[language];
        }
        return result;
    }
}

