/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredContainer;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredContainers;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredContainers;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.enterprisenode.IEnterpriseNode;
import com.businessobjects.sdk.plugin.desktop.install.IInstall;
import com.businessobjects.sdk.plugin.desktop.service.internal.IInternalService;
import com.businessobjects.sdk.plugin.desktop.servicecontainer.IServiceContainer;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAAdministrator;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAAdministratorHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAServiceAdmin;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.IServerGeneralMetrics;
import com.crystaldecisions.sdk.occa.enadmin.internal.IInternalAdminService;
import com.crystaldecisions.sdk.occa.enadmin.internal.ServerGeneralMetrics;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.plugin.desktop.server.ExpectedRunState;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.plugin.desktop.server.IServerDestinations;
import com.crystaldecisions.sdk.plugin.desktop.server.IServerMetrics;
import com.crystaldecisions.sdk.plugin.desktop.server.IStatusInfo;
import com.crystaldecisions.sdk.plugin.desktop.server.ServerState;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.IInternalServer;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.ServerDestination;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.ServerDestinations;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.ServerMetrics;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.StatusInfo;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class EnServer
extends AbstractInfoObject
implements IInternalServer {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.server.internal.EnServer");
    private Object m_serverAdminPlugin = null;
    private static final String SSL_MODE = "SSL";
    private IServerGeneralMetrics m_genericAdmin = null;
    private ConfiguredServices m_configuredServices;
    private ConfiguredContainers m_configuredContainers;
    private ObjectRelatives m_serverGroups;
    private ServerDestinations m_serverDestinations = null;
    private PropertyBag m_metricsForBackwardsCompatibility = null;
    private ServerMetrics m_svrMetrics = null;
    private boolean m_alreadyBackqueried = false;
    private Set m_objRels = new HashSet();
    private static HashSet m_supportedAdmin = new HashSet(11, 1.0f);

    EnServer() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENT_CUID, "AS5D8pcHVf9Fl8UCS3ATpIc");
        this.setProperty((Object)PropertyIDs.SI_PARENTID, 16);
        this.setProperty((Object)PropertyIDs.SI_DISABLED_TARGET, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_AUTOBOOT, Boolean.FALSE);
        this.setProperty((Object)PropertyIDs.SI_EXPECTED_RUN_STATE, ExpectedRunState.STOPPED.toInteger());
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            if (this.m_serverDestinations != null) {
                this.packDestinationOptions();
            }
            if (this.isNew()) {
                try {
                    this.getHostedServices();
                    this.getContainer();
                    this.getServerGroups();
                    if (this.getServerName() == null) {
                        this.setServerNameFromEntNode();
                    }
                }
                catch (SDKException e) {
                    LOG.error((Object)"prepareForCommit(): error handling relationships", (Throwable)((Object)e));
                }
            } else {
                this.processObjectRelatives(this.m_objRels);
            }
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    IInternalInfoStore infoStore = event.getInfoStore();
                    EnServer.this.checkServiceSupported(infoStore);
                    EnServer.this.pushEdgeProps(infoStore);
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    private void setServerNameFromEntNode() throws SDKException {
        IEnterpriseNode en;
        String queryStr;
        IInternalInfoStore infoStore = this.getInfoStore();
        IInfoObjects objs = infoStore.query(queryStr = "select SI_SERVER_NAME from CI_SYSTEMOBJS where SI_ID = " + String.valueOf(this.getEnterpriseNodeID()) + " AND SI_PARENTID = " + String.valueOf(59));
        if (objs.size() == 1 && (en = (IEnterpriseNode)objs.get(0)).getHostName() != null) {
            this.setProperty((Object)PropertyIDs.SI_SERVER_NAME, en.getHostName());
        }
    }

    private void packDestinationOptions() {
        Iterator iter = this.m_serverDestinations.iterator();
        while (iter.hasNext()) {
            ServerDestination dest = (ServerDestination)iter.next();
            dest.prepareForCommit();
        }
    }

    private void checkServiceSupported(IInternalInfoStore infoStore) throws SDKException {
        Property addServiceEdge = (Property)this.properties().get(PropertyIDs.SI_ADM_ADD_SI_SERVICE);
        if (addServiceEdge != null) {
            IConfiguredContainer cc = this.getContainer();
            if (cc == null) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_SERVICECONTAINER);
            }
            int containerID = cc.getID();
            String serviceContainerQuery = "select SI_SERVICE4SC from CI_SYSTEMOBJS where SI_PARENTID = 55 and SI_ID = " + containerID;
            IInfoObjects objs = infoStore.query(serviceContainerQuery);
            if (objs == null || objs.size() != 1) {
                throw new SDKException.InvalidObjectID(containerID);
            }
            IServiceContainer sc = (IServiceContainer)objs.get(0);
            PropertyBag addEdgeBag = addServiceEdge.getPropertyBag();
            Iterator iter = addEdgeBag.allIterator();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                if (!prop.isContainer()) continue;
                PropertyBag pb = prop.getPropertyBag();
                int serviceID = pb.getInt((Object)PropertyIDs.SI_ID);
                if (sc.getServices().contains(new Integer(serviceID))) continue;
                throw new SDKException.ServiceNotSupported(this.getID(), serviceID);
            }
        }
    }

    private void pushEdgeProps(IInternalInfoStore istore) throws SDKException {
        PropertyBag pb;
        Property p;
        Iterator bagIter;
        PropertyBag bag;
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_ADD_SI_SERVICE);
        if (prop != null) {
            bag = prop.getPropertyBag();
            bagIter = bag.allIterator();
            while (bagIter.hasNext()) {
                p = (Property)bagIter.next();
                if (!p.isContainer()) continue;
                pb = p.getPropertyBag();
                int serviceID = pb.getInt((Object)PropertyIDs.SI_ID);
                this.pushInstallProps(istore, serviceID, pb, "Install-Service", PropertyIDs.SI_INSTALLED_SERVICES);
                this.pushServiceProps(istore, serviceID, pb);
            }
        }
        if ((prop = (Property)this.properties().get(PropertyIDs.SI_ADM_ADD_SI_SERVICECONTAINER)) != null) {
            bag = prop.getPropertyBag();
            bagIter = bag.allIterator();
            while (bagIter.hasNext()) {
                p = (Property)bagIter.next();
                if (!p.isContainer()) continue;
                pb = p.getPropertyBag();
                int containerID = pb.getInt((Object)PropertyIDs.SI_ID);
                this.pushInstallProps(istore, containerID, pb, "Install-ServiceContainer", PropertyIDs.SI_INSTALLED_CONTAINERS);
                this.pushContainerProps(istore, containerID, pb);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushInstallProps(IInternalInfoStore istore, int edgeID, PropertyBag destBag, String lastRelation, int srcEdgeType) throws SDKException {
        int enID = this.getEnterpriseNodeID();
        if (enID == 0) {
            throw new SDKException.PropagationNotPossible("Enterprise Node", "Server", this.getID());
        }
        String q = "SELECT SI_ID FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='Install-EnterpriseNode'\", \"SI_ID=" + enID + "\")";
        IInfoObjects objs = istore.query(q);
        if (objs.size() <= 0) throw new SDKException.PropagationNotPossible("Install", "Enterprise Node", enID);
        IInstall inst = (IInstall)objs.get(0);
        int installID = inst.getID();
        q = "SELECT " + PropertyIDs.idToName(new Integer(srcEdgeType)) + " FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='" + lastRelation + "'\", \"SI_ID=" + edgeID + "\") AND SI_ID=" + installID;
        objs = istore.query(q);
        if (objs.size() <= 0) throw new SDKException.MissingEdge(installID, edgeID);
        IInstall i = (IInstall)objs.get(0);
        PropertyBag originBag = this.findRelationSection(((Property)i.properties().get(new Integer(srcEdgeType))).getPropertyBag(), edgeID);
        Iterator origPropIter = originBag.allIterator();
        while (origPropIter.hasNext()) {
            PropertyBag origPropSubBag;
            Property origProp = (Property)origPropIter.next();
            Integer origPropID = origProp.getID();
            if (origPropID.equals(PropertyIDs.SI_ID) || origPropID.equals(PropertyIDs.SI_OBJ_VERSION)) continue;
            Property destProp = destBag.getItem((Object)origPropID);
            if (destProp == null || destProp.getValue() == null || destProp.getValue() == "") {
                destBag.addItem((Object)origPropID, origProp.getValue(), 0);
                continue;
            }
            if (!origProp.isContainer() || (origPropSubBag = origProp.getPropertyBag()).getItem((Object)PropertyIDs.SI_TOTAL) != null || !destProp.isContainer()) continue;
            PropertyBag destPropSubBag = destProp.getPropertyBag();
            Iterator origPropSubBagIter = origPropSubBag.allIterator();
            while (origPropSubBagIter.hasNext()) {
                Property prop = (Property)origPropSubBagIter.next();
                Property item = destPropSubBag.getItem((Object)prop.getID());
                if (item != null && item.getValue() != null && item.getValue() != "") continue;
                destPropSubBag.addItem((Object)prop.getID(), prop.getValue(), 0);
            }
        }
    }

    private void pushServiceProps(IInternalInfoStore istore, int serviceID, PropertyBag destBag) throws SDKException {
        IInfoObjects objs = istore.query("SELECT SI_CUID, SI_CONFIG, SI_SERVICE_VERSION, SI_SERVICE_TYPE, SI_DEPLOYMENT_DESCRIPTOR FROM CI_SYSTEMOBJECTS WHERE SI_ID=" + serviceID);
        IInternalService service = (IInternalService)objs.get(0);
        if (destBag.getItem((Object)PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR) == null && service.properties().getProperty(PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR) != null) {
            destBag.addItem((Object)PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR, (Object)service.getDeploymentConfig().getDeploymentDescriptor(), 0);
        }
        destBag.addItem((Object)PropertyIDs.SI_SERVICE_VERSION, (Object)new Integer(service.getServiceVersion()), 0);
        destBag.addItem((Object)PropertyIDs.SI_SERVICE_TYPE, (Object)service.getType(), 0);
        destBag.addItem((Object)PropertyIDs.SI_CUID, (Object)service.getCUID(), 0);
        IConfigProperties srcConfigProps = service.getConfigProps();
        if (srcConfigProps != null && !srcConfigProps.isEmpty()) {
            PropertyBag configBag = destBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
            if (configBag == null) {
                configBag = destBag.addItem((Object)PropertyIDs.SI_CONFIG, null, 0x8000000).getPropertyBag();
            }
            ConfigProperties edgeConfigs = new ConfigProperties(configBag);
            ConfigProperties srcConfigs = (ConfigProperties)service.getConfigProps();
            String[] names = srcConfigs.getPropNames();
            for (int i = 0; i < names.length; ++i) {
                if (edgeConfigs.getProp(names[i]) != null) continue;
                edgeConfigs.addProp((ConfigProperty)srcConfigs.get(names[i]));
            }
            destBag.setProperty((Object)PropertyIDs.SI_USE_DEFAULT_VALUES, false);
        }
    }

    private void pushContainerProps(IInternalInfoStore istore, int containerID, PropertyBag destBag) throws SDKException {
        IInfoObjects objs = istore.query("SELECT SI_SERVER_KIND, SI_CONFIG FROM CI_SYSTEMOBJECTS WHERE SI_ID=" + containerID);
        IServiceContainer servicec = null;
        if (objs.size() != 1) {
            LOG.error((Object)("Cannot find service container (SI_ID = " + containerID + ") to connect to server (SI_ID = " + this.getID() + ")."));
            throw new SDKException.InvalidObjectID(containerID);
        }
        servicec = (IServiceContainer)objs.get(0);
        IConfigProperties srcConfigProps = servicec.getConfigProps();
        if (srcConfigProps != null && !srcConfigProps.isEmpty()) {
            PropertyBag configBag = destBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
            if (configBag == null) {
                configBag = destBag.addItem((Object)PropertyIDs.SI_CONFIG, null, 0x8000000).getPropertyBag();
            }
            ConfigProperties edgeConfigs = new ConfigProperties(configBag);
            String[] names = srcConfigProps.getPropNames();
            for (int i = 0; i < names.length; ++i) {
                if (edgeConfigs.getProp(names[i]) != null) continue;
                edgeConfigs.addProp((ConfigProperty)srcConfigProps.get(names[i]));
            }
        }
        this.setServerKind(servicec.getServerKind());
        destBag.setProperty((Object)PropertyIDs.SI_USE_DEFAULT_VALUES, false);
    }

    protected PropertyBag findRelationSection(PropertyBag root, int id) {
        Iterator i = root.allIterator();
        while (i.hasNext()) {
            Property idProp;
            Property p = (Property)i.next();
            if ((p.getFlags() & 0x8000000) == 0 || (idProp = p.getPropertyBag().getItem((Object)PropertyIDs.SI_ID)) == null || idProp.getInt() != id) continue;
            return p.getPropertyBag();
        }
        return null;
    }

    protected String getStringProp(Integer in) {
        String s;
        IProperty prop = super.getProperty(in);
        if (prop != null && (s = (String)prop.getValue()) != null) {
            return s;
        }
        return null;
    }

    protected int getIntegerProp(Integer in) {
        Integer n;
        IProperty prop = super.getProperty(in);
        if (prop != null && (n = (Integer)prop.getValue()) != null) {
            return n;
        }
        return 0;
    }

    protected boolean getBoolProp(Integer in) {
        Boolean b;
        IProperty prop = super.getProperty(in);
        if (prop != null && (b = (Boolean)prop.getValue()) != null) {
            return b;
        }
        return false;
    }

    public String getServerName() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_SERVER_NAME);
    }

    public String getServerDescriptor() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_SERVER_DESCRIPTOR);
    }

    public String getServerID() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_SERVER_ID);
    }

    public String getServerKind() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_SERVER_KIND);
    }

    public String getServerIOR() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_SERVER_IOR);
    }

    public String getFriendlyName() throws SDKException {
        return this.getStringProp(PropertyIDs.SI_FRIENDLY_NAME);
    }

    public void setFriendlyName(String friendlyName) {
        super.setProperty((Object)PropertyIDs.SI_FRIENDLY_NAME, friendlyName);
    }

    public String getName() throws SDKException {
        return this.getTitle();
    }

    public boolean isDisabled() throws SDKException {
        return this.getBoolProp(PropertyIDs.SI_DISABLED);
    }

    public void setDisabled(boolean b) throws SDKException {
        super.setProperty((Object)PropertyIDs.SI_DISABLED_TARGET, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getCurrentDisabledState() {
        return this.getBoolProp(PropertyIDs.SI_CURRENT_DISABLED_STATE);
    }

    public boolean isAlive() throws SDKException {
        int n = this.getIntegerProp(PropertyIDs.SI_SERVER_IS_ALIVE);
        return n > 0;
    }

    public boolean manageServer(int operation, int timeout, String username, String password) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("manageServer(): operation=" + operation + ", timeout=" + timeout + ",username=" + username));
        }
        if (operation != 1 && operation != 2 && operation != 3) {
            LOG.warn((Object)("manageServer(): invalid operation " + operation));
            throw new IllegalArgumentException();
        }
        ExpectedRunState currState = this.getExpectedRunState();
        if (operation == 1) {
            if (currState != ExpectedRunState.RUNNING) {
                this.setProperty((Object)PropertyIDs.SI_EXPECTED_RUN_STATE, ExpectedRunState.RUNNING.toInteger());
                this.save();
            }
        } else if (operation == 2) {
            if (currState != ExpectedRunState.STOPPED) {
                this.setProperty((Object)PropertyIDs.SI_EXPECTED_RUN_STATE, ExpectedRunState.STOPPED.toInteger());
                this.save();
            }
        } else if (operation == 3 && currState != ExpectedRunState.RESTART) {
            this.setProperty((Object)PropertyIDs.SI_EXPECTED_RUN_STATE, ExpectedRunState.RESTART.toInteger());
            this.save();
        }
        return true;
    }

    public Object getServerAdmin() throws SDKException {
        IPluginMgr pluginMgr;
        this.ensureProperties();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter: getServerAdmin()");
        }
        if (this.m_serverAdminPlugin != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Returing cached service admin");
            }
            return this.m_serverAdminPlugin;
        }
        String serverKind = this.getStringProp(PropertyIDs.SI_SERVER_KIND);
        if (!m_supportedAdmin.contains(serverKind)) {
            throw new SDKException.InvalidOperation();
        }
        ISecuritySession session = this.getSession();
        OCAAdministrator admin = null;
        String svcAdmName = null;
        if (serverKind.equalsIgnoreCase("rptappserver")) {
            svcAdmName = "ReportAppServerAdmin";
        } else if (serverKind.startsWith("dpscache")) {
            svcAdmName = "DocProcessingCacheAdmin";
        } else if (serverKind.startsWith("dpsproc")) {
            svcAdmName = "DocProcessingProcAdmin";
        } else if (serverKind.equals("cacheserver")) {
            svcAdmName = "CacheServerAdmin";
        } else if (serverKind.equals("pageserver")) {
            svcAdmName = "PageServerAdmin";
        } else {
            Object[] serviceAdminNames = null;
            this.ensureMetrics();
            PropertyArrayHelper metricsBag = new PropertyArrayHelper(this.m_metricsForBackwardsCompatibility, PropertyIDs.SI_TOTAL);
            ArrayList<String> svcList = new ArrayList<String>();
            Iterator iter = metricsBag.iterator();
            while (iter.hasNext()) {
                PropertyBag subBag = (PropertyBag)iter.next();
                svcList.add(subBag.getString((Object)PropertyIDs.SI_NAME));
            }
            serviceAdminNames = svcList.toArray();
            admin = (OCAAdministrator)this.getServerAdministrator();
            if (admin != null && serviceAdminNames == null) {
                try {
                    serviceAdminNames = admin.getServices();
                }
                catch (oca_abuse e) {
                    LOG.warn((Object)"OCA abused", (Throwable)e);
                    throw SDKException.map(e);
                }
                catch (SystemException e) {
                    LOG.warn((Object)"SystemException", (Throwable)e);
                    throw new SDKException.ServerAdminError((Exception)((Object)e));
                }
            }
            if (serviceAdminNames == null) {
                LOG.warn((Object)"Service failure");
                throw new SDKException.ServiceFailure("OCAAdministrator", this.getName());
            }
            for (int i = 0; i < serviceAdminNames.length; ++i) {
                String adminName = (String)serviceAdminNames[i];
                if (adminName.length() < serverKind.length() || !adminName.substring(0, serverKind.length()).equalsIgnoreCase(serverKind)) continue;
                svcAdmName = (String)serviceAdminNames[i];
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Service admin name:" + svcAdmName));
                break;
            }
        }
        LOG.assertNotNull((Object)svcAdmName, "svcAdmName is null.");
        String progId = "CrystalEnterprise." + svcAdmName;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("progID:" + progId));
        }
        if ((pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", session)) != null) {
            IInternalAdminService internalInterface;
            this.m_serverAdminPlugin = pluginMgr.getPluginInterface(progId, "admin");
            if (this.m_serverAdminPlugin != null && (internalInterface = (IInternalAdminService)this.m_serverAdminPlugin) != null) {
                internalInterface.initialize(svcAdmName, admin, session.getUserURI(), this, this.getInfoStore());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exit: getServerAdmin()");
        }
        return this.m_serverAdminPlugin;
    }

    public Object getAuditAdmin() throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAuditAdmin(): enter");
        }
        return this.getSpecificServerAdmin("CrystalEnterprise.AuditAdmin", "AuditAdmin");
    }

    public Object getSingleSignOnAdmin() throws SDKException {
        LOG.debug((Object)"getSingleSignOnAdmin(): enter");
        return this.getSpecificServerAdmin("CrystalEnterprise.SSOAdmin", "SSOAdmin");
    }

    public IServerGeneralMetrics getServerGeneralAdmin() throws SDKException {
        OCAServiceAdmin ocaServiceAdmin;
        PropertyBag genMetricsBag;
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"enter: getServerGeneralAdmin()");
            }
            this.ensureProperties();
            if (this.getStringProp(PropertyIDs.SI_SERVER_KIND).equals("pjs")) {
                LOG.info((Object)"Cannot invoke getServerGeneralAdmin() on Adaptive Processing Servers.");
                throw new SDKException.InvalidOperation();
            }
            if (this.m_genericAdmin != null) {
                return this.m_genericAdmin;
            }
            this.ensureMetrics();
            Iterator iter = this.m_metricsForBackwardsCompatibility.allIterator();
            genMetricsBag = null;
            while (iter.hasNext()) {
                PropertyBag bag = ((Property)iter.next()).getPropertyBag();
                if (!bag.getString((Object)PropertyIDs.SI_NAME).equals("ISGeneralAdmin")) continue;
                genMetricsBag = bag;
                break;
            }
            ocaServiceAdmin = null;
            try {
                OCAAdministrator admin = (OCAAdministrator)this.getServerAdministrator();
                ocaServiceAdmin = admin.getServiceAdmin("ISGeneralAdmin");
            }
            catch (oca_abuse e) {
                if (genMetricsBag == null) {
                    throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRICS);
                }
            }
            catch (SystemException e) {
                if (genMetricsBag != null) break block8;
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRICS);
            }
        }
        this.m_genericAdmin = new ServerGeneralMetrics(ocaServiceAdmin, genMetricsBag);
        return this.m_genericAdmin;
    }

    public int getCommunicationProtocol() throws SDKException {
        String protocol = this.getStringProp(PropertyIDs.SI_COMMUNICATION_PROTOCOL);
        if (protocol == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_COMMUNICATION_PROTOCOL);
        }
        if (protocol.equalsIgnoreCase(SSL_MODE)) {
            return 2;
        }
        return 1;
    }

    public String[] getAdminServiceNames() throws SDKException {
        String kind = this.getStringProp(PropertyIDs.SI_SERVER_KIND);
        if (kind == null || kind.length() == 0) {
            kind = "aps";
        }
        ISecuritySession session = this.getSession();
        ServerSpec spec = new ServerSpec(this.getName(), kind, session.getAPSName(), session.getClusterName());
        IServiceMgr serviceMgr = ServiceMgrFactory.getServiceMgr();
        try {
            if (!kind.equals("cacheserver") && !kind.equals("pageserver")) {
                try {
                    return serviceMgr.getServiceNames(spec, session.getUserURI(), true);
                }
                catch (OCAFrameworkException.NotFoundInDirectory e) {
                    boolean isServerAlive = false;
                    IProperty prop = this.getProperty(PropertyIDs.SI_SERVER_IS_ALIVE);
                    if (prop != null) {
                        Integer n = (Integer)prop.getValue();
                        if (n != null) {
                            isServerAlive = n > 0;
                        }
                    } else {
                        IInfoObjects objs;
                        int count;
                        IInternalInfoStore store = this.getInfoStore();
                        if (store != null && (count = (objs = store.query("select si_server_is_Alive from ci_systemobjects where si_id" + this.getID())).size()) == 1) {
                            Integer n2;
                            IInfoObject obj = (IInfoObject)objs.get(0);
                            IProperty prop2 = this.getProperty(PropertyIDs.SI_SERVER_IS_ALIVE);
                            if (prop2 != null && (n2 = (Integer)prop2.getValue()) != null) {
                                boolean bl = isServerAlive = n2 > 0;
                            }
                        }
                    }
                    if (!isServerAlive) {
                        throw e;
                    }
                    this.ensureMetrics();
                    PropertyArrayHelper metricsBag = new PropertyArrayHelper(this.m_metricsForBackwardsCompatibility, PropertyIDs.SI_TOTAL);
                    ArrayList<String> svrList = new ArrayList<String>();
                    Iterator iter = metricsBag.iterator();
                    while (iter.hasNext()) {
                        PropertyBag subBag = (PropertyBag)iter.next();
                        svrList.add(subBag.getString((Object)PropertyIDs.SI_NAME));
                    }
                    String[] sa = new String[svrList.size()];
                    sa = svrList.toArray(sa);
                    return sa;
                }
            }
            ArrayList<String> svrList = new ArrayList<String>();
            String[] svrarr = serviceMgr.getServiceNames(spec, session.getUserURI(), true);
            for (int i = 0; i < svrarr.length; ++i) {
                String svr = svrarr[i];
                svrList.add(svr);
            }
            if (kind.equals("cacheserver")) {
                svrList.add("CacheServerAdmin");
            }
            if (kind.equals("pageserver")) {
                svrList.add("PageServerAdmin");
            }
            String[] sa = new String[svrList.size()];
            sa = svrList.toArray(sa);
            return sa;
        }
        catch (OCAFrameworkException e) {
            LOG.warn((Object)"OCAFrameworkException", (Throwable)((Object)e));
            throw SDKException.map(e);
        }
    }

    public Object getServiceAdminObject(String serviceAdminName) throws SDKException {
        if (serviceAdminName == null || serviceAdminName.length() == 0) {
            return this.getServerAdmin();
        }
        if ("ISGeneralAdmin".equals(serviceAdminName)) {
            return this.getServerGeneralAdmin();
        }
        String progId = "CrystalEnterprise." + serviceAdminName;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("progID:" + progId));
        }
        return this.getSpecificServerAdmin(progId, serviceAdminName);
    }

    private Object getSpecificServerAdmin(String progID, String serviceName) throws SDKException {
        IPluginMgr pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", this.getSession());
        Object adminPlugin = pluginMgr.getPluginInterface(progID, "admin");
        IInternalAdminService internalInterface = (IInternalAdminService)adminPlugin;
        internalInterface.initialize(serviceName, this.getServerAdministrator(), this.getSession().getUserURI(), this, this.getInfoStore());
        return internalInterface;
    }

    private Object getServerAdministrator() throws SDKException {
        OCAAdministrator admin = null;
        this.ensureProperties();
        String serverKind = this.getStringProp(PropertyIDs.SI_SERVER_KIND);
        ISecuritySession session = this.getSession();
        String apsName = session.getAPSName();
        String userURI = session.getUserURI();
        String name = this.getName();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Server name=" + name + ",aps=" + apsName + ",userURI=" + userURI));
        }
        try {
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object o = ServiceMgrFactory.getServiceMgr().getUnmanagedService("OCAAdministrator", new ServerSpec(name, serverKind, apsName, false), userURI);
            if (o != null) {
                admin = OCAAdministratorHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)o);
            }
        }
        catch (OCAFrameworkException e) {
            LOG.warn((Object)"OCAFrameworkException", (Throwable)((Object)e));
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.warn((Object)"SystemException", (Throwable)e);
            throw new SDKException.ServerAdminError((Exception)((Object)e));
        }
        return admin;
    }

    public ExpectedRunState getExpectedRunState() {
        Integer n;
        IProperty prop = super.getProperty(PropertyIDs.SI_EXPECTED_RUN_STATE);
        if (prop != null && (n = (Integer)prop.getValue()) != null) {
            return ExpectedRunState.fromInteger(n);
        }
        return ExpectedRunState.INVALID;
    }

    public void setExpectedRunState(ExpectedRunState state) {
        this.setProperty((Object)PropertyIDs.SI_EXPECTED_RUN_STATE, state.toInteger());
    }

    public Date getExpectedRunStateTimeStamp() throws SDKException {
        IProperty tsProp = this.getProperty(PropertyIDs.SI_EXPECTED_RUN_STATE_TS);
        if (tsProp == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_EXPECTED_RUN_STATE_TS);
        }
        return (Date)tsProp.getValue();
    }

    public ServerState getState() {
        boolean waiting;
        boolean bl = waiting = this.getIntegerProp(PropertyIDs.SI_SERVER_WAITING_FOR_RESOURCES) > 0;
        if (this.getIntegerProp(PropertyIDs.SI_SERVER_IS_ALIVE) == 0) {
            return ServerState.STOPPED;
        }
        if (waiting) {
            return ServerState.WAITING_FOR_RESOURCES;
        }
        return ServerState.RUNNING;
    }

    public boolean getAutoBoot() {
        return this.getBoolProp(PropertyIDs.SI_AUTOBOOT);
    }

    public void setAutoBoot(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_AUTOBOOT, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public IConfiguredServices getHostedServices() throws SDKException {
        if (this.m_configuredServices == null) {
            this.m_configuredServices = new ConfiguredServices();
            this.m_configuredServices.initialize((Object)PropertyIDs.SI_HOSTED_SERVICES, "SI_SERVICE", (AbstractInfoObject)this, this.getInfoStore());
        }
        return this.m_configuredServices;
    }

    public IConfiguredContainer setContainer(int id) throws SDKException {
        Set containerIDs = this.getConfiguredContainers().getConfiguredContainerIDs();
        if (containerIDs.size() == 0) {
            return this.getConfiguredContainers().add(id);
        }
        Iterator iter = containerIDs.iterator();
        if (iter.hasNext()) {
            Integer csID = (Integer)iter.next();
            if (csID == id) {
                return this.getConfiguredContainers().get(id);
            }
            this.getConfiguredContainers().remove(csID);
            return this.getConfiguredContainers().add(id);
        }
        LOG.error((Object)"setContainer(): Reached invalid state. There is more than one service container for this server.");
        throw new SDKException.Unexpected();
    }

    public IConfiguredContainer getContainer() throws SDKException {
        IConfiguredContainers ccs = this.getConfiguredContainers();
        Set set = ccs.getConfiguredContainerIDs();
        if (set.size() < 1) {
            return null;
        }
        int id = Integer.parseInt(set.toArray()[0].toString());
        return ccs.get(id);
    }

    IConfiguredContainers getConfiguredContainers() throws SDKException {
        if (this.m_configuredContainers == null) {
            this.m_configuredContainers = new ConfiguredContainers();
            this.m_configuredContainers.initialize((Object)PropertyIDs.SI_CONFIGURED_CONTAINERS, "SI_SERVICECONTAINER", (AbstractInfoObject)this, this.getInfoStore());
        }
        return this.m_configuredContainers;
    }

    public void setServerKind(String serverKind) {
        super.setProperty((Object)PropertyIDs.SI_SERVER_KIND, serverKind);
    }

    public int getEnterpriseNodeID() {
        PropertyBag bag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_ENTERPRISENODE);
        if (bag != null) {
            return bag.getInt((Object)new Integer(1));
        }
        return 0;
    }

    public void setEnterpriseNode(int id) {
        Property entNode = (Property)this.getProperty(PropertyIDs.SI_ENTERPRISENODE);
        if (entNode == null) {
            entNode = (Property)this.addProperty(PropertyIDs.SI_ENTERPRISENODE, null, 0x8000000);
        }
        PropertyBag entNodeBag = entNode.getPropertyBag();
        entNodeBag.setProperty((Object)new Integer(1), id);
        if (id != 0) {
            entNodeBag.setProperty((Object)PropertyIDs.SI_TOTAL, 1);
        } else {
            entNodeBag.setProperty((Object)PropertyIDs.SI_TOTAL, 0);
        }
    }

    public int getPID() {
        return this.getIntegerProp(PropertyIDs.SI_PID);
    }

    public IServerDestinations getServerDestinations() throws SDKException {
        if (this.m_serverDestinations == null) {
            IConfiguredServices services = this.getHostedServices();
            Iterator iter = services.iterator();
            while (iter.hasNext()) {
                ConfiguredService svc = (ConfiguredService)iter.next();
                String cuid = svc.getCUID();
                if (cuid == null || !cuid.equals("Aevwbbdd8atBvhFtwxx6uFA")) continue;
                IConfigProperties config = svc.getConfigProps();
                IActualConfigProperties configActual = null;
                configActual = svc.getActualConfigProps();
                this.setFlag(524288);
                this.m_serverDestinations = new ServerDestinations(config, configActual);
                return this.m_serverDestinations;
            }
            String query = "select SI_ID from CI_SYSTEMOBJS where SI_CUID = 'Aevwbbdd8atBvhFtwxx6uFA' and SI_PARENTID = 52";
            IInfoObjects objs = this.getInfoStore().query(query);
            if (objs.size() == 1) {
                IInfoObject obj = (IInfoObject)objs.get(0);
                int destServiceId = obj.getID();
                ConfiguredService svc = (ConfiguredService)this.getHostedServices().get(destServiceId);
                if (svc != null) {
                    IConfigProperties config = svc.getConfigProps();
                    IActualConfigProperties configActual = null;
                    configActual = svc.getActualConfigProps();
                    this.setFlag(524288);
                    this.m_serverDestinations = new ServerDestinations(config, configActual);
                    return this.m_serverDestinations;
                }
            }
        }
        return this.m_serverDestinations;
    }

    public void copy(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, IInfoObject source, int mode) throws SDKException {
        PropertyBag cc;
        PropertyBag srcBag = (PropertyBag)source.properties();
        if (mode != 0) {
            Property disabled;
            Property metrics;
            Property serverID;
            Property ior;
            Property pid;
            Property friendlyName;
            Property name = srcBag.getItem((Object)PropertyIDs.SI_NAME);
            if (name != null) {
                name.setFlag(0x2000000);
            }
            if ((friendlyName = srcBag.getItem((Object)PropertyIDs.SI_FRIENDLY_NAME)) != null) {
                friendlyName.setFlag(0x2000000);
            }
            if ((pid = srcBag.getItem((Object)PropertyIDs.SI_PID)) != null) {
                pid.setFlag(0x2000000);
            }
            if ((ior = srcBag.getItem((Object)PropertyIDs.SI_SERVER_IOR)) != null) {
                ior.setFlag(0x2000000);
            }
            if ((serverID = srcBag.getItem((Object)PropertyIDs.SI_SERVER_ID)) != null) {
                serverID.setFlag(0x2000000);
            }
            if ((metrics = srcBag.getItem((Object)PropertyIDs.SI_METRICS)) != null) {
                metrics.setFlag(0x2000000);
            }
            if ((disabled = srcBag.getItem((Object)PropertyIDs.SI_DISABLED)) != null) {
                disabled.setFlag(0x2000000);
            }
        }
        this.preObjectRelativesCopy(PropertyIDs.SI_HOSTED_SERVICES, "SI_SERVICE", srcBag);
        this.preObjectRelativesCopy(PropertyIDs.SI_CONFIGURED_CONTAINERS, "SI_SERVICECONTAINER", srcBag);
        this.preObjectRelativesCopy(PropertyIDs.SI_ENTERPRISENODE, "SI_ENTERPRISENODE", srcBag);
        this.preObjectRelativesCopy(PropertyIDs.SI_SERVERGROUPS, "SERVERGROUPS_TO_SERVER", srcBag);
        super.copy(session, collection, id, source, mode);
        this.postObjectRelativesCopy(PropertyIDs.SI_HOSTED_SERVICES, "SI_SERVICE", srcBag);
        this.postObjectRelativesCopy(PropertyIDs.SI_CONFIGURED_CONTAINERS, "SI_SERVICECONTAINER", srcBag);
        this.postObjectRelativesCopy(PropertyIDs.SI_SERVERGROUPS, "SERVERGROUPS_TO_SERVER", srcBag);
        PropertyBag hs = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_HOSTED_SERVICES);
        if (hs != null) {
            this.removeConfigActual(hs);
        }
        if ((cc = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_CONFIGURED_CONTAINERS)) != null) {
            this.removeConfigActual(cc);
        }
        if (mode != 0) {
            Property serverID;
            Property ior;
            Property pid;
            Property disabled;
            Property metrics;
            Property friendlyName;
            Property name = srcBag.getItem((Object)PropertyIDs.SI_NAME);
            if (name != null) {
                name.setFlags(name.getFlags() & 0xFDFFFFFF);
            }
            if ((friendlyName = srcBag.getItem((Object)PropertyIDs.SI_FRIENDLY_NAME)) != null) {
                friendlyName.setFlags(friendlyName.getFlags() & 0xFDFFFFFF);
            }
            if ((metrics = srcBag.getItem((Object)PropertyIDs.SI_METRICS)) != null) {
                metrics.setFlags(metrics.getFlags() & 0xFDFFFFFF);
            }
            if ((disabled = srcBag.getItem((Object)PropertyIDs.SI_DISABLED)) != null) {
                disabled.setFlags(disabled.getFlags() & 0xFDFFFFFF);
            }
            if ((pid = srcBag.getItem((Object)PropertyIDs.SI_PID)) != null) {
                pid.setFlags(pid.getFlags() & 0xFDFFFFFF);
            }
            if ((ior = srcBag.getItem((Object)PropertyIDs.SI_SERVER_IOR)) != null) {
                ior.setFlags(ior.getFlags() & 0xFDFFFFFF);
            }
            if ((serverID = srcBag.getItem((Object)PropertyIDs.SI_SERVER_ID)) != null) {
                serverID.setFlags(serverID.getFlags() & 0xFDFFFFFF);
            }
            this.setExpectedRunState(ExpectedRunState.STOPPED);
            this.setDisabled(true);
        } else {
            PropertyBag bag;
            Property prop = (Property)this.properties().getProperty(PropertyIDs.SI_DISABLED);
            if (prop != null) {
                prop.setFlags(prop.getFlags() & 0xDFFFFFFF);
            }
            if ((bag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_METRICS)) != null) {
                bag.cleanupChanges();
            }
        }
    }

    private void removeConfigActual(PropertyBag edgeBag) {
        PropertyArrayHelper helper = new PropertyArrayHelper(edgeBag, PropertyIDs.SI_TOTAL);
        for (int i = 0; i < helper.size(); ++i) {
            PropertyBag bag = (PropertyBag)helper.get(i);
            bag.removeLocal((Object)PropertyIDs.SI_CONFIG_ACTUAL);
        }
    }

    private void preObjectRelativesCopy(Object key, String deltaSuffix, PropertyBag rootBag) {
        Property prop = rootBag.getItem(key);
        if (prop != null) {
            prop.setFlags(prop.getFlags() & 0xFDFFFFFF);
        }
        if ((prop = rootBag.getItem((Object)PropertyIDs.nameToID("SI_ADM_ADD_" + deltaSuffix))) != null) {
            prop.setFlag(0x2000000);
        }
        if ((prop = rootBag.getItem((Object)PropertyIDs.nameToID("SI_ADM_DEL_" + deltaSuffix))) != null) {
            prop.setFlag(0x2000000);
        }
    }

    private void postObjectRelativesCopy(Object key, String deltaSuffix, PropertyBag rootBag) {
        Property prop = rootBag.getItem(key);
        if (prop != null) {
            prop.setFlag(0x2000000);
        }
        if ((prop = rootBag.getItem((Object)PropertyIDs.nameToID("SI_ADM_ADD_" + deltaSuffix))) != null) {
            prop.setFlags(prop.getFlags() & 0xFDFFFFFF);
        }
        if ((prop = rootBag.getItem((Object)PropertyIDs.nameToID("SI_ADM_DEL_" + deltaSuffix))) != null) {
            prop.setFlags(prop.getFlags() & 0xFDFFFFFF);
        }
    }

    public IStatusInfo getStatusInfo() {
        Property statusInfo = (Property)this.getProperty(PropertyIDs.SI_STATUSINFO);
        if (statusInfo != null && statusInfo.isContainer()) {
            return new StatusInfo(statusInfo.getPropertyBag());
        }
        return null;
    }

    public IServerMetrics getMetrics() throws SDKException {
        if (this.m_svrMetrics == null) {
            PropertyBag metrics = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_METRICS);
            if (metrics == null) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRICS);
            }
            this.m_svrMetrics = new ServerMetrics(metrics);
        }
        return this.m_svrMetrics;
    }

    private void ensureMetrics() throws SDKException {
        if (this.m_metricsForBackwardsCompatibility == null) {
            this.m_metricsForBackwardsCompatibility = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_METRICS);
            if (this.m_metricsForBackwardsCompatibility == null) {
                String query = "select SI_METRICS from CI_SYSTEMOBJS where SI_PARENTID = 16 and SI_ID = " + this.getID();
                IInfoObjects servers = this.getInfoStore().query(query);
                if (servers == null) {
                    throw new SDKException.ObjectNotFound(this.getCUID());
                }
                this.m_metricsForBackwardsCompatibility = (PropertyBag)((IServer)servers.get(0)).properties().getProperties(PropertyIDs.SI_METRICS);
            }
        }
    }

    private void ensureProperties() throws SDKException {
        if (this.m_alreadyBackqueried) {
            return;
        }
        ArrayList<Integer> propList = new ArrayList<Integer>(7);
        String queryProps = "";
        if (this.properties().getProperty(PropertyIDs.SI_SERVER_KIND) == null) {
            queryProps = "SI_SERVER_KIND, ";
            propList.add(PropertyIDs.SI_SERVER_KIND);
        }
        if (this.properties().getProperty(PropertyIDs.SI_HOSTED_SERVICES) == null) {
            queryProps = queryProps + "SI_HOSTED_SERVICES, ";
            propList.add(PropertyIDs.SI_HOSTED_SERVICES);
        }
        if (this.properties().getProperty(PropertyIDs.SI_CONFIGURED_CONTAINERS) == null) {
            queryProps = queryProps + "SI_CONFIGURED_CONTAINERS, ";
            propList.add(PropertyIDs.SI_CONFIGURED_CONTAINERS);
        }
        if (this.properties().getProperty(PropertyIDs.SI_CUID) == null) {
            queryProps = queryProps + "SI_CUID, ";
            propList.add(PropertyIDs.SI_CUID);
        }
        if (this.properties().getProperty(PropertyIDs.SI_ENTERPRISENODE) == null) {
            queryProps = queryProps + "SI_ENTERPRISENODE, ";
            propList.add(PropertyIDs.SI_ENTERPRISENODE);
        }
        if (this.properties().getProperty(PropertyIDs.SI_FRIENDLY_NAME) == null) {
            queryProps = queryProps + "SI_FRIENDLY_NAME, ";
            propList.add(PropertyIDs.SI_FRIENDLY_NAME);
        }
        if (this.properties().getProperty(PropertyIDs.SI_NAME) == null) {
            queryProps = queryProps + "SI_NAME";
            propList.add(PropertyIDs.SI_NAME);
        } else if (queryProps.length() > 2) {
            queryProps = queryProps.substring(0, queryProps.length() - 2);
        }
        if (queryProps == "") {
            return;
        }
        String queryStr = "select " + queryProps + " from ci_systemobjs where si_id = " + this.getID();
        IServer svr = (IServer)this.getInfoStore().query(queryStr).get(0);
        PropertyBag queriedProps = (PropertyBag)svr.properties();
        Iterator iter = propList.iterator();
        while (iter.hasNext()) {
            Integer propID = (Integer)iter.next();
            Property queriedProp = queriedProps.getItem((Object)propID);
            Property addedProp = (Property)this.properties().add(propID, queriedProp.getValue(), 0);
            addedProp.cleanFlag(0x20000000);
        }
        this.m_alreadyBackqueried = true;
    }

    public boolean getRequiresRestart() {
        return this.getBoolProp(PropertyIDs.SI_REQUIRES_RESTART);
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.setProperty((Object)PropertyIDs.SI_REQUIRES_RESTART, requiresRestart ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getCurrentCommandLine() {
        return this.getStringProp(PropertyIDs.SI_CURRENT_COMMAND_LINE);
    }

    public Set getObjectRelatives() {
        return this.m_objRels;
    }

    public String getSIAHostname() {
        return this.getStringProp(PropertyIDs.SI_SIA_HOSTNAME);
    }

    public Set getServerGroups() throws SDKException {
        if (this.m_serverGroups == null) {
            this.m_serverGroups = new ObjectRelatives();
            this.m_serverGroups.initialize((Object)PropertyIDs.SI_SERVERGROUPS, "SERVERGROUPS_TO_SERVER", this, false);
        }
        return this.m_serverGroups;
    }

    static {
        m_supportedAdmin.add("aps");
        m_supportedAdmin.add("jobserver");
        m_supportedAdmin.add("cacheserver");
        m_supportedAdmin.add("pageserver");
        m_supportedAdmin.add("dpscacheFullClient");
        m_supportedAdmin.add("dpsprocFullClient");
        m_supportedAdmin.add("eventserver");
        m_supportedAdmin.add("fileserver");
        m_supportedAdmin.add("rptappserver");
        m_supportedAdmin.add("webiserver");
    }
}

