/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IActualConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperty;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.desktop.server.IServerDestination;
import com.crystaldecisions.sdk.plugin.destination.common.IDestinationScheduleOptions;
import com.crystaldecisions.sdk.plugin.destination.diskunmanaged.internal.DiskUnmanagedOptions;
import com.crystaldecisions.sdk.plugin.destination.ftp.internal.FTPOptions;
import com.crystaldecisions.sdk.plugin.destination.managed.internal.ManagedOptions;
import com.crystaldecisions.sdk.plugin.destination.smtp.internal.SMTPOptions;

class ServerDestination
implements IServerDestination {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.server.internal.ServerDestination");
    private static final String STATUS = "Status";
    private static final String PROPERTY_BAG = "PropertyBag";
    IConfigProperty m_config = null;
    IActualConfigProperty m_configActual = null;
    IDestinationScheduleOptions m_options = null;
    IDestinationScheduleOptions m_actualOptions = null;
    IConfigProperties m_configPropValues = null;
    IActualConfigProperties m_actualConfigPropValues = null;
    String m_type = "";
    private PropertyBag m_optionsBag = null;
    private PropertyBag m_actualOptionsBag = null;
    private String m_origOptionsURL = null;

    ServerDestination(IConfigProperty config, IActualConfigProperty configActual, String type) {
        this.m_config = config;
        this.m_configActual = configActual;
        this.m_configPropValues = (IConfigProperties)this.m_config.getValue();
        if (this.m_configActual != null) {
            this.m_actualConfigPropValues = (IActualConfigProperties)this.m_configActual.getValue();
        }
        this.m_type = type;
    }

    public String getName() {
        return this.m_config.getName();
    }

    public boolean getRequestedStatus() {
        return (Integer)this.m_configPropValues.getProp(STATUS).getValue() != 0;
    }

    public void setRequestedStatus(boolean enabled) throws SDKException {
        int value = enabled ? 1 : 0;
        this.m_configPropValues.getProp(STATUS).setValue(new Integer(value));
    }

    public boolean getActualStatus() {
        return this.m_actualConfigPropValues != null && (Integer)this.m_actualConfigPropValues.getProp(STATUS).getValue() != 0;
    }

    public IDestinationScheduleOptions getConfigGlobalOptions() throws SDKException {
        if (this.m_options == null) {
            this.m_origOptionsURL = (String)this.m_configPropValues.getProp(PROPERTY_BAG).getValue();
            WireOb3Unpacker unpacker = new WireOb3Unpacker();
            unpacker.initialize(this.m_origOptionsURL);
            this.m_optionsBag = new PropertyBag();
            this.m_optionsBag.unpack((IBagUnpacker)unpacker);
            this.m_optionsBag.setStringHandler(StringHandlerFactory.getDefaultStringHandler());
            this.m_options = this.prepareOptions(this.m_optionsBag);
        }
        return this.m_options;
    }

    public IDestinationScheduleOptions getConfigActualGlobalOptions() throws SDKException {
        if (this.m_actualOptions == null && this.m_actualConfigPropValues != null) {
            String origActualOptionsURL = (String)this.m_actualConfigPropValues.getProp(PROPERTY_BAG).getValue();
            WireOb3Unpacker unpacker = new WireOb3Unpacker();
            unpacker.initialize(origActualOptionsURL);
            this.m_actualOptionsBag = new PropertyBag();
            this.m_actualOptionsBag.unpack((IBagUnpacker)unpacker);
            this.m_actualOptionsBag.setStringHandler(StringHandlerFactory.getDefaultStringHandler());
            this.m_actualOptions = this.prepareOptions(this.m_actualOptionsBag);
        }
        return this.m_actualOptions;
    }

    private IDestinationScheduleOptions prepareOptions(PropertyBag optionsBag) throws SDKException {
        IDestinationScheduleOptions options = null;
        if (this.m_type.equalsIgnoreCase("CrystalEnterprise.Smtp")) {
            options = new SMTPOptions();
            options.initialize(optionsBag);
        } else if (this.m_type.equalsIgnoreCase("CrystalEnterprise.Ftp")) {
            options = new FTPOptions();
            ((FTPOptions)options).initialize(optionsBag);
        } else if (this.m_type.equalsIgnoreCase("CrystalEnterprise.DiskUnmanaged")) {
            options = new DiskUnmanagedOptions();
            ((DiskUnmanagedOptions)options).initialize(optionsBag);
        } else if (this.m_type.equalsIgnoreCase("CrystalEnterprise.Managed")) {
            options = new ManagedOptions(optionsBag);
        } else {
            throw new SDKException.InvalidArg(this.m_type);
        }
        return options;
    }

    protected void prepareForCommit() {
        String packedUpdate;
        WireOb3Packer packer = new WireOb3Packer();
        if (this.m_optionsBag != null && !(packedUpdate = packer.pack(this.m_optionsBag, 0, 0, true)).equals(this.m_origOptionsURL)) {
            try {
                this.m_configPropValues.getProp(PROPERTY_BAG).setValue(packedUpdate);
            }
            catch (SDKException e) {
                LOG.error((Object)"prepareForCommit() - error modifying destination options", (Throwable)((Object)e));
            }
        }
    }
}

