/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.plugin.desktop.server.IStatusInfo;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.text.MessageFormat;
import java.util.Locale;

public class StatusInfo
implements IStatusInfo {
    private PropertyBag m_statusInfoBag;

    public StatusInfo(PropertyBag bag) {
        this.m_statusInfoBag = bag;
    }

    public int getStatus() {
        return this.m_statusInfoBag.getInt((Object)PropertyIDs.SI_STATUS);
    }

    public int getResourceID() {
        return this.m_statusInfoBag.getInt((Object)PropertyIDs.SI_RESOURCE_ID);
    }

    public String[] getPlaceholders() {
        PropertyArrayHelper arrHelper;
        int size;
        PropertyBag substStrings = this.m_statusInfoBag.getPropertyBag((Object)PropertyIDs.SI_SUBST_STRINGS);
        if (substStrings != null && (size = (arrHelper = new PropertyArrayHelper(substStrings, PropertyIDs.SI_TOTAL)).size()) > 0) {
            String[] placeholders = new String[size];
            for (int i = 0; i < size; ++i) {
                placeholders[i] = (String)arrHelper.get(i);
            }
            return placeholders;
        }
        return null;
    }

    public String getMessage(Locale locale) {
        int resID = this.getResourceID();
        if (resID == 0) {
            return null;
        }
        String msg = ServerMsgResourcesBundle.getString(String.valueOf(resID), locale);
        return this.expandPlaceholders(msg, this.getPlaceholders());
    }

    private String expandPlaceholders(String desc, String[] placeholders) {
        if (desc == null) {
            return null;
        }
        if (placeholders != null) {
            desc = MessageFormat.format(desc, placeholders);
        }
        return desc;
    }
}

