/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server.internal;

import com.businessobjects.foundation.commandline.Parameters;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.holder.IntHolder;
import com.crystaldecisions.sdk.exception.SDKException;
import java.util.Locale;

public class WindowsServiceManagerDriver {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.server.internal.WindowsServiceManagerDriver");
    private static boolean s_serviceMgrLoaded = false;
    private static final Object s_lock = new Object();
    private int m_serviceAPIHandler;
    private IntHolder m_errorCodeHolder;
    private static final int INTERVAL_MS = 1000;

    public WindowsServiceManagerDriver() throws SDKException {
        boolean success;
        if (!WindowsServiceManagerDriver.getServiceMgrLoaded() && !(success = WindowsServiceManagerDriver.loadServiceMgr())) {
            throw new SDKException.ConfigurationError("crystal.enterprise.javasdk.servicemgr.path", Parameters.getInstance().getProperty("crystal.enterprise.javasdk.servicemgr.path"));
        }
        this.m_errorCodeHolder = new IntHolder();
        int apiHandler = WindowsServiceManagerDriver.createServiceAPI(this.m_errorCodeHolder);
        if (apiHandler == 0) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
        this.m_serviceAPIHandler = apiHandler;
    }

    public int doLogonUser(String userName, String domain, String password, int logonType, int logonProvider) throws SDKException {
        IntHolder statusHolder = new IntHolder();
        if (WindowsServiceManagerDriver.logonUser(this.m_serviceAPIHandler, userName, domain, password, logonType, logonProvider, statusHolder, this.m_errorCodeHolder)) {
            return statusHolder.get();
        }
        throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
    }

    public void doImpersonateLoggedOnUser(int hToken) throws SDKException {
        if (!WindowsServiceManagerDriver.impersonateLoggedOnUser(this.m_serviceAPIHandler, hToken, this.m_errorCodeHolder)) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
    }

    public int doQueryServiceStatus(int hService) throws SDKException {
        IntHolder statusHolder = new IntHolder();
        if (WindowsServiceManagerDriver.queryServiceStatus(this.m_serviceAPIHandler, hService, statusHolder, this.m_errorCodeHolder)) {
            return statusHolder.get();
        }
        throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
    }

    public int doOpenSCManager(String machineName, String databaseName, int desiredAccess) throws SDKException {
        int hSCManager = WindowsServiceManagerDriver.openSCManager(this.m_serviceAPIHandler, machineName, databaseName, desiredAccess, this.m_errorCodeHolder);
        if (hSCManager == 0) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
        return hSCManager;
    }

    public int doOpenService(int hSCManager, String serviceName, int desiredAccess) throws SDKException {
        int hService = WindowsServiceManagerDriver.openService(this.m_serviceAPIHandler, hSCManager, serviceName, desiredAccess, this.m_errorCodeHolder);
        if (hService == 0) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
        return hService;
    }

    public int doControlService(int hService, int control) throws SDKException {
        IntHolder serviceStatus = new IntHolder();
        if (WindowsServiceManagerDriver.controlService(this.m_serviceAPIHandler, hService, control, serviceStatus, this.m_errorCodeHolder)) {
            return serviceStatus.get();
        }
        throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
    }

    public void doStartService(int hService, String[] serviceArgVectors) throws SDKException {
        if (!WindowsServiceManagerDriver.startService(this.m_serviceAPIHandler, hService, serviceArgVectors, this.m_errorCodeHolder)) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
    }

    public void doCloseServiceHandler(int hSCObject) throws SDKException {
        if (!WindowsServiceManagerDriver.closeServiceHandle(this.m_serviceAPIHandler, hSCObject, this.m_errorCodeHolder)) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
    }

    public void doRevertToSelf() throws SDKException {
        if (!WindowsServiceManagerDriver.revertToSelf(this.m_serviceAPIHandler, this.m_errorCodeHolder)) {
            throw new SDKException.NativeError(this.getLastErrorCode(), this.getErrorMessage(Locale.getDefault()));
        }
    }

    public boolean waitForService(int serviceHandle, int timeout, boolean stopping) throws SDKException {
        int current = 0;
        boolean result = false;
        while (current < timeout && !result) {
            int status = this.doQueryServiceStatus(serviceHandle);
            if (stopping && status == 1) {
                result = true;
                continue;
            }
            if (!stopping && status == 4) {
                result = true;
                continue;
            }
            try {
                Thread.sleep(1000L);
                current += 1000;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return result;
    }

    public void doDestroyServiceAPI() {
        if (this.m_serviceAPIHandler != 0) {
            WindowsServiceManagerDriver.destroyServiceAPI(this.m_serviceAPIHandler);
            this.m_serviceAPIHandler = 0;
        }
    }

    public int getLastErrorCode() {
        return this.m_errorCodeHolder.get();
    }

    public String getErrorMessage(Locale locale) {
        return WindowsServiceManagerDriver.formatErrorMessage(this.getLastErrorCode(), locale);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_serviceAPIHandler != 0) {
            WindowsServiceManagerDriver.destroyServiceAPI(this.m_serviceAPIHandler);
        }
    }

    private static boolean loadServiceMgr() {
        String serviceMgrPath = null;
        try {
            serviceMgrPath = Parameters.getInstance().getProperty("crystal.enterprise.javasdk.servicemgr.path");
            System.load(serviceMgrPath);
            WindowsServiceManagerDriver.setServiceMgrLoaded(true);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warn((Object)("loadServiceMgr(): Using load to get " + serviceMgrPath + " failed"), (Throwable)e);
            try {
                System.loadLibrary("ServiceManagerJNI");
                WindowsServiceManagerDriver.setServiceMgrLoaded(true);
            }
            catch (UnsatisfiedLinkError e1) {
                LOG.warn((Object)"loadServiceMgr(): Using loadLibrary to get ServiceManagerJNI failed", (Throwable)e1);
            }
        }
        boolean ret = WindowsServiceManagerDriver.getServiceMgrLoaded();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setServiceMgrLoaded(boolean loaded) {
        Object object = s_lock;
        synchronized (object) {
            s_serviceMgrLoaded = loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getServiceMgrLoaded() {
        boolean ret;
        Object object = s_lock;
        synchronized (object) {
            ret = s_serviceMgrLoaded;
        }
        return ret;
    }

    private static native int createServiceAPI(IntHolder var0);

    private static native boolean queryServiceStatus(int var0, int var1, IntHolder var2, IntHolder var3);

    private static native boolean logonUser(int var0, String var1, String var2, String var3, int var4, int var5, IntHolder var6, IntHolder var7);

    private static native boolean impersonateLoggedOnUser(int var0, int var1, IntHolder var2);

    private static native int openSCManager(int var0, String var1, String var2, int var3, IntHolder var4);

    private static native int openService(int var0, int var1, String var2, int var3, IntHolder var4);

    private static native boolean controlService(int var0, int var1, int var2, IntHolder var3, IntHolder var4);

    private static native boolean startService(int var0, int var1, String[] var2, IntHolder var3);

    private static native boolean closeServiceHandle(int var0, int var1, IntHolder var2);

    private static native boolean revertToSelf(int var0, IntHolder var1);

    private static native void destroyServiceAPI(int var0);

    private static native String formatErrorMessage(int var0, Locale var1);

    static {
        WindowsServiceManagerDriver.loadServiceMgr();
    }
}

