/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.user.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.plugin.desktop.user.IUserAlias;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

class UserAlias
implements IUserAlias,
ISDKElement {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.user.internal.UserAlias");
    static final Integer KEY_ID = PropertyIDs.SI_NAME;
    private IProperties m_aliasProperties;
    protected IPluginInfo[] m_pluginInfo;
    protected ISecuritySession m_session;

    UserAlias(ISecuritySession session) {
        this.m_aliasProperties = new SDKPropertyBag();
        this.m_session = session;
        this.m_pluginInfo = null;
    }

    UserAlias(IProperties aliasProperties, ISecuritySession session) {
        this.m_aliasProperties = aliasProperties;
        this.m_session = session;
        this.m_pluginInfo = null;
    }

    void checkName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(name);
        }
        int index = name.indexOf(":");
        if (index == -1) {
            throw new IllegalArgumentException(name);
        }
        String nameAuth = name.substring(0, index);
    }

    void checkID(String id) {
        int index = id.indexOf(":");
        if (index == -1) {
            throw new IllegalArgumentException(id);
        }
        String idAuth = id.substring(0, index);
        if (this.m_session != null) {
            if (this.m_pluginInfo == null) {
                try {
                    IPluginMgr m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", this.m_session);
                    this.m_pluginInfo = m_pluginMgr.getPlugins("auth");
                }
                catch (SDKException e) {
                    return;
                }
            }
            boolean found = false;
            for (int i = 0; i < this.m_pluginInfo.length; ++i) {
                if (idAuth.compareTo(this.m_pluginInfo[i].getProgID()) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException(id);
            }
        }
    }

    void CheckParams(String name, String id) {
        this.checkName(name);
        this.checkID(id);
    }

    void initialize(String name, String id, boolean disabled) {
        this.CheckParams(name, id);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_NAME, name);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_ID, id);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_DISABLED, disabled);
    }

    void initialize(String name, boolean disabled) {
        this.checkName(name);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.ADM_ALIAS_NAME, name);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_NAME, name);
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_DISABLED, disabled);
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_NAME, bag);
        this.copyProperty(PropertyIDs.SI_ID, bag);
        this.copyProperty(PropertyIDs.SI_DISABLED, bag);
        this.copyProperty(PropertyIDs.ADM_ALIAS_NAME, bag);
        this.m_aliasProperties = bag;
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_aliasProperties);
    }

    public String getID() {
        Property prop = (Property)this.m_aliasProperties.getProperty(PropertyIDs.SI_ID);
        LOG.assertNotNull((Object)prop, "prop is null.");
        String combinedID = prop.getString();
        int index = combinedID.indexOf(":");
        String strID = combinedID.substring(index + 1);
        return strID;
    }

    public String getName() {
        Property prop = (Property)this.m_aliasProperties.getProperty(PropertyIDs.SI_NAME);
        LOG.assertNotNull((Object)prop, "prop is null.");
        return prop.getString();
    }

    public String getAuthentication() {
        Property prop = (Property)this.m_aliasProperties.getProperty(PropertyIDs.SI_ID);
        LOG.assertNotNull((Object)prop, "prop is null.");
        String combinedID = prop.getString();
        int index = combinedID.indexOf(":");
        return combinedID.substring(0, index);
    }

    public int getType() {
        if ("secEnterprise".equalsIgnoreCase(this.getAuthentication())) {
            return 0;
        }
        return 1;
    }

    public boolean isDisabled() {
        Property prop = (Property)this.m_aliasProperties.getProperty(PropertyIDs.SI_DISABLED);
        LOG.assertNotNull((Object)prop, "prop is null.");
        return prop.getBoolean();
    }

    public void setDisabled(boolean newDisabled) {
        Boolean newBoolean = newDisabled ? Boolean.TRUE : Boolean.FALSE;
        this.m_aliasProperties.setProperty((Object)PropertyIDs.SI_DISABLED, newBoolean);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserAlias) {
            UserAlias alias = (UserAlias)obj;
            return alias.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return "ID=" + this.getID() + ", Authentication=" + this.getAuthentication() + ", Name=" + this.getName() + ",Type=" + this.getType() + ",Disabled=" + this.isDisabled();
    }

    private void copyProperty(Integer id, IProperties bag) {
        IProperty property2 = this.m_aliasProperties.getProperty(id);
        if (property2 != null) {
            bag.setProperty((Object)id, property2.getValue());
        }
    }
}

