/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.usergroup.internal;

import com.businessobjects.sdk.plugin.desktop.common.internal.AbstractPrincipal;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.internal.UserGroupAssociates;
import com.crystaldecisions.sdk.plugin.desktop.usergroup.IUserGroup;
import com.crystaldecisions.sdk.plugin.desktop.usergroup.IUserGroupAliases;
import com.crystaldecisions.sdk.plugin.desktop.usergroup.internal.UserGroupAliases;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Set;

class UserGroup
extends AbstractPrincipal
implements IUserGroup {
    private Set m_users;
    private Set m_parents;
    private Set m_subGroups;
    private IUserGroupAliases m_aliases;
    public static final Integer SEC_ID_USERGROUP_FOLDER = new Integer(20);

    UserGroup() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_USERGROUP_FOLDER);
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (UserGroup.this.isNew()) {
                        UserGroup.this.getSubGroups();
                        UserGroup.this.getUsers();
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public synchronized Set getSubGroups() {
        if (this.m_subGroups == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_SUBGROUPS) == null) {
                    this.properties().add(PropertyIDs.SI_SUBGROUPS, null, 0x8000000);
                }
                this.m_subGroups = new UserGroupAssociates(PropertyIDs.SI_SUBGROUPS, PropertyIDs.SI_ADM_ADD_SUBUSERGROUPS_TO_USERGROUP, PropertyIDs.SI_ADM_DEL_SUBUSERGROUPS_FROM_USERGROUP, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_subGroups;
    }

    public synchronized Set getUsers() {
        if (this.m_users == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_GROUP_MEMBERS) == null) {
                    this.properties().add(PropertyIDs.SI_GROUP_MEMBERS, null, 0x8000000);
                }
                this.m_users = new UserGroupAssociates(PropertyIDs.SI_GROUP_MEMBERS, PropertyIDs.SI_ADM_ADD_USERS_TO_USERGROUP, PropertyIDs.SI_ADM_DEL_USERS_FROM_USERGROUP, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_users;
    }

    public synchronized Set getParentGroups() {
        if (this.m_parents == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_USERGROUPS) == null) {
                    this.properties().add(PropertyIDs.SI_USERGROUPS, null, 0x8000000);
                }
                this.m_parents = new UserGroupAssociates(PropertyIDs.SI_USERGROUPS, PropertyIDs.SI_ADM_ADD_USERGROUPS_TO_USERGROUP, PropertyIDs.SI_ADM_DEL_USERGROUPS, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_parents;
    }

    public synchronized IUserGroupAliases getAliases() {
        if (this.m_aliases == null) {
            PropertyBag propertyBag = (PropertyBag)this.properties();
            PropertyBag aliasesBag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_ALIASES);
            if (aliasesBag == null) {
                Property prop = propertyBag.addArray((Object)PropertyIDs.SI_ALIASES);
                aliasesBag = prop.getPropertyBag();
            }
            this.m_aliases = new UserGroupAliases(aliasesBag, this.getSession());
        }
        return this.m_aliases;
    }
}

