/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.destination.smtp.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.destination.common.internal.FRSFileList;
import com.crystaldecisions.sdk.plugin.destination.smtp.IAttachments;
import com.crystaldecisions.sdk.plugin.destination.smtp.ISMTPOptions;
import com.crystaldecisions.sdk.plugin.destination.smtp.internal.Attachments;
import com.crystaldecisions.sdk.plugin.destination.smtp.internal.SMTPAddresses;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.List;

public class SMTPOptions
implements ISMTPOptions {
    private PropertyBag m_props;

    public void initialize(PropertyBag props) {
        this.m_props = props;
    }

    private Object getProp(Integer id) throws SDKException {
        Property p = this.m_props.getItem((Object)id);
        if (p == null) {
            throw new SDKException.PropertyNotFound(new String(PropertyIDs.idToName(id)));
        }
        return p.getValue();
    }

    public String getDomainName() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_DOMAIN_NAME);
    }

    public void setDomainName(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_DOMAIN_NAME, (Object)sVal);
    }

    public String getServerName() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_SERVER);
    }

    public void setServerName(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_SERVER, (Object)sVal);
    }

    public int getPort() throws SDKException {
        return this.m_props.getInt((Object)PropertyIDs.SI_PORT);
    }

    public void setPort(int iVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_PORT, (Object)new Integer(iVal));
    }

    public int getSMTPAuthenticationType() throws SDKException {
        String authStr = this.m_props.getString((Object)PropertyIDs.SI_AUTH_TYPE);
        int authType = 0;
        if (authStr != null) {
            if (authStr.equalsIgnoreCase("PLAIN")) {
                authType = 1;
            }
            if (authStr.equalsIgnoreCase("LOGIN")) {
                authType = 2;
            }
        }
        return authType;
    }

    public void setSMTPAuthenticationType(int iVal) {
        String auth = null;
        switch (iVal) {
            case 1: {
                auth = "PLAIN";
                break;
            }
            case 2: {
                auth = "LOGIN";
                break;
            }
            default: {
                auth = "NONE";
            }
        }
        this.m_props.setProperty((Object)PropertyIDs.SI_AUTH_TYPE, (Object)auth);
    }

    public String getSMTPUserName() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_USERNAME);
    }

    public void setSMTPUserName(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_USERNAME, (Object)sVal);
    }

    public void setSMTPPassword(String sVal) {
        this.m_props.addItem((Object)PropertyIDs.SI_CRED_KEY, (Object)sVal, 0x1800000);
        this.m_props.addItem((Object)PropertyIDs.SI_PASSWORD, (Object)("".equals(sVal) ? "" : "********"), 0);
    }

    public boolean isSMTPPasswordNotEmpty() throws SDKException {
        Property prop = this.m_props.getItem((Object)PropertyIDs.SI_CRED_KEY);
        StringHandler encryption = this.m_props.getStringHandler();
        return prop != null && !"".equals(encryption.unpack((String)prop.getValue()));
    }

    public boolean isSMTPPasswordSet() throws SDKException {
        return this.m_props.getItem((Object)PropertyIDs.SI_CRED_KEY) != null;
    }

    public String getSenderAddress() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_SENDER_NAME);
    }

    public void setSenderAddress(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_SENDER_NAME, (Object)sVal);
    }

    public List getToAddresses() throws SDKException {
        PropertyBag aliasesBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_MAIL_ADDRESSES);
        if (aliasesBag == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_MAIL_ADDRESSES);
            aliasesBag = prop.getPropertyBag();
        }
        return new SMTPAddresses(aliasesBag);
    }

    public boolean isToAddressesSet() {
        return this.m_props.getPropertyBag((Object)PropertyIDs.SI_MAIL_ADDRESSES) != null;
    }

    public List getCCAddresses() throws SDKException {
        PropertyBag aliasesBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_MAIL_CC);
        if (aliasesBag == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_MAIL_CC);
            aliasesBag = prop.getPropertyBag();
        }
        return new SMTPAddresses(aliasesBag);
    }

    public boolean isCCAddressesSet() {
        return this.m_props.getPropertyBag((Object)PropertyIDs.SI_MAIL_CC) != null;
    }

    public String getSubject() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_MAIL_SUBJECT);
    }

    public void setSubject(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_MAIL_SUBJECT, (Object)sVal);
    }

    public String getMessage() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_MAIL_MESSAGE);
    }

    public void setMessage(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_MAIL_MESSAGE, (Object)sVal);
    }

    public IAttachments getAttachments() throws SDKException {
        PropertyBag aliasesBag = this.m_props.getPropertyBag((Object)PropertyIDs.SI_OUTPUT_FILES);
        if (aliasesBag == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_OUTPUT_FILES);
            aliasesBag = prop.getPropertyBag();
        }
        return new Attachments(aliasesBag);
    }

    public boolean isAttachmentsEnabled() throws SDKException {
        return this.m_props.getBoolean((Object)PropertyIDs.SI_SMTP_ENABLEATTACHMENTS);
    }

    public void setAttachmentsEnabled(boolean bEnabled) {
        this.m_props.setProperty((Object)PropertyIDs.SI_SMTP_ENABLEATTACHMENTS, bEnabled);
    }

    public String getDelimiter() throws SDKException {
        return this.m_props.getString((Object)PropertyIDs.SI_SEPARATOR);
    }

    public void setDelimiter(String sVal) {
        this.m_props.setProperty((Object)PropertyIDs.SI_SEPARATOR, (Object)sVal);
    }

    public List getInputFiles() {
        PropertyBag frsPaths = this.m_props.getPropertyBag((Object)PropertyIDs.SI_INPUT_FILES);
        if (frsPaths == null) {
            Property prop = this.m_props.addArray((Object)PropertyIDs.SI_INPUT_FILES);
            frsPaths = prop.getPropertyBag();
        }
        return new FRSFileList(frsPaths);
    }

    public boolean getSkipMimeHeaders() {
        return this.m_props.getBoolean((Object)PropertyIDs.SI_SMTP_SKIP_MIME_HEADER);
    }

    public void setSkipMimeHeaders(boolean skip) {
        this.m_props.setProperty((Object)PropertyIDs.SI_SMTP_SKIP_MIME_HEADER, skip);
    }
}

