/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.pojomgr.axis2.biptransport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import com.crystaldecisions.sdk.occa.transport.internal.AbstractTransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.EncodingStyle;
import com.crystaldecisions.sdk.occa.transport.internal.IDelaySerializationCallback;
import com.crystaldecisions.sdk.occa.transport.internal.IEncodingSupport;
import com.crystaldecisions.sdk.occa.transport.internal.ILocalTransportRequestHandler;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportSender;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportService;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.TransportServiceFactory;
import com.crystaldecisions.sdk.pojomgr.axis2.biptransport.internal.BIPTransportUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;

public class BIPTransportSender
extends AbstractHandler
implements TransportSender {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.oca2mgr.internal.biptransport.BIPTransportSender");
    private static final ThreadLocal s_securityContext = new ThreadLocal();
    private static final BIPTransportHelperFactory s_statelessHelperFactory = new BIPTransportHelperFactory(false);
    protected static final String SECURITY_CONTEXT = PropertyIDs.idToName((Integer)PropertyIDs.SI_SECURITY_CONTEXT);

    public void cleanUp(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            OMOutputFormat format = new OMOutputFormat();
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc != null) {
                format.setCharSetEncoding(charSetEnc);
            } else {
                OperationContext opctx = msgContext.getOperationContext();
                if (opctx != null) {
                    charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
                }
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setDoingMTOM(BIPTransportUtils.doWriteMTOM(msgContext));
            if (BIPTransportUtils.isDoingREST(msgContext)) {
                throw new AxisFault("REST is not supported yet");
            }
            msgContext.setDoingREST(false);
            format.setSOAP11(msgContext.isSOAP11());
            format.setDoOptimize(msgContext.isDoingMTOM());
            format.setCharSetEncoding(charSetEnc);
            EndpointReference epr = null;
            String transportURL = (String)msgContext.getProperty("TransportURL");
            if (transportURL != null) {
                epr = new EndpointReference(transportURL);
            } else if (msgContext.getTo() != null && !"http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(msgContext.getTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgContext.getTo().getAddress())) {
                epr = msgContext.getTo();
            }
            SOAPEnvelope dataOut = msgContext.getEnvelope();
            if (epr != null) {
                if (!epr.getAddress().equals("http://www.w3.org/2005/08/addressing/none")) {
                    this.writeMessageWithOCASender(msgContext, epr, dataOut, format);
                }
            } else if (BIPTransportSender.isSerializeResponse(msgContext)) {
                this.sendUsingOutputStream(msgContext, format, dataOut);
            }
            if (msgContext.getOperationContext() != null) {
                msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
            }
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format, SOAPEnvelope dataOut) throws XMLStreamException {
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        format.setDoOptimize(msgContext.isDoingMTOM());
        dataOut.serializeAndConsume(out, format);
    }

    private void writeMessageWithOCASender(final MessageContext msgContext, EndpointReference toURL, final SOAPEnvelope dataout, final OMOutputFormat format) throws AxisFault {
        try {
            ITransportEntity response;
            ILocalTransportRequestHandler localHandler;
            ISecuritySession session;
            Object securityContext = msgContext.getServiceContext().getConfigurationContext().getProperty("SECURITY_CONTEXT");
            if (securityContext == null) {
                session = (ISecuritySession)s_securityContext.get();
            } else if (securityContext instanceof String) {
                try {
                    session = SecurityFactory.getFactory().makeSecuritySession((String)securityContext);
                }
                catch (SDKException e) {
                    throw AxisFault.makeFault((Throwable)((Object)e));
                }
            } else if (securityContext instanceof ISecuritySession) {
                session = (ISecuritySession)securityContext;
            } else {
                throw new AxisFault("invalid object type context property:SECURITY_CONTEXT");
            }
            if (session != null) {
                s_securityContext.set(session);
            }
            String address = toURL.getAddress();
            String soapActionString = msgContext.getSoapAction();
            if (soapActionString == null || soapActionString.length() == 0) {
                soapActionString = msgContext.getWSAAction();
            }
            if (soapActionString == null) {
                soapActionString = "\"\"";
            }
            boolean stateful = Boolean.valueOf((String)msgContext.getOptions().getProperty("STATEFUL"));
            ITransportSender sender = (ITransportSender)msgContext.getProperty("TRANSPORT_SENDER");
            if (sender == null) {
                try {
                    if (stateful) {
                        BIPTransportHelperFactory helperFactory = new BIPTransportHelperFactory(true);
                        sender = ((ITransportService)TransportServiceFactory.getFactory().makeOCCA("", session)).createSender(address, helperFactory);
                        helperFactory.setSender(sender);
                    } else {
                        sender = ((ITransportService)TransportServiceFactory.getFactory().makeOCCA("", session)).getSender(address, s_statelessHelperFactory);
                    }
                }
                catch (SDKException e) {
                    throw AxisFault.makeFault((Throwable)((Object)e));
                }
            }
            final ITransportEntity request = sender.createEntity();
            if (session != null) {
                String securityContextString = session.getSessionID();
                request.addHeader(SECURITY_CONTEXT, securityContextString);
            }
            request.addHeader("SI_ADDRESS", address);
            request.addHeader("SI_SOAP_ACTION", soapActionString);
            request.addHeader("SI_MTOM_ENABLED", new Boolean(msgContext.isDoingMTOM()));
            AxisOperation axisOperation = msgContext.getAxisOperation();
            if (axisOperation != null) {
                request.addHeader("SI_OPERATION", axisOperation.getName().toString());
            }
            if ((localHandler = (ILocalTransportRequestHandler)msgContext.getProperty("LOCAL_HANDLER")) != null) {
                request.addHeader("SI_ENVELOPE", dataout);
                response = sender.request(request, localHandler, new IDelaySerializationCallback(){

                    public void serialize() throws Throwable {
                        BIPTransportSender.serializeRequest(msgContext, request, dataout, format);
                    }
                });
            } else {
                BIPTransportSender.serializeRequest(msgContext, request, dataout, format);
                response = sender.request(request);
            }
            this.processResponse(response, msgContext);
            String actualServiceAddress = sender.getActualServiceAddress();
            Options current = msgContext.getOptions();
            while (current.getParent() != null) {
                current = current.getParent();
            }
            Options parent = current;
            if (stateful && parent != null) {
                parent.setTo(new EndpointReference(actualServiceAddress));
            }
            if (parent != null) {
                parent.setProperty("TRANSPORT_ACTUAL_ADDRESS", (Object)actualServiceAddress);
            }
            if (msgContext.getOperationContext() != null) {
                msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (SDKException e) {
            throw AxisFault.makeFault((Throwable)((Object)e));
        }
    }

    private static void serializeRequest(MessageContext msgContext, ITransportEntity request, SOAPEnvelope dataout, OMOutputFormat format) throws XMLStreamException {
        boolean doingMTOM = msgContext.isDoingMTOM();
        if (doingMTOM && request instanceof IEncodingSupport) {
            ((IEncodingSupport)((Object)request)).setEncodingStyle(EncodingStyle.PULLSTREAM);
        }
        OutputStream bytesOut = request.getBodyOutputStream();
        dataout.serializeAndConsume(bytesOut, format);
    }

    private static boolean isSerializeResponse(MessageContext msgContext) {
        SessionContext sessionContext = msgContext.getSessionContext();
        if (sessionContext == null) {
            return true;
        }
        return ObjectUtils.getBooleanValue((Object)sessionContext.getProperty("SERIALIZE_RESPONSE"), (boolean)true);
    }

    protected void processResponse(ITransportEntity response, MessageContext ctx) throws AxisFault {
        InputStream body = response.getBodyAsInputStream();
        ctx.setProperty("TRANSPORT_IN", (Object)body);
    }

    public void cleanup(MessageContext messageContext) throws AxisFault {
    }

    public void stop() {
    }

    private static class BIPTransportHelperFactory
    implements ITransportServiceHelper.IFactory {
        public final BIPTransportServiceHelper m_bipTransportServiceHelper;

        public BIPTransportHelperFactory(boolean stateful) {
            this.m_bipTransportServiceHelper = new BIPTransportServiceHelper(stateful);
        }

        public void setSender(ITransportSender sender) {
            this.m_bipTransportServiceHelper.setSender(sender);
        }

        public ITransportServiceHelper makeHelper() {
            return this.m_bipTransportServiceHelper;
        }
    }

    private static class BIPTransportServiceHelper
    extends AbstractTransportServiceHelper {
        private final boolean m_stateful;
        private ITransportSender m_sender;

        public BIPTransportServiceHelper(boolean stateful) {
            this.m_stateful = stateful;
        }

        public void setSender(ITransportSender sender) {
            this.m_sender = sender;
        }

        public boolean isStateful() {
            return this.m_stateful;
        }

        public boolean isRecoverable(String serializedException) {
            return false;
        }

        public void release() {
            if (this.m_stateful && this.m_sender != null) {
                ITransportEntity entity = this.m_sender.createEntity();
                entity.setBody(new byte[0]);
                entity.addHeader(IDHelper.idToName((Integer)PropertyIDs.SI_SCOPE_CONTROL_CLOSE), Boolean.TRUE);
                try {
                    this.m_sender.send(entity);
                }
                catch (Exception e) {
                    LOG.warn((Object)"(release:245): exception during close session", (Throwable)e);
                }
            }
            super.release();
        }
    }
}

