/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.pojomgr.axis2.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.pojomgr.axis2.deployment.internal.ClientDeploymentDescriptor;
import com.crystaldecisions.sdk.pojomgr.axis2.internal.InfoStoreAxisConfigurator;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.DFOBuilder;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.InputStream;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;

public class POJOConfigurator
implements AxisConfigurator {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.pojomgr.internal.POJOConfiguration");
    private InfoStoreAxisConfigurator m_infoStoreConfigurator;
    private String m_serviceName;
    private static final String SERVICE_DFO_LOCATION = "META-INF/BusinessObjects.Services/";

    public POJOConfigurator(AxisConfiguration axisConfiguration, String svr, String service, String aps, String clusterName) {
        this.m_infoStoreConfigurator = new InfoStoreAxisConfigurator(axisConfiguration, svr, service, aps, clusterName);
        this.m_serviceName = service;
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        return this.m_infoStoreConfigurator.getAxisConfiguration();
    }

    public void loadServices() {
        this.m_infoStoreConfigurator.loadServices();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            URL dfoURL = loader.getResource("META-INF/BusinessObjects.Services/BusinessObjects_Service_" + this.m_serviceName + "_dfo.xml");
            if (dfoURL != null) {
                InputStream stream = dfoURL.openStream();
                DFOBuilder builder = new DFOBuilder();
                IProperties props = builder.build(stream);
                String serviceName = props.getString(PropertyIDs.SI_NAME);
                IProperties ddProps = props.getProperties(PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR);
                ClientDeploymentDescriptor dd = new ClientDeploymentDescriptor(ddProps);
                this.m_infoStoreConfigurator.addService(serviceName, dd);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"(loadServices:79): ", (Throwable)e);
        }
    }

    public void engageGlobalModules() throws AxisFault {
        this.m_infoStoreConfigurator.engageGlobalModules();
    }

    public void cleanup() {
    }
}

