/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.ISDKSet;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBagHelper;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractSDKSet
extends AbstractSet
implements ISDKSet {
    protected boolean m_readonly;
    protected PropertyArrayHelper m_bag;
    protected List m_elements;
    private SDKPropertyBagHelper m_bagHelper;

    protected AbstractSDKSet(PropertyBag bag, Integer countID, Integer keyID, Integer baseID, boolean readonly) {
        this.m_bag = new PropertyArrayHelper(bag, countID, baseID);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.buildArray();
        if (keyID != null) {
            this.m_bagHelper = new SDKPropertyBagHelper(this.m_bag, keyID);
        }
        this.m_readonly = readonly;
    }

    protected AbstractSDKSet(PropertyBag bag, Integer countID, Integer keyID, boolean readonly) {
        this.m_bag = new PropertyArrayHelper(bag, countID);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.buildArray();
        if (keyID != null) {
            this.m_bagHelper = new SDKPropertyBagHelper(this.m_bag, keyID);
        }
        this.m_readonly = readonly;
    }

    protected AbstractSDKSet(PropertyBag bag, Integer countID, boolean readonly) {
        this.m_bag = new PropertyArrayHelper(bag, countID);
        this.m_elements = new ArrayList(this.m_bag.size());
        this.buildArray();
        this.m_readonly = readonly;
    }

    public Object get(Object key) {
        if (this.m_bagHelper == null) {
            throw new UnsupportedOperationException();
        }
        int index = this.m_bagHelper.getIndex(key);
        if (index != -1) {
            return this.get(index);
        }
        return null;
    }

    public boolean remove(Object o) {
        if (this.m_readonly) {
            throw new UnsupportedOperationException();
        }
        int index = this.findObject(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public int size() {
        return this.m_elements.size();
    }

    public Iterator iterator() {
        return new SDKIterator();
    }

    public boolean add(Object o) {
        if (!(o instanceof ISDKElement)) {
            throw new UnsupportedOperationException();
        }
        if (this.findObject(o) != -1) {
            return false;
        }
        IProperties bag = (IProperties)this.m_bag.add(null, 0x8000000).getValue();
        ISDKElement element = (ISDKElement)o;
        element.copy(bag);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.add();
        }
        this.m_elements.add(null);
        return true;
    }

    protected boolean addNewObjectToCollection(ISDKElement newObject) {
        if (this.findObject(newObject) != -1) {
            return false;
        }
        IProperties bag = (IProperties)this.m_bag.add(null, 0x8000000).getValue();
        newObject.assumeProperties(bag);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.add();
        }
        this.m_elements.add(newObject);
        return true;
    }

    protected int findObject(Object o) {
        int index;
        if (this.m_bagHelper != null && (index = this.m_bagHelper.find(o)) != -1) {
            return index;
        }
        index = 0;
        Iterator e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() == null) {
                    return index;
                }
                ++index;
            }
        } else {
            while (e.hasNext()) {
                if (o.equals(e.next())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    protected abstract Object createCollectionObject(int var1);

    private void buildArray() {
        for (int i = 0; i < this.m_bag.size(); ++i) {
            this.m_elements.add(i, null);
        }
    }

    private Object remove(int index) {
        if (this.m_readonly) {
            throw new UnsupportedOperationException();
        }
        Object o = this.m_elements.remove(index);
        if (this.m_bagHelper != null) {
            this.m_bagHelper.remove(index);
        } else {
            this.m_bag.remove(index);
        }
        return o;
    }

    private Object get(int index) {
        Object item = this.m_elements.get(index);
        if (item == null) {
            Object obj = this.createCollectionObject(index);
            this.m_elements.set(index, obj);
            return obj;
        }
        return item;
    }

    protected boolean getReadOnly() {
        return this.m_readonly;
    }

    protected void setReadOnly(boolean value) {
        this.m_readonly = value;
    }

    private class SDKIterator
    implements Iterator {
        private int m_pos = 0;
        private int m_last = -1;

        private SDKIterator() {
        }

        public boolean hasNext() {
            return this.m_pos < AbstractSDKSet.this.size();
        }

        public Object next() {
            if (this.hasNext()) {
                this.m_last = this.m_pos++;
                return AbstractSDKSet.this.get(this.m_last);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.m_last < 0) {
                throw new IllegalStateException();
            }
            AbstractSDKSet.this.remove(this.m_last);
            if (this.m_last < this.m_pos) {
                --this.m_pos;
            }
            this.m_last = -1;
        }
    }
}

