/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import com.crystaldecisions.sdk.properties.internal.XMLErrorHandler;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DFOBuilder {
    private static final String BAG_TAG = "propertybag";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String FLAGS_ATTR = "flags";
    private static final String STRING_TYPE = "String";
    private static final String INT_TYPE = "Long";
    private static final String BOOLEAN_TYPE = "Bool";
    private static final String FLOAT_TYPE = "Float";
    private static final String DOUBLE_TYPE = "Double";
    private static final String BAG_TYPE = "Bag";
    private static final String ARRAY_TYPE = "Array";

    public IProperties build(InputStream stream) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setValidating(false);
        builderFactory.setNamespaceAware(false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        builder.setErrorHandler(new XMLErrorHandler());
        Document doc = null;
        doc = builder.parse(stream);
        Node pluginNode = doc.getFirstChild();
        if (!(pluginNode instanceof Element) || !pluginNode.getNodeName().equals("plugin")) {
            throw new IllegalArgumentException();
        }
        Node bagNode = pluginNode.getFirstChild();
        if ((bagNode = this.findFirstChildByType(bagNode, (short)1)) == null || !bagNode.getNodeName().equalsIgnoreCase(BAG_TAG)) {
            throw new IllegalArgumentException("The first element should be a <propertybag> node");
        }
        Element bagElement = (Element)bagNode;
        SDKPropertyBag bag = new SDKPropertyBag();
        this.buildBag(bagElement, bag);
        return bag;
    }

    private Node findFirstChildByType(Node firstChild, short type) {
        while (firstChild != null && type != firstChild.getNodeType()) {
            firstChild = firstChild.getNextSibling();
        }
        return firstChild;
    }

    /*
     * WARNING - void declaration
     */
    private void buildBag(Element bagElement, IProperties bag) {
        NodeList nodes = bagElement.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            void var14_14;
            Object value;
            String valueStr;
            Node child = nodes.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String propertyID = element.getAttribute(NAME_ATTR);
            if (element.getNodeName().equals(BAG_TAG)) {
                IProperties subBag = bag.addProperties(propertyID);
                this.buildBag(element, subBag);
                continue;
            }
            if (!element.getNodeName().equals(PROPERTY_TAG)) continue;
            String type = element.getAttribute(TYPE_ATTR);
            String flags = element.getAttribute(FLAGS_ATTR);
            int intFlags = Integer.parseInt(flags);
            Node textNode = this.findFirstChildByType(element.getFirstChild(), (short)3);
            String string = valueStr = textNode == null ? null : textNode.getNodeValue().trim();
            if (type.equals(STRING_TYPE)) {
                value = textNode == null ? "" : valueStr;
            } else {
                if (textNode == null) {
                    throw new IllegalArgumentException("element " + element.getNodeName() + " doesn't have a text node");
                }
                if (type.equals(INT_TYPE)) {
                    value = Integer.valueOf(valueStr);
                } else if (type.equals(BOOLEAN_TYPE)) {
                    value = Boolean.valueOf(valueStr.toLowerCase());
                } else if (type.equals(FLOAT_TYPE)) {
                    value = Float.valueOf(valueStr);
                } else if (type.equals(DOUBLE_TYPE)) {
                    value = Double.valueOf(valueStr);
                } else {
                    StringBuffer location = new StringBuffer();
                    this.buildLocation(location, element);
                    throw new IllegalArgumentException("Invalid type " + type + ", location " + location);
                }
            }
            bag.add(propertyID, var14_14, intFlags);
        }
    }

    private void buildLocation(StringBuffer builder, Element element) {
        StringBuffer thisElement = new StringBuffer();
        String tagName = element.getTagName();
        thisElement.append("<").append(tagName).append(' ');
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            thisElement.append(node.getNodeName()).append("=\"").append(node.getNodeValue()).append("\" ");
        }
        thisElement.append(">");
        builder.insert(0, thisElement.toString());
        Node parentNode = element.getParentNode();
        if (parentNode != null && parentNode instanceof Element) {
            this.buildLocation(builder, (Element)parentNode);
        }
    }
}

