/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.celib.exception.UnexpectedPropertyValueRuntimeException;
import com.crystaldecisions.celib.properties.IPropertyFactory;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Locale;

public class SDKPropertyBag
extends PropertyBag
implements IProperties,
Externalizable {
    static IPropertyFactory s_factory = new IPropertyFactory(){

        public Property makeProperty(Integer id, Object value, int flags, PropertyBag container) {
            return new SDKProperty(id, value, flags, container);
        }

        public Property makeProperty(Integer id, Object value, int flags, int type, PropertyBag container) {
            return new SDKProperty(id, value, flags, type, container);
        }

        public PropertyBag makePropertyBag() {
            return new SDKPropertyBag();
        }
    };

    public SDKPropertyBag() {
        super(s_factory);
    }

    public IProperty add(Object id, Object value, int flags) {
        return (IProperty)super.addItem(id, value, flags);
    }

    public IProperties addProperties(Object id) {
        return (IProperties)super.addPropertyBag(id, null).getValue();
    }

    public IProperty getProperty(Object id) {
        return (IProperty)super.getItem(id);
    }

    public IProperties getProperties(Object id) {
        return this.getProperties(id, false);
    }

    public IProperties getProperties(Object id, boolean createIfNotExist) {
        PropertyBag bag = super.getPropertyBag(id);
        if (bag == null && createIfNotExist) {
            bag = super.addPropertyBag(id, null).getPropertyBag();
        }
        return (IProperties)bag;
    }

    public boolean getBoolean(Object id) {
        try {
            return super.getBoolean(id);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    public Date getDate(Object id) {
        try {
            return super.getDate(id);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    public int getInt(Object id) {
        try {
            return super.getInt(id);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    public long getLong(Object id) {
        try {
            return super.getLong(id);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    public String getString(Object id) {
        try {
            return super.getString(id);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
    }

    public String getString(Locale locale) throws SDKException {
        try {
            return super.getString(locale);
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new SDKException.PropertyNotFound(e.getMessage());
        }
    }

    public void setString(Locale locale, String message) {
        super.setString(locale, message);
    }

    public IProperties copyAll() {
        return (IProperties)super.copy();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WireOb3Packer packer = new WireOb3Packer();
        String packedBag = packer.pack(this, 0, 0, false, 0, 0);
        out.writeObject(packedBag);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String packedBag = (String)in.readObject();
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(packedBag);
        this.merge(unpacker);
    }

    static class SDKProperty
    extends Property
    implements IProperty {
        public SDKProperty(Integer id, Object value, int flags, PropertyBag container) {
            super(id, value, flags, container);
        }

        public SDKProperty(Integer id, Object value, int flags, int type, PropertyBag container) {
            super(id, value, flags, type, container);
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int compareTo(Object o) {
            if (o instanceof SDKProperty) {
                SDKProperty other = (SDKProperty)o;
                if (this == other) {
                    return 0;
                }
                if (this.isContainer() || other.isContainer()) {
                    throw new ClassCastException();
                }
                if (this.getID().equals(other.getID())) {
                    Object value = this.getValue();
                    Object otherValue = other.getValue();
                    if (value == null) {
                        return otherValue == null ? 0 : -1;
                    }
                    if (otherValue == null) {
                        return 1;
                    }
                    if (value instanceof String && otherValue instanceof String) {
                        return ((String)value).compareToIgnoreCase((String)otherValue);
                    }
                    if (value instanceof Boolean && otherValue instanceof Boolean) {
                        return value.equals(otherValue) ? 0 : ((Boolean)value != false ? 1 : -1);
                    }
                    return ((Comparable)value).compareTo(otherValue);
                }
                throw new ClassCastException();
            }
            throw new ClassCastException("com.crystaldecisions.sdk.properties.internal.SDKPropertyBag$SDKProperty");
        }
    }
}

