/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.properties.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SDKPropertyBagHelper {
    private Integer m_keyID;
    private Map m_mapByKey;
    private PropertyArrayHelper m_bag;

    public SDKPropertyBagHelper(PropertyBag propBag, Integer keyID) {
        this(new PropertyArrayHelper(propBag, PropertyIDs.SI_TOTAL), keyID);
    }

    public SDKPropertyBagHelper(PropertyArrayHelper bag, Integer keyID) {
        this.m_bag = bag;
        this.m_keyID = keyID;
        this.m_mapByKey = new HashMap(bag.size());
        this.buildMap(0);
    }

    public int find(Object key) {
        return this.getIndex(key);
    }

    public Object get(Object key) {
        Integer index = (Integer)this.m_mapByKey.get(key);
        if (index != null) {
            return this.m_bag.get(index.intValue());
        }
        return null;
    }

    public void remove(int index) {
        PropertyBag bag = (PropertyBag)this.m_bag.remove(index);
        Property prop = bag.getItem((Object)this.m_keyID);
        this.m_mapByKey.remove(prop.getValue());
        this.buildMap(index);
    }

    public void remove(Object key) {
        Integer index = (Integer)this.m_mapByKey.remove(key);
        if (index != null) {
            this.m_bag.remove(index.intValue());
            this.buildMap(index);
        }
    }

    public PropertyBag add(Object key) {
        PropertyBag newBag = this.m_bag.add(null, 0x8000000).getPropertyBag();
        newBag.addItem((Object)this.m_keyID, key, 0);
        this.add();
        return newBag;
    }

    public void add() {
        this.updateMap(this.m_bag.size() - 1);
    }

    public int getIndex(Object key) {
        Integer index = (Integer)this.m_mapByKey.get(key);
        if (index != null) {
            return index;
        }
        return -1;
    }

    private void buildMap(int startFrom) {
        int size = this.m_bag.size();
        for (int i = startFrom; i < size; ++i) {
            this.updateMap(i);
        }
    }

    private void updateMap(int index) {
        PropertyBag bag = (PropertyBag)this.m_bag.get(index);
        Property prop = bag.getItem((Object)this.m_keyID);
        if (prop != null) {
            this.m_mapByKey.put(prop.getValue(), new Integer(index));
        }
    }

    public int size() {
        return this.m_bag.size();
    }

    public Iterator iterator() {
        return this.m_bag.iterator();
    }
}

