/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PagingQueryOptions
implements Externalizable {
    private int pageSize;
    private int optionVals;
    private boolean isIncremental;
    private boolean uriIsUnique;
    public static int INCLUDE_SECURITY = 4;
    public static int EXCLUDE_TEMP_STORAGE = 8;
    public static int SKIP_QUERY_URI_DECODE = 16;

    public PagingQueryOptions() {
        this.pageSize = 200;
        this.optionVals = 0;
        this.isIncremental = false;
        this.uriIsUnique = false;
    }

    public PagingQueryOptions(int pageSize) {
        this.pageSize = pageSize;
        this.optionVals = 0;
        this.isIncremental = false;
        this.uriIsUnique = false;
    }

    public PagingQueryOptions(int pageSize, int optionVals) {
        this.pageSize = pageSize;
        this.optionVals = optionVals;
        this.isIncremental = false;
        this.uriIsUnique = false;
    }

    public PagingQueryOptions(int pageSize, int optionVals, boolean isIncremental) {
        this.pageSize = pageSize;
        this.optionVals = optionVals;
        this.isIncremental = isIncremental;
        this.uriIsUnique = false;
    }

    public PagingQueryOptions(int pageSize, int optionVals, boolean isIncremental, boolean uriIsUnique) {
        this.pageSize = pageSize;
        this.optionVals = optionVals;
        this.isIncremental = isIncremental;
        this.uriIsUnique = uriIsUnique;
    }

    public void setUriIsUnique(boolean uriIsUnique) {
        this.uriIsUnique = uriIsUnique;
    }

    public boolean isUriIsUnique() {
        return this.uriIsUnique;
    }

    public void setIsIncremental(boolean isIncremental) {
        this.isIncremental = isIncremental;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isOptionSet(int option) {
        return (this.optionVals & option) > 0;
    }

    public void setOption(int option) {
        this.optionVals |= option;
    }

    public void removeOption(int option) {
        this.optionVals &= ~option;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.pageSize);
        out.writeInt(this.optionVals);
        out.writeBoolean(this.isIncremental);
        out.writeBoolean(this.uriIsUnique);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.pageSize = in.readInt();
        this.optionVals = in.readInt();
        this.isIncremental = in.readBoolean();
        this.uriIsUnique = in.readBoolean();
    }
}

