/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.uri.internal.Condition;
import com.crystaldecisions.sdk.uri.internal.PagingPredicate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class BoundPredicate {
    private List pagingPredicates = new LinkedList();
    private List commonConditions = new LinkedList();

    public void addCommonCondition(Condition c) {
        this.commonConditions.add(c);
    }

    public void addPagingPredicate(PagingPredicate p) {
        this.pagingPredicates.add(p);
    }

    public Iterator getCommonConditionsIterator() {
        return this.commonConditions.iterator();
    }

    public Iterator getPagingPredicatesIterator() {
        return this.pagingPredicates.iterator();
    }

    public boolean isEmpty() {
        return this.commonConditions.isEmpty() && this.pagingPredicates.isEmpty();
    }

    public boolean hasCommonConditions() {
        return !this.commonConditions.isEmpty();
    }

    public int numPagingPredicates() {
        return this.pagingPredicates.size();
    }

    public String toString() {
        boolean hasBoth;
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator ppIt = this.getPagingPredicatesIterator();
        Iterator ccIt = this.getCommonConditionsIterator();
        boolean bl = hasBoth = ppIt.hasNext() && ccIt.hasNext();
        while (ccIt.hasNext()) {
            Condition currCond = (Condition)ccIt.next();
            result.append(currCond);
            if (!ccIt.hasNext()) continue;
            result.append(" AND ");
        }
        if (hasBoth) {
            result.append(" AND ");
            if (this.pagingPredicates.size() > 1) {
                result.append('(');
            }
        }
        while (ppIt.hasNext()) {
            PagingPredicate currPred = (PagingPredicate)ppIt.next();
            if (this.pagingPredicates.size() > 1) {
                result.append('(');
            }
            result.append(currPred);
            if (this.pagingPredicates.size() > 1) {
                result.append(')');
            }
            if (!ppIt.hasNext()) continue;
            result.append(" OR ");
        }
        if (hasBoth && this.pagingPredicates.size() > 1) {
            result.append(')');
        }
        return result.toString();
    }
}

