/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import java.util.Iterator;
import java.util.List;

class Condition {
    private String property = "";
    private String operator = "";
    private String value = null;
    private List values = null;

    protected Condition() {
    }

    public Condition(String prop, String op, String val) {
        if (!this.isValidRelationalOperator(op)) {
            throw new SDKRuntimeException.Unexpected();
        }
        this.property = prop;
        this.operator = op;
        this.value = val;
    }

    public Condition(String prop, boolean isIn, List vals) {
        if (vals.isEmpty()) {
            throw new SDKRuntimeException.Unexpected();
        }
        this.property = prop;
        this.operator = isIn ? "IN" : "NOT IN";
        this.values = vals;
    }

    public Condition(String prop, boolean valIsNull) {
        this.property = prop;
        this.operator = valIsNull ? "IS" : "IS NOT";
        this.value = "NULL";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition cond = (Condition)o;
        if (cond != null && this.property.equalsIgnoreCase(cond.property) && this.operator.equalsIgnoreCase(cond.operator)) {
            boolean valEqual = false;
            boolean valsEqual = false;
            if (this.value == cond.value || this.value != null && cond.value != null && this.value.equalsIgnoreCase(cond.value)) {
                valEqual = true;
            }
            if (this.values == cond.values || this.values != null && cond.values != null && ((Object)this.values).equals(cond.values)) {
                valsEqual = true;
            }
            return valsEqual && valEqual;
        }
        return false;
    }

    private boolean isValidRelationalOperator(String op) {
        return op.equalsIgnoreCase("=") || op.equalsIgnoreCase(">") || op.equalsIgnoreCase(">=") || op.equalsIgnoreCase("<") || op.equalsIgnoreCase("<=");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.property);
        result.append(' ');
        result.append(this.operator);
        result.append(' ');
        if (this.operator.equalsIgnoreCase("IN") || this.operator.equalsIgnoreCase("NOT IN")) {
            result.append('(');
            Iterator valIt = this.values.iterator();
            while (valIt.hasNext()) {
                String currVal = (String)valIt.next();
                result.append('\'');
                result.append(currVal);
                result.append('\'');
                if (!valIt.hasNext()) continue;
                result.append(',');
            }
            result.append(')');
        } else {
            boolean isIs;
            boolean bl = isIs = this.operator.equalsIgnoreCase("IS") || this.operator.equalsIgnoreCase("IS NOT");
            if (!isIs) {
                result.append('\'');
            }
            result.append(this.value);
            if (!isIs) {
                result.append('\'');
            }
        }
        return result.toString();
    }

    public String getProperty() {
        return this.property;
    }

    public String getOperator() {
        return this.operator;
    }

    static interface Operators {
        public static final String LT = "<";
        public static final String LTE = "<=";
        public static final String GT = ">";
        public static final String GTE = ">=";
        public static final String EQ = "=";
        public static final String NOT_IN = "NOT IN";
        public static final String IN = "IN";
        public static final String IS = "IS";
        public static final String IS_NOT = "IS NOT";
    }

    static class TrueCondition
    extends Condition {
        public boolean equals(Object o) {
            return o instanceof TrueCondition;
        }

        public String toString() {
            return "";
        }
    }
}

