/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.uri.internal.AscendingOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.CustomOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.DescendingOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.OrderByEntry;
import java.util.Vector;

public class OrderByEntrySetFactory {
    public static Vector parseSQLOrderBy(String orderBy) throws URIParserException {
        Vector<OrderByEntry> entries = new Vector<OrderByEntry>();
        String[] tokens = orderBy.split("[\\s,]", -1);
        int numTokens = tokens.length;
        String propertyName = null;
        String customOrder = null;
        for (int i = 0; i < numTokens; ++i) {
            int endIndex;
            String curToken = tokens[i].trim();
            if (curToken.length() <= 0) continue;
            String curTokenUC = curToken.toUpperCase();
            if (curTokenUC.startsWith("ASC") && propertyName != null) {
                entries.add(new AscendingOrderByEntry(propertyName));
                propertyName = null;
            } else if (curTokenUC.startsWith("DESC") && propertyName != null) {
                entries.add(new DescendingOrderByEntry(propertyName));
                propertyName = null;
            } else if (curTokenUC.startsWith("CUSTOM")) {
                customOrder = "";
                int openIndex = curToken.indexOf(40);
                if (openIndex > 0) {
                    customOrder = customOrder + curToken.substring(openIndex + 1);
                }
            } else if (customOrder != null) {
                customOrder = customOrder + "," + curToken;
            } else {
                if (propertyName != null && customOrder == null) {
                    entries.add(new AscendingOrderByEntry(propertyName));
                }
                propertyName = curToken;
            }
            if (propertyName == null || customOrder == null || (endIndex = customOrder.indexOf(41)) <= 0) continue;
            entries.add(new CustomOrderByEntry(propertyName, customOrder.substring(0, endIndex)));
            propertyName = null;
            customOrder = null;
        }
        if (customOrder != null) {
            throw new URIParserException.InvalidSQLQuery(orderBy);
        }
        if (propertyName != null) {
            entries.add(new AscendingOrderByEntry(propertyName));
        }
        return entries;
    }
}

