/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreUtil;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.uri.internal.AscendingOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.BoundPredicate;
import com.crystaldecisions.sdk.uri.internal.Condition;
import com.crystaldecisions.sdk.uri.internal.Conditions;
import com.crystaldecisions.sdk.uri.internal.CustomOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.DescendingOrderByEntry;
import com.crystaldecisions.sdk.uri.internal.OrderByEntry;
import com.crystaldecisions.sdk.uri.internal.PagingPredicate;
import com.crystaldecisions.sdk.uri.internal.SQLQueryHolder;
import com.crystaldecisions.sdk.uri.internal.StringHelper;
import com.crystaldecisions.sdk.uri.internal.URIParameterHelper;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

class PageBlock {
    private static final ILogger LOG = LoggerManager.getLogger((String)SQLQueryHolder.class.getName());
    private int lowerObjID;
    private int upperObjID;
    private String[] lowerValues;
    private String[] upperValues;
    private Vector entries;

    private PageBlock(int lowerObjID, String[] lowerValues, int upperObjID, String[] upperValues, Vector entries) {
        this.lowerObjID = lowerObjID;
        this.upperObjID = upperObjID;
        this.lowerValues = lowerValues;
        this.upperValues = upperValues;
        this.entries = entries;
    }

    private PageBlock(int lowerObjID, String[] lowerValues, Vector entries) {
        this(lowerObjID, lowerValues, -1, null, entries);
    }

    public String getURIPagingParameters() {
        try {
            return this.generateURIPagingParams().toString();
        }
        catch (Exception e) {
            System.out.println("invalid parameters - throw proper exception");
            return null;
        }
    }

    public String getWhereClause(boolean lowerBoundObjInclusive) throws URIParserException {
        int numParams = this.entries.size();
        if (numParams <= 0) {
            throw new URIParserException.InvalidSQLQuery("No Order By Entries! Must have a tie breaker - usually use SI_ID.");
        }
        return this.generatePagingClause(this.lowerValues, this.upperValues, this.entries, lowerBoundObjInclusive).toString();
    }

    private StringBuffer generatePagingClause(String[] lowerValues, String[] upperValues, Vector entries, boolean lowerBoundObjInclusive) throws URIParserException {
        if (lowerValues == null || entries == null || lowerValues.length != entries.size()) {
            LOG.error((Object)"Inconsistent parameters passed into PageBlock.generatePagingWhereClause(...)");
            throw new URIParserException.PagingFailed("Inconsistent paramaters.  Make sure the URI boundary values are correct");
        }
        int numParams = entries.size();
        BoundPredicate LBPredicate = new BoundPredicate();
        BoundPredicate UBPredicate = new BoundPredicate();
        try {
            for (int i = 0; i < numParams; ++i) {
                boolean isLastEntry;
                PagingPredicate tempLBPred = null;
                PagingPredicate tempUBPred = null;
                OrderByEntry curEntry = (OrderByEntry)entries.get(i);
                Conditions LBConditions = curEntry.getLowerBoundClause(this.lowerObjID, lowerValues[i], isLastEntry = i == numParams - 1, lowerBoundObjInclusive);
                if (LBConditions != null) {
                    tempLBPred = new PagingPredicate(LBConditions);
                }
                Conditions UBConditions = null;
                if (upperValues != null && LBConditions != null && ((UBConditions = curEntry.getUpperBoundClause(this.upperObjID, upperValues[i], isLastEntry)) == null || lowerValues[i].equals(upperValues[i]))) {
                    UBConditions = null;
                    LBConditions = null;
                    tempLBPred = null;
                }
                if (UBConditions != null) {
                    tempUBPred = new PagingPredicate(UBConditions);
                }
                for (int j = 0; j < i; ++j) {
                    Conditions eqConditions;
                    OrderByEntry tempEntry = (OrderByEntry)entries.get(j);
                    if (tempLBPred != null) {
                        eqConditions = tempEntry.getEqualsClause(lowerValues[j]);
                        tempLBPred.addPredefinedConditions(eqConditions);
                    }
                    if (tempUBPred == null) continue;
                    eqConditions = tempEntry.getEqualsClause(upperValues[j]);
                    tempUBPred.addPredefinedConditions(eqConditions);
                }
                if (tempLBPred != null) {
                    LBPredicate.addPagingPredicate(tempLBPred);
                }
                if (tempUBPred == null) continue;
                UBPredicate.addPagingPredicate(tempUBPred);
            }
            PagingPredicate.optimizeConditions(LBPredicate, UBPredicate);
        }
        catch (NullPointerException npe) {
            LOG.error((Object)"Error forming paged query.", (Throwable)npe);
            throw new URIParserException.PagingFailed(npe);
        }
        StringBuffer result = PageBlock.flattenPagingClause(LBPredicate, UBPredicate, lowerValues, upperValues, entries);
        return result;
    }

    private StringBuffer generateURIPagingParams() {
        StringBuffer URIResult = new StringBuffer("");
        for (int i = 0; i < this.entries.size(); ++i) {
            OrderByEntry curEntry = (OrderByEntry)this.entries.get(i);
            String entryIndex = String.valueOf(i + 1);
            if (i > 0) {
                URIResult.append("&");
            }
            URIResult.append("BIP" + entryIndex + "=" + curEntry.getPropertyName());
            URIResult.append("&From" + entryIndex + "=" + StringHelper.escapeURI(this.lowerValues[i], "\\"));
            if (this.upperValues != null) {
                URIResult.append("&To" + entryIndex + "=" + StringHelper.escapeURI(this.upperValues[i], "\\"));
            }
            if (curEntry instanceof CustomOrderByEntry) {
                URIResult.append("&Asc" + entryIndex + "=custom");
                URIResult.append(this.generateURICustomBoundValues(((CustomOrderByEntry)curEntry).boundaryValues, String.valueOf(i + 1)));
                if (i == this.entries.size() - 1 && this.lowerObjID > -1) {
                    URIResult.append("&CustomLowerObjID");
                    URIResult.append(entryIndex);
                    URIResult.append('=');
                    URIResult.append(this.lowerObjID);
                }
                if (i != this.entries.size() - 1 || this.upperObjID <= -1) continue;
                URIResult.append("&CustomUpperObjID");
                URIResult.append(entryIndex);
                URIResult.append('=');
                URIResult.append(this.upperObjID);
                continue;
            }
            if (curEntry instanceof AscendingOrderByEntry) {
                URIResult.append("&Asc" + entryIndex + "=true");
                continue;
            }
            if (!(curEntry instanceof DescendingOrderByEntry)) continue;
            URIResult.append("&Asc" + entryIndex + "=false");
        }
        return URIResult;
    }

    private String generateURICustomBoundValues(String[] values, String prepend) {
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            retVal.append("&CustomBoundValue" + prepend + "_" + String.valueOf(i + 1) + "=" + StringHelper.escapeURI(values[i], "\\"));
        }
        return retVal.toString();
    }

    public static PageBlock buildPageBlock(IInfoObjects objs, int lowerBound, int upperBound, Vector entries, int entryIndex) {
        return PageBlock.buildPageBlock((IInfoObject)objs.get(lowerBound), (IInfoObject)objs.get(upperBound), entries, entryIndex);
    }

    public static PageBlock buildPageBlock(IInfoObject lowerObj, IInfoObject upperObj, Vector entries, int entryIndex) {
        int numEntries = entries.size();
        Vector<OrderByEntry> nextBlockEntries = null;
        nextBlockEntries = new Vector<OrderByEntry>();
        OrderByEntry curEntry = (OrderByEntry)entries.get(entryIndex++);
        String[] lowerValues = PageBlock.buildValues(lowerObj, entries, 0);
        String[] upperValues = PageBlock.buildValues(upperObj, entries, 0);
        nextBlockEntries.add(curEntry);
        while (entryIndex < numEntries) {
            nextBlockEntries.add((OrderByEntry)entries.get(entryIndex++));
        }
        return new PageBlock(lowerObj.getID(), lowerValues, upperObj.getID(), upperValues, nextBlockEntries);
    }

    public static PageBlock buildPageBlockEx(IInfoObject lowerObj, IInfoObject upperObj, Vector entries, int entryIndex) {
        int numEntries = entries.size();
        Vector<OrderByEntry> nextBlockEntries = null;
        nextBlockEntries = new Vector<OrderByEntry>();
        OrderByEntry curEntry = (OrderByEntry)entries.get(entryIndex++);
        String[] lowerValues = PageBlock.buildValues(lowerObj, entries, 0);
        String[] upperValues = null;
        if (upperObj != null) {
            upperValues = PageBlock.buildValues(upperObj, entries, 0);
        }
        nextBlockEntries.add(curEntry);
        while (entryIndex < numEntries) {
            nextBlockEntries.add((OrderByEntry)entries.get(entryIndex++));
        }
        if (upperValues == null) {
            return new PageBlock(lowerObj.getID(), lowerValues, nextBlockEntries);
        }
        return new PageBlock(lowerObj.getID(), lowerValues, upperObj.getID(), upperValues, nextBlockEntries);
    }

    static String[] buildBoundValues(IInfoObject boundObj, Vector entries) {
        return PageBlock.buildValues(boundObj, entries, 0);
    }

    private static String[] buildValues(IInfoObject obj, Vector entries, int entryIndex) {
        int numEntries = entries.size();
        String[] retVal = new String[numEntries - entryIndex];
        for (int i = entryIndex; i < numEntries; ++i) {
            retVal[i - entryIndex] = PageBlock.getValue(obj, ((OrderByEntry)entries.get(i)).getPropertyName());
            if (retVal[i - entryIndex].indexOf("'") < 0) continue;
            retVal[i - entryIndex] = retVal[i - entryIndex].replaceAll("'", "''");
        }
        return retVal;
    }

    private static CustomOrderByEntry parseCustomBoundEntry(URIParameterHelper paramList, int paramIndex, String customValue) {
        String nextCustomBoundKey;
        int nextCustomIndex = 1;
        Vector<String> boundaryValues = new Vector<String>();
        while (paramList.containsKey(nextCustomBoundKey = "CustomBoundValue" + String.valueOf(paramIndex) + "_" + String.valueOf(nextCustomIndex))) {
            boundaryValues.add(StringHelper.decodeURI((String)paramList.getParameter(nextCustomBoundKey)));
            ++nextCustomIndex;
        }
        String[] customBoundArray = new String[nextCustomIndex - 1];
        for (int i = 0; i < nextCustomIndex - 1; ++i) {
            customBoundArray[i] = (String)boundaryValues.get(i);
        }
        return new CustomOrderByEntry(customValue, customBoundArray);
    }

    protected static PageBlock buildPageBlock(URIParameterHelper paramList) throws URIParserException {
        String orderByKey;
        String firstParamKey = "BIP1";
        int lowerObjID = -1;
        int upperObjID = -1;
        if (!paramList.containsKey(firstParamKey)) {
            return null;
        }
        Vector<String> lowerValues = new Vector<String>();
        Vector<String> upperValues = new Vector<String>();
        Vector<OrderByEntry> newEntries = new Vector<OrderByEntry>();
        int paramIndex = 1;
        boolean ischeckUpperValue = false;
        while (paramList.containsKey(orderByKey = "BIP" + String.valueOf(paramIndex))) {
            String orderBy = (String)paramList.getParameter(orderByKey);
            String ascKey = "Asc" + String.valueOf(paramIndex);
            String isAsc = (String)paramList.getParameter(ascKey);
            if (isAsc != null && isAsc.length() > 0) {
                if (isAsc.equalsIgnoreCase("custom")) {
                    String upperObjIDStr;
                    newEntries.add(PageBlock.parseCustomBoundEntry(paramList, paramIndex, orderBy));
                    String lowerObjIDStr = (String)paramList.getParameter("CustomLowerObjID" + String.valueOf(paramIndex));
                    if (lowerObjIDStr != null) {
                        lowerObjID = Integer.parseInt(lowerObjIDStr);
                    }
                    if ((upperObjIDStr = (String)paramList.getParameter("CustomUpperObjID" + String.valueOf(paramIndex))) != null) {
                        upperObjID = Integer.parseInt(upperObjIDStr);
                    }
                } else if (!isAsc.equalsIgnoreCase("false")) {
                    newEntries.add(new AscendingOrderByEntry(orderBy));
                } else {
                    newEntries.add(new DescendingOrderByEntry(orderBy));
                }
            } else {
                newEntries.add(new AscendingOrderByEntry(orderBy));
            }
            String fromKey = "From" + paramIndex;
            String fromIndex = (String)paramList.getParameter(fromKey);
            String toKey = "To" + paramIndex;
            String toIndex = (String)paramList.getParameter(toKey);
            if (fromIndex != null && !fromIndex.equals("NULL")) {
                lowerValues.add(StringHelper.decodeURI(fromIndex));
            } else {
                lowerValues.add("NULL");
            }
            if (toIndex != null) {
                ischeckUpperValue = true;
                if (!toIndex.equals("NULL")) {
                    upperValues.add(StringHelper.decodeURI(toIndex));
                } else {
                    upperValues.add("NULL");
                }
            }
            ++paramIndex;
        }
        int numValues = lowerValues.size();
        if (ischeckUpperValue && upperValues != null && numValues != upperValues.size()) {
            LOG.error((Object)"The number of upper values was not equal to the number of lower values for the given page.");
            throw new URIParserException.PagingFailed("Inconsistent upper/lower parameter values");
        }
        String[] lowerValuesArray = new String[numValues];
        String[] upperValuesArray = null;
        if (upperValues.size() > 0) {
            upperValuesArray = new String[numValues];
        }
        for (int i = 0; i < numValues; ++i) {
            lowerValuesArray[i] = (String)lowerValues.get(i);
            if (upperValues.size() <= 0) continue;
            upperValuesArray[i] = (String)upperValues.get(i);
        }
        return new PageBlock(lowerObjID, lowerValuesArray, upperObjID, upperValuesArray, newEntries);
    }

    private static String getValue(IInfoObject boundary, String property2) {
        String SCHEDULE_INFO_PROPERTY = PropertyIDs.idToName(PropertyIDs.SI_SCHEDULEINFO);
        String PROCESS_INFO_PROPERTY = PropertyIDs.idToName(PropertyIDs.SI_PROCESSINFO);
        String delim = ".";
        Object value = null;
        String strValue = null;
        try {
            int delimIndex = property2.indexOf(".");
            if (delimIndex > 0 && delimIndex < property2.length() - 1) {
                String subPropertyName;
                String bagName = property2.substring(0, delimIndex);
                IProperties props = null;
                if (bagName.equalsIgnoreCase(SCHEDULE_INFO_PROPERTY)) {
                    props = boundary.getSchedulingInfo().properties();
                    subPropertyName = property2.substring(delimIndex + 1);
                } else if (bagName.equalsIgnoreCase(PROCESS_INFO_PROPERTY)) {
                    props = boundary.getProcessingInfo().properties();
                    subPropertyName = property2.substring(delimIndex + 1);
                } else {
                    props = boundary.properties();
                    subPropertyName = property2;
                }
                value = PageBlock.getValueHelper(props, subPropertyName);
            } else {
                value = boundary.properties().getProperty(property2).getValue();
            }
            if (value instanceof Boolean) {
                strValue = ((Boolean)value).booleanValue() ? "1" : "0";
            } else if (value instanceof Date) {
                Date curDate = (Date)value;
                strValue = InfoStoreUtil.convertToQueryString(curDate, TimeZone.getTimeZone("GMT"));
            } else {
                strValue = value.toString();
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (strValue == null) {
            strValue = "NULL";
        }
        return strValue;
    }

    private static Object getValueHelper(IProperties props, String name) {
        Object value = null;
        String delim = ".";
        int delimIndex = name.indexOf(".");
        if (delimIndex > 0 && delimIndex < name.length() - 1) {
            String bagName = name.substring(0, delimIndex);
            String subPropertyName = name.substring(delimIndex + 1);
            IProperties props2 = props.getProperties(bagName);
            value = PageBlock.getValueHelper(props2, subPropertyName);
        } else {
            value = props.getProperty(name).getValue();
        }
        return value;
    }

    private static StringBuffer flattenPagingClause(BoundPredicate lowerBound, BoundPredicate upperBound, String[] lowerValues, String[] upperValues, Vector entries) {
        boolean parenthesizePagingPredicates;
        StringBuffer result = new StringBuffer();
        if (upperBound.isEmpty() || lowerBound.isEmpty()) {
            return PageBlock.writePagingClause(lowerBound, upperBound);
        }
        Iterator lowerPPIt = lowerBound.getPagingPredicatesIterator();
        Iterator upperPPIt = upperBound.getPagingPredicatesIterator();
        if (!lowerPPIt.hasNext() || !upperPPIt.hasNext()) {
            return PageBlock.writePagingClause(lowerBound, upperBound);
        }
        PagingPredicate firstLowerPred = (PagingPredicate)lowerPPIt.next();
        PagingPredicate firstUpperPred = (PagingPredicate)upperPPIt.next();
        if (!firstUpperPred.getDefiningProperty().equalsIgnoreCase(firstLowerPred.getDefiningProperty()) || firstUpperPred.hasPredefinedConditions() || firstLowerPred.hasPredefinedConditions()) {
            return PageBlock.writePagingClause(lowerBound, upperBound);
        }
        Iterator ccIt = lowerBound.getCommonConditionsIterator();
        while (ccIt.hasNext()) {
            result.append((Condition)ccIt.next());
            result.append(" AND ");
        }
        boolean bl = parenthesizePagingPredicates = lowerBound.hasCommonConditions() && lowerBound.numPagingPredicates() > 1;
        if (parenthesizePagingPredicates) {
            result.append('(');
        }
        List subRange = null;
        if (firstLowerPred.isDefinedOnCustomOrderByEntry()) {
            for (int i = 0; i < entries.size(); ++i) {
                OrderByEntry entry = (OrderByEntry)entries.get(i);
                if (!firstLowerPred.getDefiningProperty().equalsIgnoreCase(entry.getPropertyName()) || i >= entries.size() - 1) continue;
                CustomOrderByEntry customEntry = (CustomOrderByEntry)entries.get(i);
                String lowerValue = lowerValues[i];
                String upperValue = upperValues[i];
                subRange = customEntry.getSubRangeString(lowerValue, upperValue);
                break;
            }
        }
        if (subRange != null) {
            if (!subRange.isEmpty()) {
                Condition cond = new Condition(firstLowerPred.getDefiningProperty(), true, subRange);
                result.append(cond);
                if (lowerPPIt.hasNext() || upperPPIt.hasNext()) {
                    result.append(" OR ");
                }
            }
        } else {
            boolean needUpperParenthesis;
            boolean needLowerParenthesis = firstLowerPred.getDefiningConditions().size() > 1 && !firstLowerPred.getDefiningConditions().isConjunction();
            boolean bl2 = needUpperParenthesis = firstUpperPred.getDefiningConditions().size() > 1 && !firstUpperPred.getDefiningConditions().isConjunction();
            if (needLowerParenthesis) {
                result.append('(');
            }
            result.append(firstLowerPred.getDefiningConditions());
            if (needLowerParenthesis) {
                result.append(')');
            }
            result.append(" AND ");
            if (needUpperParenthesis) {
                result.append('(');
            }
            result.append(firstUpperPred.getDefiningConditions());
            if (needUpperParenthesis) {
                result.append(')');
            }
            if (lowerPPIt.hasNext() || upperPPIt.hasNext()) {
                result.append(" OR ");
            }
        }
        while (lowerPPIt.hasNext()) {
            result.append(lowerPPIt.next());
            if (!lowerPPIt.hasNext() && !upperPPIt.hasNext()) continue;
            result.append(" OR ");
        }
        while (upperPPIt.hasNext()) {
            result.append(upperPPIt.next());
            if (!upperPPIt.hasNext()) continue;
            result.append(" OR ");
        }
        if (parenthesizePagingPredicates) {
            result.append(')');
        }
        return result;
    }

    private static StringBuffer writePagingClause(BoundPredicate lowerBound, BoundPredicate upperBound) {
        boolean bothBoundsExist;
        StringBuffer result = new StringBuffer();
        boolean bl = bothBoundsExist = !lowerBound.isEmpty() && !upperBound.isEmpty();
        if (bothBoundsExist && !lowerBound.hasCommonConditions()) {
            result.append('(');
        }
        result.append(lowerBound);
        if (bothBoundsExist) {
            if (!lowerBound.hasCommonConditions()) {
                result.append(')');
            }
            result.append(" AND ");
            if (!upperBound.hasCommonConditions()) {
                result.append('(');
            }
        }
        result.append(upperBound);
        if (bothBoundsExist && !upperBound.hasCommonConditions()) {
            result.append(')');
        }
        return result;
    }
}

