/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.uri.PagingQueryOptions;
import com.crystaldecisions.sdk.uri.internal.OrderByEntry;
import com.crystaldecisions.sdk.uri.internal.OrderByEntrySetFactory;
import com.crystaldecisions.sdk.uri.internal.PageBlock;
import com.crystaldecisions.sdk.uri.internal.URIParameterHelper;
import com.crystaldecisions.sdk.uri.internal.URIQueryParser;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class SQLQueryHolder
implements Serializable {
    static final long serialVersionUID = -5114422067784994150L;
    private static final ILogger LOG = LoggerManager.getLogger((String)SQLQueryHolder.class.getName());
    private int topN = -1;
    private int everyN = -1;
    private String selectClause = "";
    private String fromClause = "";
    private String whereClause = "";
    private String pagingWhereClause = "";
    private String orderByClause = "";
    private Vector entries = null;
    private boolean pagingNeeded = false;
    private int pagesize = -1;
    private static final String excludeWhereClause = "NOT SI_PARENTID IN (49)";

    protected SQLQueryHolder() {
    }

    protected SQLQueryHolder(String select, String from, String where, String pagingWhere, String orderBy, PagingQueryOptions opt) throws URIParserException {
        this();
        this.setSelect(select);
        this.setFrom(from);
        this.setWhere(where);
        this.setPagingWhere(pagingWhere);
        this.setOrderBy(orderBy, opt);
        if (pagingWhere == null || pagingWhere.length() <= 0) {
            this.setPagingNeeded(true);
        }
        this.pagesize = -1;
    }

    protected SQLQueryHolder(String select, String from, String where, String pagingWhere, String orderBy, int pagesize, PagingQueryOptions option) throws URIParserException {
        this();
        this.setSelect(select);
        this.setFrom(from);
        this.setWhere(where);
        this.setPagingWhere(pagingWhere);
        this.setOrderBy(orderBy, option);
        this.pagesize = pagesize;
        if (pagingWhere == null || pagingWhere.length() <= 0) {
            this.setPagingNeeded(true);
        }
    }

    public int getPageSize() {
        return this.pagesize;
    }

    private void setSelect(String select) throws URIParserException {
        int everyIndex;
        if (select == null || select.length() == 0) {
            select = URIQueryParser.DEFAULT_SELECT_LIST;
        }
        String selectUC = select.toUpperCase();
        int index1 = select.indexOf("*");
        int index2 = selectUC.indexOf("SI_CUID");
        if (index1 < 0 && index2 < 0) {
            select = select + ",SI_CUID";
        }
        int index3 = selectUC.indexOf("SI_PARENT_CUID");
        if (index1 < 0 && index3 < 0) {
            select = select + ",SI_PARENT_CUID";
        }
        boolean hasTop = true;
        int topIndex = selectUC.indexOf("TOP ");
        if (topIndex >= 0) {
            String temp1 = selectUC.substring(topIndex + 4);
            temp1.trim();
            int tempIndex1 = temp1.indexOf(" ");
            int tempIndex2 = temp1.indexOf(",");
            if (tempIndex2 >= 0 && tempIndex1 > 0 && tempIndex1 >= tempIndex2) {
                hasTop = false;
            }
        }
        if (hasTop && topIndex >= 0) {
            String afterTop = select.substring(topIndex + "TOP".length()).trim();
            int endTopIndex = afterTop.indexOf(32);
            if (endTopIndex < 0) {
                LOG.error((Object)"Invalid SQL statement.  Must be of the form: TOP XXX YYY where XXX is a positive integer and YYY is a valid property list.");
                throw new URIParserException.InvalidSQLQuery(select);
            }
            String topValue = afterTop.substring(0, endTopIndex);
            try {
                this.topN = Integer.parseInt(topValue);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)"Invalid SQL statement.  Must be of the form: TOP XXX YYY where XXX is a positive integer and YYY is a valid property list.");
                throw new URIParserException.InvalidSQLQuery(select);
            }
            String remainingSelect = "";
            if (topIndex > 0) {
                remainingSelect = select.substring(0, topIndex);
            }
            select = remainingSelect = remainingSelect + afterTop.substring(endTopIndex).trim();
        }
        if ((everyIndex = selectUC.indexOf("EVERY")) >= 0) {
            String afterEvery = select.substring(everyIndex + "EVERY".length()).trim();
            int endEveryIndex = afterEvery.indexOf(32);
            if (endEveryIndex < 0) {
                LOG.error((Object)"Invalid SQL statement.  Must be of the form: EVERY XXX YYY where XXX is a positive integer and YYY is a valid property list.");
                throw new URIParserException.InvalidSQLQuery(select);
            }
            String everyValue = afterEvery.substring(0, endEveryIndex);
            try {
                this.everyN = Integer.parseInt(everyValue);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)"Invalid SQL statement.  Must be of the form: EVERY XXX YYY where XXX is a positive integer and YYY is a valid property list.");
                throw new URIParserException.InvalidSQLQuery(select);
            }
            String remainingSelect = "";
            if (everyIndex > 0) {
                remainingSelect = select.substring(0, everyIndex);
            }
            select = remainingSelect = remainingSelect + afterEvery.substring(endEveryIndex);
        }
        this.selectClause = select;
    }

    private void setFrom(String fromClause) {
        this.fromClause = fromClause;
    }

    private void setWhere(String whereClause) {
        this.whereClause = whereClause;
    }

    public void dropTempStorageObjects() {
        String whereClause = this.getWhere();
        this.whereClause = whereClause == null || whereClause.length() == 0 ? excludeWhereClause : "(" + whereClause + " AND " + excludeWhereClause + ")";
    }

    private void setPagingWhere(String pagingWhereClause) {
        this.pagingWhereClause = pagingWhereClause;
    }

    private void setOrderBy(String orderByClause, PagingQueryOptions opt) throws URIParserException {
        int index;
        if ((orderByClause = orderByClause.trim()) == null || orderByClause.length() == 0) {
            orderByClause = "SI_ID";
        } else if ((opt == null || opt != null && !opt.isUriIsUnique()) && (index = orderByClause.indexOf("SI_ID")) < 0) {
            orderByClause = orderByClause + ", SI_ID";
        }
        this.orderByClause = orderByClause;
        this.entries = OrderByEntrySetFactory.parseSQLOrderBy(orderByClause);
    }

    private void setPagingNeeded(boolean pagingNeeded) {
        this.pagingNeeded = pagingNeeded;
    }

    public static boolean isValidForPaging(Vector entries) {
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String propName = ((OrderByEntry)it.next()).getPropertyName().toUpperCase();
            if (URIQueryParser.INDEXED_PROPERTIES.contains(propName)) continue;
            return false;
        }
        return true;
    }

    public String getFullSelect() {
        String retVal = "";
        if (this.topN > 0) {
            retVal = retVal + "TOP " + String.valueOf(this.topN) + " ";
        }
        if (this.everyN > 0) {
            retVal = retVal + "EVERY " + String.valueOf(this.everyN) + " ";
        }
        retVal = retVal + this.selectClause;
        return retVal;
    }

    public String getSelect() {
        return this.selectClause;
    }

    public String getFrom() {
        return this.fromClause;
    }

    public String getSimpleWhere() {
        return this.whereClause;
    }

    public String getWhere() {
        boolean hasBothWheres;
        if (!(this.pagingWhereClause != null && this.pagingWhereClause.length() != 0 || this.whereClause != null && this.whereClause.length() != 0)) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean hasPagingWhere = this.pagingWhereClause != null && this.pagingWhereClause.length() > 0;
        boolean hasWhere = this.whereClause != null && this.whereClause.length() > 0;
        boolean bl = hasBothWheres = hasWhere && hasPagingWhere;
        if (hasBothWheres) {
            result.append("(");
        }
        if (hasWhere) {
            result.append(this.whereClause);
        }
        if (hasBothWheres) {
            result.append(") AND (");
        }
        if (hasPagingWhere) {
            result.append(this.pagingWhereClause);
        }
        if (hasBothWheres) {
            result.append(")");
        }
        return result.toString();
    }

    public String getOrderBy() {
        return this.orderByClause;
    }

    public Vector getOrderByEntries() {
        return this.entries;
    }

    public boolean isPagingNeeded() {
        return this.pagingNeeded;
    }

    public boolean isValid() {
        return this.fromClause != null && this.fromClause.length() != 0;
    }

    public void addSecurityFields() throws URIParserException {
        String select = this.getSelect();
        String selectUC = select.toUpperCase();
        if (select.indexOf(42) >= 0) {
            return;
        }
        if (selectUC.indexOf("SI_FLAGS") < 0) {
            select = select + ",SI_FLAGS";
        }
        this.setSelect(select);
    }

    public String getSimpleQuery() throws URIParserException {
        String query = "SELECT " + this.getFullSelect() + " FROM " + this.fromClause;
        if (this.whereClause != null && this.whereClause.length() > 0) {
            query = query + " WHERE " + this.whereClause;
        }
        query = query + " ORDER BY " + this.getOrderBy();
        if (!this.isValid()) {
            throw new URIParserException.InvalidSQLQuery(query);
        }
        return query;
    }

    public String getFullQueryTopLimit(int topLimit) throws URIParserException {
        int tempTopN = this.topN;
        if (this.topN < 0 || this.topN > topLimit) {
            tempTopN = topLimit;
        }
        String query = "SELECT TOP " + String.valueOf(tempTopN) + " ";
        if (this.everyN >= 0) {
            query = query + "EVERY " + String.valueOf(this.everyN) + " ";
        }
        query = query + this.getSelect();
        query = query + " FROM " + this.fromClause;
        String fullWhere = this.getWhere();
        if (fullWhere != null && fullWhere.length() > 0) {
            query = query + " WHERE " + fullWhere;
        }
        query = query + " ORDER BY " + this.getOrderBy();
        if (!this.isValid()) {
            throw new URIParserException.InvalidSQLQuery(query);
        }
        return query;
    }

    public String getFullQuery() throws URIParserException {
        String query = "SELECT " + this.getFullSelect() + " FROM " + this.fromClause;
        String fullWhere = this.getWhere();
        if (fullWhere != null && fullWhere.length() > 0) {
            query = query + " WHERE " + fullWhere;
        }
        query = query + " ORDER BY " + this.getOrderBy();
        if (!this.isValid()) {
            throw new URIParserException.InvalidSQLQuery(query);
        }
        return query;
    }

    public String getIndexQuery(int pagesizeForEvery, int rangesize) throws URIParserException {
        return this.getIndexQuery(null, pagesizeForEvery, rangesize);
    }

    public String getIndexQuery(IInfoObject lowerObj, int pagesizeForEvery, int rangesize) throws URIParserException {
        PageBlock indexPageBlock;
        String pagingWhere;
        boolean hasWhere;
        if (!this.isValid()) {
            throw new URIParserException.InvalidSQLQuery(this.getSimpleQuery());
        }
        String indexSelect = this.generateIndexSelect(pagesizeForEvery, rangesize);
        String indexQuery = "SELECT " + indexSelect + " " + "FROM " + this.fromClause;
        boolean bl = hasWhere = this.whereClause != null && this.whereClause.length() > 0;
        if (hasWhere) {
            indexQuery = indexQuery + " WHERE (" + this.whereClause + ")";
        }
        if (lowerObj != null && this.entries != null && this.entries.size() > 0 && (pagingWhere = (indexPageBlock = PageBlock.buildPageBlockEx(lowerObj, null, this.entries, 0)).getWhereClause(pagesizeForEvery <= 0)) != null && pagingWhere.length() > 0) {
            indexQuery = hasWhere ? indexQuery + " AND (" : indexQuery + " WHERE ";
            indexQuery = indexQuery + pagingWhere;
            if (hasWhere) {
                indexQuery = indexQuery + ")";
            }
        }
        indexQuery = indexQuery + " ORDER BY " + this.orderByClause;
        return indexQuery;
    }

    public int getTopN() {
        return this.topN;
    }

    public int getEveryN() {
        return this.everyN;
    }

    private String generateIndexSelect(int pagesize, int rangesize) {
        Iterator entryIterator = this.entries.iterator();
        String indexSelect = "";
        while (entryIterator.hasNext()) {
            String baseName = this.getBaseName(((OrderByEntry)entryIterator.next()).getPropertyName());
            if (baseName != null) {
                indexSelect = indexSelect + baseName;
            }
            if (!entryIterator.hasNext() || indexSelect.endsWith(",")) continue;
            indexSelect = indexSelect + ",";
        }
        if (indexSelect.endsWith(",")) {
            indexSelect = indexSelect.substring(0, indexSelect.length() - 1);
        }
        String retVal = "";
        if (this.topN >= 0) {
            retVal = retVal + "TOP " + String.valueOf(this.topN) + " ";
        } else if (pagesize > 1) {
            retVal = retVal + "TOP " + String.valueOf(pagesize * rangesize) + " ";
        }
        if (this.everyN >= 0) {
            retVal = retVal + "EVERY " + String.valueOf(this.everyN) + " ";
        } else if (pagesize > 0) {
            retVal = retVal + "EVERY " + String.valueOf(pagesize) + " ";
        }
        retVal = retVal + indexSelect;
        return retVal;
    }

    public String getPagedQuery(IInfoObjects objs, int lowBound, int upBound) throws URIParserException {
        if (!this.isValid()) {
            throw new URIParserException.InvalidSQLQuery(this.getSimpleQuery());
        }
        boolean noPagingWhere = false;
        PageBlock topLevel = PageBlock.buildPageBlock(objs, lowBound, upBound, this.entries, 0);
        this.pagingWhereClause = topLevel.getWhereClause(true);
        if (this.pagingWhereClause == null || this.pagingWhereClause.length() == 0) {
            noPagingWhere = true;
        }
        String query = "SELECT " + this.getFullSelect() + " FROM " + this.fromClause;
        if (noPagingWhere && this.whereClause == null) {
            return null;
        }
        query = !noPagingWhere && this.whereClause != null ? query + " WHERE (" + this.whereClause + ") AND (" + this.pagingWhereClause + ")" : (!noPagingWhere ? query + " WHERE " + this.pagingWhereClause : query + " WHERE " + this.whereClause);
        query = query + " ORDER BY " + this.orderByClause;
        return query;
    }

    public void updatePaging(String uri) throws URIParserException {
        this.pagingWhereClause = SQLQueryHolder.parsePagingParameters(uri);
        if (this.pagingWhereClause == null) {
            throw new URIParserException.InvalidURI(uri);
        }
        this.pagingNeeded = this.pagingWhereClause.length() == 0;
    }

    public static String parsePagingParameters(String uri) throws URIParserException {
        int beginPR = uri.indexOf(63);
        if (beginPR < 0) {
            return null;
        }
        URIParameterHelper paramList = new URIParameterHelper(uri);
        return SQLQueryHolder.parsePagingParameters(paramList);
    }

    public static String parsePagingParameters(URIParameterHelper paramList) throws URIParserException {
        try {
            return PageBlock.buildPageBlock(paramList).getWhereClause(true);
        }
        catch (Exception e) {
            System.out.println("invalid URI? throw proper exception");
            return null;
        }
    }

    private String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        String SCHEDULE_INFO_PROPERTY = PropertyIDs.idToName(PropertyIDs.SI_SCHEDULEINFO);
        String PROCESS_INFO_PROPERTY = PropertyIDs.idToName(PropertyIDs.SI_PROCESSINFO);
        String delim = ".";
        int delimIndex = name.indexOf(".");
        if (delimIndex > 0 && delimIndex < name.length() - 1) {
            String bagName = name.substring(0, delimIndex);
            if (bagName.equalsIgnoreCase(SCHEDULE_INFO_PROPERTY) || bagName.equalsIgnoreCase(PROCESS_INFO_PROPERTY)) {
                String subPropertyName = name.substring(delimIndex + 1);
                int delimIndex2 = subPropertyName.indexOf(".");
                if (delimIndex2 > 0) {
                    int realindex = delimIndex2 + delimIndex + 1;
                    return name.substring(0, realindex);
                }
                return name;
            }
            return bagName;
        }
        return name;
    }
}

