/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.uri.IPageResult;
import com.crystaldecisions.sdk.uri.PagingQueryOptions;
import com.crystaldecisions.sdk.uri.internal.SQLQueryHolder;
import com.crystaldecisions.sdk.uri.internal.URIPageFactory;
import com.crystaldecisions.sdk.uri.internal.URIPageResultBase;
import java.util.Vector;

public class URIPageResult
extends URIPageResultBase
implements IPageResult {
    static final long serialVersionUID = -3842907049732839211L;
    private IInfoStore infostore;
    private String uri;
    private PagingQueryOptions options;
    private SQLQueryHolder query;
    private IInfoObject lastObject;
    private int estimatedResultSize;

    protected URIPageResult(String uri, Vector pageURIs, int resultSize, IInfoStore store, int pageSize, boolean hasMorePage, PagingQueryOptions options, SQLQueryHolder query, IInfoObject lastObject) {
        super(pageURIs, resultSize, pageSize, hasMorePage);
        this.options = options;
        this.infostore = store;
        this.uri = uri;
        this.query = query;
        this.lastObject = lastObject;
        this.estimatedResultSize = resultSize;
    }

    public int getEstimatedTotalResultSize() {
        return this.estimatedResultSize;
    }

    void setEstimatedTotalResultSize(int size) {
        this.estimatedResultSize = size;
    }

    Vector getPageURIs() {
        return this.allPageURIs;
    }

    SQLQueryHolder getQuery() {
        return this.query;
    }

    IInfoObject getLastObject() {
        return this.lastObject;
    }

    synchronized void setLastObject(IInfoObject obj) {
        this.lastObject = obj;
    }

    IInfoStore getInfoStore() {
        return this.infostore;
    }

    String getURI() {
        return this.uri;
    }

    PagingQueryOptions getOptions() {
        return this.options;
    }

    public String getPageURI(int index) {
        if (!this.options.isIncremental()) {
            return super.getPageURI(index);
        }
        if (index == 0) {
            return (String)this.allPageURIs.get(index);
        }
        if ((index >= this.getPageCount() || index + 1 == this.getPageCount()) && this.hasMorePage) {
            try {
                this.getPageURIHelper(index + 1);
            }
            catch (SDKException e) {
                throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
            }
        }
        return super.getPageURI(index);
    }

    public String getLastPageURI() {
        if (!this.options.isIncremental()) {
            return super.getLastPageURI();
        }
        if (!this.hasMorePage) {
            return super.getLastPageURI();
        }
        int estimatedResultSize = this.getEstimatedTotalResultSize();
        int estimatedNumOfPages = estimatedResultSize / this.pageSize + 1;
        return this.getPageURI(estimatedNumOfPages);
    }

    private synchronized void getPageURIHelper(int index) throws SDKException {
        URIPageFactory.updatePagedResultEveryHelper(index, this);
    }

    public boolean hasMorePage(int pageindex) {
        if (!this.hasMorePage) {
            return super.hasMorePage(pageindex);
        }
        if (pageindex + 1 < this.getPageCount()) {
            return true;
        }
        this.getPageURI(pageindex);
        return super.hasMorePage(pageindex);
    }
}

