/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.URIParserException;
import java.io.Serializable;
import java.util.HashMap;

public class URIParameterHelper
implements Serializable {
    static final long serialVersionUID = 3345784880669154643L;
    private static final ILogger LOG = LoggerManager.getLogger((String)URIParameterHelper.class.getName());
    private HashMap paramMap = null;
    private StringBuffer paramList = null;
    private int searchOptions = 0;
    public static final String PARAMETER_ORDER_BY = "OrderBy";
    public static final String PARAMETER_ORDER_PARAM = "OrderParam";
    public static final String PARAMETER_FROM = "From";
    public static final String PARAMETER_TO = "To";
    private static final String _NAME = "SearchName";
    private static final String _KEYWORDS = "SearchKeywords";
    private static final String _DESCRIPTION = "SearchDescription";
    private static final String _CASE = "CaseSensitive";
    private static final String _ALL = "MatchAllWords";
    private static final String _WITHOUT = "FindWithoutWords";
    private static final String _EXACT = "MatchExact";
    private static final String _INSTANCES = "IncludeInstances";

    public URIParameterHelper(String paramList) throws URIParserException {
        this.paramList = new StringBuffer(paramList);
        this.paramMap = this.parseParameters(paramList);
        this.searchOptions = 0;
        this.processSearchParameters();
    }

    public StringBuffer getParameters() {
        return this.paramList;
    }

    public Object getParameter(String key) {
        return this.paramMap.get(key.toLowerCase());
    }

    public boolean containsKey(String key) {
        return this.paramMap.containsKey(key.toLowerCase());
    }

    public int getSearchOptions() {
        return this.searchOptions;
    }

    private void checkValue(String param, int value) throws URIParserException {
        if (!this.paramMap.containsKey(param.toLowerCase())) {
            this.searchOptions |= value & 3;
            return;
        }
        String paramValue = (String)this.paramMap.get(param.toLowerCase());
        if (paramValue.toLowerCase().equals("true")) {
            this.searchOptions |= value;
        } else if (paramValue.toLowerCase().equals("false")) {
            this.searchOptions &= ~value;
        } else {
            LOG.error((Object)"Invalid search expression: search options must either be true or false!");
            throw new URIParserException.MalformedSearchExpression(param + "=" + paramValue);
        }
    }

    protected void processSearchParameters() throws URIParserException {
        this.searchOptions = 0;
        if (this.paramMap == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The URI Query Parser parameter map was null while attempting to processSearchParameters. Using default search parameters instead...");
            }
            return;
        }
        this.checkValue(_NAME, 1);
        this.checkValue(_KEYWORDS, 2);
        this.checkValue(_DESCRIPTION, 4);
        this.checkValue(_CASE, 8);
        this.checkValue(_ALL, 16);
        this.checkValue(_WITHOUT, 32);
        this.checkValue(_EXACT, 64);
        this.checkValue(_INSTANCES, 128);
    }

    private HashMap parseParameters(String paramList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int beginIndex = paramList.indexOf("?") + 1;
        int endIndex = 0;
        int size = paramList.length();
        while (beginIndex > 0 && beginIndex < size) {
            String value;
            endIndex = paramList.indexOf("=", beginIndex);
            String key = paramList.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
            if ((endIndex = paramList.indexOf("&", beginIndex)) < 0) {
                value = paramList.substring(beginIndex);
                beginIndex = -1;
            } else if (beginIndex >= endIndex) {
                value = "";
                beginIndex = endIndex + 1;
            } else {
                value = paramList.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
            }
            if (LOG.isWarnEnabled() && map.containsKey(key.toLowerCase())) {
                LOG.warn((Object)("URI contains duplicate key '" + key + "', taking last value"));
            }
            map.put(key.toLowerCase(), value);
        }
        return map;
    }
}

