/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.uri.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.URIParserException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.uri.PagingQueryOptions;
import com.crystaldecisions.sdk.uri.internal.ConfigurationHelper;
import com.crystaldecisions.sdk.uri.internal.SQLQueryHolder;
import com.crystaldecisions.sdk.uri.internal.SearchHelper;
import com.crystaldecisions.sdk.uri.internal.StringHelper;
import com.crystaldecisions.sdk.uri.internal.URIParameterHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIQueryParser
implements Serializable {
    static final long serialVersionUID = 6727913590103913922L;
    private static final ILogger LOG = LoggerManager.getLogger((String)URIQueryParser.class.getName());
    private String querySelect;
    private String queryFrom;
    private String queryWhere;
    private String queryPagingWhere;
    private String queryRelationshipType;
    private String queryRelationshipSelection;
    private String queryAdditionalWhere;
    private String queryLike;
    private String queryOrderBy;
    private int pagesize = -1;
    private String keyNode;
    private boolean useLike;
    private boolean nameInWhere;
    private boolean trailingSlash;
    private boolean usingRelationship;
    private boolean queryParentsOnly;
    private boolean usingRecursion;
    private boolean includeParent;
    private boolean usingPath;
    private String errorNode;
    private String originalURI;
    private boolean underPackage;
    private URIParameterHelper paramList;
    private IInfoStore infoStore;
    private String latestNodeKind;
    private String latestNodeCUID;
    private int latestNodeID;
    private Integer baseParentID;
    private boolean clean;
    private int queryCount;
    public static final String ESCAPE_CHARACTER = "\\";
    public static final String PAGING_PARAM = "BIP";
    public static final int TOP_LEVEL_FOLDER_ID = 4;
    public static final int TOP_LEVEL_APP_FOLDER_ID = 43;
    public static String DEFAULT_SELECT_LIST;
    public static String PAGESIZE;
    private static final Pattern SELECT_FROM_REGEX;
    private static final Pattern WHERE_REGEX;
    private static final Pattern ORDER_BY_REGEX;
    protected static final HashSet INDEXED_PROPERTIES;
    public static String PROP_URI_SELECT_LIST;
    public static String PROP_DEF_URI_SELECT_LIST;

    public URIQueryParser(IInfoStore infoStore) throws URIParserException {
        this.infoStore = infoStore;
        this.resetState();
    }

    private void resetState() {
        this.querySelect = "";
        this.queryFrom = "";
        this.queryWhere = "";
        this.queryPagingWhere = "";
        this.queryRelationshipType = "";
        this.queryRelationshipSelection = "";
        this.queryAdditionalWhere = "";
        this.queryLike = "";
        this.queryOrderBy = "";
        this.useLike = false;
        this.nameInWhere = true;
        this.usingRelationship = false;
        this.usingRecursion = false;
        this.queryParentsOnly = false;
        this.includeParent = false;
        this.underPackage = false;
        this.usingPath = false;
        this.errorNode = null;
        this.originalURI = "";
        this.keyNode = "";
        this.latestNodeKind = "";
        this.latestNodeCUID = "";
        this.latestNodeID = 4;
        this.paramList = null;
        this.baseParentID = null;
        this.clean = true;
        this.queryCount = 0;
        this.pagesize = -1;
    }

    public int getParentID() {
        return this.latestNodeID;
    }

    public String getParentCUID() {
        return this.latestNodeCUID;
    }

    public String getParentKind() {
        return this.latestNodeKind;
    }

    public String getElement() {
        return this.keyNode;
    }

    public boolean isUsingPaging() {
        return this.queryPagingWhere != null && this.queryPagingWhere.length() > 0;
    }

    public boolean containsParameters() {
        return this.paramList != null;
    }

    public boolean isUsingRelationship() {
        return this.usingRelationship;
    }

    public boolean isUsingRecursion() {
        return this.usingRecursion;
    }

    public boolean isIncludeParent() {
        return this.includeParent;
    }

    public String getOriginalURI() {
        return this.originalURI;
    }

    public Integer getBaseParentID() {
        return this.baseParentID;
    }

    public boolean isUsingPath() {
        return this.usingPath;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public boolean isPagesizeSetFromURI() {
        return this.pagesize > 0;
    }

    public int getPageSize() {
        return this.pagesize;
    }

    public SQLQueryHolder processURI(String URI2) throws URIParserException {
        return this.processURI(URI2, false, null);
    }

    public SQLQueryHolder processURI(String URI2, boolean skipDecode) throws URIParserException {
        return this.processURI(URI2, skipDecode, null);
    }

    public SQLQueryHolder processURI(String URI2, PagingQueryOptions opt) throws URIParserException {
        return this.processURI(URI2, false, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLQueryHolder processURI(String URI2, boolean skipDecode, PagingQueryOptions opt) throws URIParserException {
        SQLQueryHolder sQLQueryHolder;
        SQLQueryHolder result = null;
        try {
            if (!this.clean) {
                this.resetState();
            }
            this.clean = false;
            this.originalURI = URI2;
            int sepIndex = URI2.indexOf("://");
            if (sepIndex < 0) {
                LOG.error((Object)"URI must be of the form: 'protocol://pathexpression' where protocol is one of query, path, cuid, or search");
                throw new URIParserException.InvalidProtocol(URI2);
            }
            String protocol = URI2.substring(0, sepIndex);
            String expression = URI2.substring(sepIndex + 3);
            if (protocol.equalsIgnoreCase("query")) {
                result = this.handleQuery(StringHelper.encodeURI(expression, ESCAPE_CHARACTER), skipDecode, opt);
            } else if (protocol.equalsIgnoreCase("path")) {
                this.usingPath = true;
                result = this.handlePath(StringHelper.encodeURI(expression, ESCAPE_CHARACTER), opt);
            } else if (protocol.equalsIgnoreCase("cuid")) {
                result = this.handleCuidList(StringHelper.encodeURI(expression, ESCAPE_CHARACTER), opt);
            } else if (protocol.equalsIgnoreCase("search")) {
                result = this.handleSearch(StringHelper.encodeURI(expression, ESCAPE_CHARACTER), opt);
            } else {
                LOG.error((Object)("Invalid protocol specified = '" + protocol + "'"));
                throw new URIParserException.InvalidProtocol(URI2);
            }
            sQLQueryHolder = result;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            block13: {
                Object var10_10 = null;
                if (!LOG.isInfoEnabled()) break block13;
                String infoLog = "URIQueryParser stats: \nInputURI = " + this.originalURI + "\n" + "Generated SQL = ";
                infoLog = result == null ? infoLog + "null" : infoLog + result.getFullQuery();
                infoLog = infoLog + "\nGeneration Query Count = " + this.getQueryCount() + "\n";
                LOG.info((Object)infoLog);
            }
            throw throwable;
        }
        if (LOG.isInfoEnabled()) {
            String infoLog = "URIQueryParser stats: \nInputURI = " + this.originalURI + "\n" + "Generated SQL = ";
            infoLog = result == null ? infoLog + "null" : infoLog + result.getFullQuery();
            infoLog = infoLog + "\nGeneration Query Count = " + this.getQueryCount() + "\n";
            LOG.info((Object)infoLog);
        }
        return sQLQueryHolder;
    }

    private SQLQueryHolder handlePath(String path, PagingQueryOptions opt) throws URIParserException {
        int firstSlash;
        HashSet<Integer> validParents = new HashSet<Integer>();
        this.trailingSlash = false;
        this.nameInWhere = true;
        if (path.endsWith("/")) {
            this.nameInWhere = false;
            this.trailingSlash = true;
        }
        if ((firstSlash = path.indexOf("/")) < 0) {
            LOG.error((Object)"A valid path URI must contain at least one node beyond the root node.  But, something like path://InfoObjects/** would be valid, if inefficient");
            throw new URIParserException.InvalidURI(this.originalURI);
        }
        String rootNode = path.substring(0, firstSlash);
        String remainingPath = path.substring(firstSlash);
        if (rootNode.equalsIgnoreCase("InfoObjects")) {
            this.queryFrom = "CI_INFOOBJECTS";
            validParents.add(new Integer(4));
        } else if (rootNode.equalsIgnoreCase("AppObjects")) {
            this.queryFrom = "CI_APPOBJECTS";
            validParents.add(new Integer(4));
        } else if (rootNode.equalsIgnoreCase("SystemObjects")) {
            this.queryFrom = "CI_SYSTEMOBJECTS";
            validParents.add(new Integer(4));
        } else if (rootNode.equals("*")) {
            this.queryFrom = "CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS";
            validParents.add(new Integer(4));
        } else {
            LOG.error((Object)"Currently root element must be one of (InfoObjects, AppObjects, SystemObjects) or * for wild card");
            throw new URIParserException.InvalidRootElement(rootNode);
        }
        this.handlePathNodes(remainingPath, validParents);
        if (this.querySelect.length() == 0) {
            this.querySelect = DEFAULT_SELECT_LIST;
        }
        if (this.usingRelationship) {
            this.queryFrom = "CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS";
        }
        SQLQueryHolder query = new SQLQueryHolder(this.querySelect, this.queryFrom, this.queryWhere, this.queryPagingWhere, this.queryOrderBy, opt);
        return query;
    }

    private HashSet findValidWildCardParents(String node, HashSet ancestorIDs, HashSet parentIDs) throws URIParserException {
        if (node.indexOf(47) >= 0) {
            LOG.warn((Object)"Improper use of function...node should contain no slashes in findValidWIldCardParents");
            if (this.errorNode == null) {
                this.errorNode = node;
            }
            return null;
        }
        String wild = node.replace('*', '%');
        wild = StringHelper.decodeURIToSQL(wild);
        String treeSQL = "SELECT SI_ID, SI_PARENTID, SI_NAME FROM " + this.queryFrom + " WHERE ";
        if (node.length() > 1) {
            treeSQL = treeSQL + "SI_NAME LIKE '" + wild + "' AND ";
        }
        if (ancestorIDs != null && ancestorIDs.size() > 0) {
            treeSQL = treeSQL + "SI_ANCESTOR IN " + this.getInList(ancestorIDs);
        } else if (parentIDs != null && parentIDs.size() > 0) {
            treeSQL = treeSQL + "SI_PARENTID IN " + this.getInList(parentIDs);
        }
        treeSQL = treeSQL + " ORDER BY SI_ID";
        ++this.queryCount;
        IInfoObjects treeObjects = null;
        try {
            treeObjects = this.infoStore.query(treeSQL);
        }
        catch (SDKException sdke) {
            throw new URIParserException.CESDKException((Exception)((Object)sdke));
        }
        int numObjects = treeObjects.size();
        if (numObjects == 0) {
            if (this.errorNode == null) {
                this.errorNode = node;
            }
            return null;
        }
        HashSet<Integer> validParents = new HashSet<Integer>();
        for (int j = 0; j < numObjects; ++j) {
            IInfoObject curObject = (IInfoObject)treeObjects.get(j);
            validParents.add(new Integer(curObject.getID()));
        }
        return validParents;
    }

    private HashSet findValidParentsRecursive(String path, HashSet ancestorIDs, HashSet parentIDs) throws URIParserException {
        if (ancestorIDs == null && parentIDs == null) {
            LOG.warn((Object)"WARNING: Attemping to find valid parents, but ancestor and parent lists given were null...Returning empty list.");
            if (this.errorNode == null) {
                this.errorNode = path;
            }
            return null;
        }
        int firstWildIndex = path.indexOf(42);
        if (firstWildIndex >= 0) {
            int slashBeforeWild = path.lastIndexOf(47, firstWildIndex);
            int slashAfterWild = path.indexOf(47, firstWildIndex);
            int wildBeginIndex = slashBeforeWild < 0 ? 0 : slashBeforeWild + 1;
            int wildEndIndex = slashAfterWild < 0 ? path.length() - 1 : slashAfterWild - 1;
            String wildCardNode = path.substring(wildBeginIndex, wildEndIndex + 1);
            HashSet preWildParents = null;
            if (slashBeforeWild >= 0) {
                String prePath = path.substring(0, slashBeforeWild);
                preWildParents = this.findValidParents(prePath, ancestorIDs, parentIDs);
            }
            HashSet postWildParents = null;
            postWildParents = preWildParents == null ? this.findValidWildCardParents(wildCardNode, ancestorIDs, parentIDs) : this.findValidWildCardParents(wildCardNode, null, preWildParents);
            if (slashAfterWild < 0) {
                return postWildParents;
            }
            String postPath = path.substring(slashAfterWild + 1);
            return this.findValidParentsRecursive(postPath, null, postWildParents);
        }
        return this.findValidParents(path, ancestorIDs, parentIDs);
    }

    private HashSet findValidParents(String path, HashSet ancestorIDs, HashSet parentIDs) throws URIParserException {
        String[] nodes = path.split("/");
        int numNodes = nodes.length;
        String treeSQL = "SELECT SI_ID, SI_PARENTID, SI_NAME FROM " + this.queryFrom + " WHERE SI_NAME IN (";
        for (int i = 0; i < numNodes; ++i) {
            nodes[i] = StringHelper.decodeURI(nodes[i]);
            if (nodes[i].length() <= 0) continue;
            treeSQL = treeSQL + "'" + nodes[i] + "'";
            if (i >= numNodes - 1) continue;
            treeSQL = treeSQL + ",";
        }
        if (treeSQL.endsWith(",")) {
            treeSQL = treeSQL.substring(0, treeSQL.length() - 1);
        }
        treeSQL = treeSQL + ") ";
        if (ancestorIDs != null && ancestorIDs.size() > 0) {
            treeSQL = treeSQL + " AND SI_ANCESTOR IN " + this.getInList(ancestorIDs);
        } else if (parentIDs != null && parentIDs.size() > 0) {
            treeSQL = treeSQL + " AND SI_ANCESTOR IN " + this.getInList(parentIDs);
        }
        treeSQL = treeSQL + " ORDER BY SI_ID";
        ++this.queryCount;
        IInfoObjects treeObjects = null;
        try {
            treeObjects = this.infoStore.query(treeSQL);
        }
        catch (SDKException sdke) {
            throw new URIParserException.CESDKException((Exception)((Object)sdke));
        }
        HashSet validParents = null;
        if (parentIDs != null) {
            validParents = parentIDs;
        }
        for (int i = 0; i < numNodes; ++i) {
            String curNode = nodes[i];
            if (curNode.length() == 0 || (validParents = this.findValidNodes(curNode, treeObjects, validParents)) != null && validParents.size() > 0) continue;
            if (this.errorNode == null) {
                this.errorNode = curNode;
            }
            return null;
        }
        if (this.baseParentID == null && !validParents.isEmpty()) {
            this.baseParentID = validParents.size() > 1 ? new Integer(4) : (Integer)validParents.iterator().next();
        }
        return validParents;
    }

    private HashSet findValidNodes(String node, IInfoObjects treeObjects, HashSet validParents) throws URIParserException {
        HashSet<Integer> validNodes = new HashSet<Integer>();
        int numObjects = treeObjects.size();
        for (int j = 0; j < numObjects; ++j) {
            IInfoObject curObject = (IInfoObject)treeObjects.get(j);
            String curTitle = StringHelper.replace(curObject.getTitle(), "'", "''");
            if (!curTitle.equalsIgnoreCase(node) || validParents != null && !validParents.contains(new Integer(URIQueryParser.getRealParentID(curObject.getParentID(), curObject.getID())))) continue;
            validNodes.add(new Integer(curObject.getID()));
        }
        return validNodes;
    }

    private static int getRealParentID(int parentID, int objectID) {
        return parentID == 0 ? (objectID == 18 ? 4 : 23) : parentID;
    }

    private String getInList(HashSet values) {
        String result = "(";
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result = result + String.valueOf((Integer)iter.next());
            if (!iter.hasNext()) continue;
            result = result + ",";
        }
        result = result + ")";
        return result;
    }

    private void handlePathNodes(String remainingPath, HashSet validParents) throws URIParserException {
        int lastRecursiveIndex;
        String finalNode = null;
        int lastSlash = remainingPath.lastIndexOf("/");
        if (lastSlash >= 0) {
            if (!this.trailingSlash) {
                finalNode = remainingPath.substring(lastSlash + 1);
                remainingPath = remainingPath.substring(0, lastSlash + 1);
            }
            if (remainingPath.indexOf("**+") >= 0) {
                LOG.error((Object)"Invalid URI: The ** operator can not be used in conjunction with +");
                throw new URIParserException.InvalidURI(this.originalURI);
            }
            if (remainingPath.endsWith("**/")) {
                this.usingRecursion = true;
            } else if (remainingPath.endsWith("+/")) {
                remainingPath = remainingPath.substring(0, remainingPath.length() - 2) + "/";
                this.includeParent = true;
            }
            String[] recursionBlocks = remainingPath.split("\\*\\*");
            int numBlocks = recursionBlocks.length;
            for (int i = 0; i < numBlocks; ++i) {
                String currentBlock = recursionBlocks[i];
                if (!currentBlock.startsWith("/")) {
                    LOG.error((Object)"Invalid URI: The ** operator must appear by itself when mid path");
                    throw new URIParserException.InvalidURI(this.originalURI);
                }
                if (i < numBlocks - 1 && !currentBlock.endsWith("/")) {
                    LOG.error((Object)"Invalid URI: The ** operator must be preceded by the / operator");
                    throw new URIParserException.InvalidURI(this.originalURI);
                }
                if ((currentBlock = this.stripSlash(currentBlock)).length() == 0 || (validParents = i == 0 ? this.findValidParentsRecursive(currentBlock, null, validParents) : this.findValidParentsRecursive(currentBlock, validParents, null)) != null && validParents.size() != 0) continue;
                LOG.error((Object)("Invalid URI path node: " + this.errorNode));
                throw new URIParserException.InvalidPathNode(this.errorNode);
            }
        } else {
            finalNode = remainingPath;
        }
        if (finalNode != null && (lastRecursiveIndex = finalNode.indexOf("**")) >= 0) {
            this.usingRecursion = true;
            if (lastRecursiveIndex > 0 && finalNode.charAt(lastRecursiveIndex - 1) != '/') {
                LOG.error((Object)"Invalid URI: The ** operator must follow a forward slash.");
                throw new URIParserException.InvalidURI(this.originalURI);
            }
            if (finalNode.length() > lastRecursiveIndex + 2 && finalNode.charAt(lastRecursiveIndex + 2) != '[' && finalNode.charAt(lastRecursiveIndex + 2) != '@' && finalNode.charAt(lastRecursiveIndex + 2) != '?') {
                LOG.error((Object)("Invalid URI: Try '.../**/" + finalNode.substring(lastRecursiveIndex + 2) + "' instead."));
                throw new URIParserException.InvalidURI(this.originalURI);
            }
            if (finalNode.length() == lastRecursiveIndex + 2) {
                this.trailingSlash = true;
            } else {
                finalNode = finalNode.substring(lastRecursiveIndex + 2);
            }
        }
        if (!this.trailingSlash) {
            this.handleNode(finalNode);
        }
        boolean needAnd = false;
        if (this.queryAdditionalWhere.length() > 0) {
            needAnd = true;
        }
        if (this.usingRecursion) {
            if (needAnd) {
                this.queryAdditionalWhere = this.queryAdditionalWhere + " AND ";
            }
            this.queryAdditionalWhere = this.includeParent ? this.queryAdditionalWhere + "(SI_ANCESTOR IN " + this.getInList(validParents) + " OR SI_ID IN " + this.getInList(validParents) + ")" : this.queryAdditionalWhere + "SI_ANCESTOR IN " + this.getInList(validParents);
            needAnd = true;
        } else {
            if (needAnd) {
                this.queryAdditionalWhere = this.queryAdditionalWhere + " AND ";
            }
            needAnd = true;
            this.queryAdditionalWhere = this.underPackage || this.includeParent ? this.queryAdditionalWhere + "(SI_PARENTID IN " + this.getInList(validParents) + " OR SI_ID IN " + this.getInList(validParents) + ")" : (this.usingRelationship || this.queryParentsOnly ? this.queryAdditionalWhere + "SI_ID IN " + this.getInList(validParents) : this.queryAdditionalWhere + "SI_PARENTID IN " + this.getInList(validParents));
        }
        if (this.useLike) {
            if (this.queryWhere.length() > 0) {
                this.queryWhere = this.queryWhere + " AND ";
            }
            this.queryWhere = this.queryWhere + "SI_NAME LIKE '" + this.queryLike + "'";
        } else if (this.nameInWhere && this.keyNode.length() > 0) {
            if (needAnd) {
                this.queryAdditionalWhere = this.queryAdditionalWhere + " AND ";
            }
            this.queryAdditionalWhere = this.queryAdditionalWhere + "SI_NAME='" + StringHelper.decodeURI(this.keyNode) + "'";
            needAnd = true;
        }
        if (this.usingRelationship) {
            if (this.queryWhere.length() > 0) {
                this.queryWhere = " AND " + this.queryWhere;
            }
            this.queryWhere = this.queryRelationshipType + "(\"" + this.queryRelationshipSelection + "\", \"" + this.queryAdditionalWhere + "\")" + this.queryWhere;
        } else {
            this.queryWhere = needAnd && this.queryWhere.length() > 0 ? this.queryAdditionalWhere + " AND " + this.queryWhere : this.queryAdditionalWhere + this.queryWhere;
        }
        if (this.queryOrderBy == null || this.queryOrderBy.length() == 0) {
            this.queryOrderBy = "SI_ID";
        }
    }

    private String stripSlash(String path) {
        if ((path = path.trim()).equals("/")) {
            return "";
        }
        int begin = 0;
        int end = path.length();
        if (path.startsWith("/")) {
            ++begin;
        }
        if (path.endsWith("/")) {
            --end;
        }
        path = path.substring(begin, end).trim();
        return path;
    }

    private void handleNode(String node) throws URIParserException {
        int attIndex = node.indexOf("@");
        int condIndex = node.indexOf("[");
        int wildIndex = node.indexOf("*");
        int parameterIndex = node.indexOf("?");
        if (parameterIndex >= 0) {
            node = this.handleParameters(node);
        }
        if (attIndex >= 0) {
            node = this.handleAttribute(node);
        }
        if (condIndex >= 0) {
            node = this.handleCondition(node);
        }
        if (wildIndex >= 0) {
            this.handleWild(node);
        }
        this.keyNode = node;
    }

    static int findOperatorEndIndex(int startPos, String node) {
        char[] operators = new char[]{'[', '@', '?', '/'};
        int numOps = operators.length;
        int nextPos = node.length();
        int tempPos = -1;
        for (int i = 0; i < numOps; ++i) {
            tempPos = node.indexOf(operators[i], startPos);
            if (tempPos <= startPos || tempPos >= nextPos) continue;
            nextPos = tempPos;
        }
        return nextPos - 1;
    }

    private String stripOperator(String node, int startIndex, int endIndex) {
        if (startIndex > 0) {
            if (endIndex >= node.length() - 1) {
                return node.substring(0, startIndex);
            }
            return node.substring(0, startIndex) + node.substring(endIndex + 1);
        }
        if (endIndex >= node.length() - 1) {
            return "";
        }
        return node.substring(endIndex + 1);
    }

    private String handleParameters(String parameterList) throws URIParserException {
        int beginPR = parameterList.lastIndexOf(63);
        if (beginPR < 0) {
            return parameterList;
        }
        int endPR = URIQueryParser.findOperatorEndIndex(beginPR, parameterList);
        if (this.paramList != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"WARNING: handleParameters called twice (a param list was parsed twice, or the same URIQP was used without reset getting called...) - this instance may be in an inconsistent state!");
        }
        this.paramList = new URIParameterHelper(parameterList.substring(beginPR, endPR + 1));
        if (beginPR == 0 && !this.queryParentsOnly) {
            this.nameInWhere = false;
            this.trailingSlash = true;
        }
        if (this.paramList.containsKey("OrderBy")) {
            if (this.queryOrderBy != null && this.queryOrderBy.length() > 0) {
                LOG.warn((Object)("While parsing parameters, ORDER BY got overwritten.  Previous Value was '" + this.queryOrderBy + "'"));
            }
            this.queryOrderBy = (String)this.paramList.getParameter("OrderBy".toLowerCase());
            if (this.queryOrderBy == null || this.queryOrderBy.length() == 0) {
                this.queryOrderBy = "SI_ID";
            }
        }
        if (this.paramList.containsKey("BIP1")) {
            this.queryPagingWhere = SQLQueryHolder.parsePagingParameters(this.paramList);
            if (this.queryPagingWhere == null) {
                LOG.error((Object)"Invalid URI: Paging parameters only partially specified!");
                throw new URIParserException.InvalidURI(this.originalURI);
            }
        }
        if (this.paramList.containsKey(PAGESIZE)) {
            try {
                String strpagesize = (String)this.paramList.getParameter(PAGESIZE);
                Integer pagesize = Integer.valueOf(strpagesize);
                int psize = pagesize;
                if (psize > 0) {
                    this.pagesize = psize;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Invalid URI: Paging parameters only partially specified with pagesize!");
                throw new URIParserException.InvalidURI(this.originalURI);
            }
        }
        return this.stripOperator(parameterList, beginPR, endPR);
    }

    private String handleAttribute(String attribute) {
        String attributeList;
        int attIndex = attribute.indexOf("@");
        if (attIndex < 0) {
            return attribute;
        }
        int attEndIndex = URIQueryParser.findOperatorEndIndex(attIndex, attribute);
        this.querySelect = attributeList = attribute.substring(attIndex + 1, attEndIndex + 1);
        if (attIndex == 0) {
            this.nameInWhere = false;
            this.trailingSlash = true;
        } else {
            this.nameInWhere = true;
        }
        return this.stripOperator(attribute, attIndex, attEndIndex);
    }

    private void handleWild(String wild) {
        if (wild.length() > 1) {
            this.useLike = true;
            this.queryLike = StringHelper.decodeURIToSQL(wild.replace('*', '%'));
        } else {
            this.nameInWhere = false;
        }
    }

    private String handleCondition(String condition) throws URIParserException {
        int condIndex = condition.indexOf("[");
        int condIndexEnd = condition.indexOf("]");
        if (condIndex < 0 && condIndexEnd < 0) {
            return condition;
        }
        if (condIndexEnd < condIndex) {
            LOG.error((Object)("Malformed Conditional Expression:" + condition));
            throw new URIParserException.MalformedConditional(condition);
        }
        String conditionExp = condition.substring(condIndex + 1, condIndexEnd);
        conditionExp = StringHelper.decodeURI(conditionExp);
        if (condIndex == 0) {
            this.nameInWhere = false;
            this.trailingSlash = true;
            if (this.queryWhere.length() > 0) {
                this.queryWhere = this.queryWhere + " AND ";
            }
            this.queryWhere = this.queryWhere + "(" + conditionExp + ")";
        } else {
            this.usingRelationship = true;
            String useConditionExp = conditionExp;
            if (conditionExp.toUpperCase().equals("SI_USERGROUPS")) {
                useConditionExp = "SI_ENT_USERGROUPS";
            } else if (conditionExp.toUpperCase().equals("SI_GROUP_MEMBERS")) {
                useConditionExp = "SI_ENT_GROUP_MEMBERS";
            }
            if (condition.startsWith("ancestors")) {
                this.queryRelationshipType = "Ancestors";
                this.queryRelationshipSelection = "SI_RELATION_PARENTS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("descendants")) {
                this.queryRelationshipType = "Descendants";
                this.queryRelationshipSelection = "SI_RELATION_CHILDREN_MEMBERS_PROPERTY='" + useConditionExp + "'" + " OR SI_RELATION_CHILDREN_GROUPS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("connected components")) {
                this.queryRelationshipType = "ConnectedComponents";
                this.queryRelationshipSelection = "SI_RELATION_CHILDREN_MEMBERS_PROPERTY='" + useConditionExp + "'" + " OR SI_RELATION_CHILDREN_GROUPS_PROPERTY='" + useConditionExp + "'" + " OR SI_RELATION_PARENTS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("parents")) {
                this.queryRelationshipType = "Parents";
                this.queryRelationshipSelection = "SI_RELATION_PARENTS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("children")) {
                this.queryRelationshipType = "Children";
                this.queryRelationshipSelection = "SI_RELATION_CHILDREN_MEMBERS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("members")) {
                this.queryRelationshipType = "Members";
                this.queryRelationshipSelection = "SI_RELATION_CHILDREN_MEMBERS_PROPERTY='" + useConditionExp + "'" + " OR SI_RELATION_CHILDREN_GROUPS_PROPERTY='" + useConditionExp + "'";
            } else if (condition.startsWith("groups")) {
                this.queryRelationshipType = "Groups";
                this.queryRelationshipSelection = "SI_RELATION_CHILDREN_GROUPS_PROPERTY='" + useConditionExp + "'";
            } else {
                this.usingRelationship = false;
                this.nameInWhere = true;
                if (this.queryWhere.length() > 0) {
                    this.queryWhere = this.queryWhere + " AND ";
                }
                this.queryWhere = this.queryWhere + "(" + useConditionExp + ")";
            }
        }
        if (this.usingRelationship) {
            if (condIndexEnd < condition.length() - 1) {
                return condition.substring(condIndexEnd + 1);
            }
            return "";
        }
        return this.stripOperator(condition, condIndex, condIndexEnd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLQueryHolder handleCuidList(String expression, PagingQueryOptions opt) throws URIParserException {
        int startIndex = expression.indexOf(60);
        int endIndex = expression.indexOf(62);
        if (startIndex < 0 || endIndex < 0 || endIndex < startIndex) {
            LOG.error((Object)"Malformed cuid protocol call, expression must begin with cuid://<...>");
            throw new URIParserException.MalformedCuidExpression(expression);
        }
        HashSet<Integer> validParents = new HashSet<Integer>();
        String remainingPath = "";
        if (expression.length() > endIndex + 1) {
            remainingPath = expression.substring(endIndex + 1);
        }
        StringBuffer SQLQuery = new StringBuffer("SELECT ");
        if (this.querySelect.length() == 0) {
            this.querySelect = DEFAULT_SELECT_LIST;
            SQLQuery.append(DEFAULT_SELECT_LIST);
        } else if (this.querySelect.length() > 0) {
            SQLQuery.append(this.querySelect);
        }
        SQLQuery.append(" FROM CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS WHERE ");
        this.queryFrom = "CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS";
        String idExpression = expression.substring(startIndex + 1, endIndex);
        String[] ids = idExpression.split(",");
        int idCount = ids.length;
        boolean usingCUIDs = true;
        StringBuffer whereClause = new StringBuffer();
        try {
            Integer.parseInt(ids[0].trim());
            usingCUIDs = false;
            whereClause.append("(SI_ID IN (");
        }
        catch (NumberFormatException nfe) {
            usingCUIDs = true;
            whereClause.append("(SI_CUID IN (");
        }
        for (int i = 0; i < idCount; ++i) {
            String curID = ids[i].trim();
            if (i != 0) {
                whereClause.append(",");
            }
            try {
                Integer intID = new Integer(Integer.parseInt(curID));
                if (usingCUIDs) {
                    LOG.error((Object)("Found an ID in a list of CUIDs: " + curID));
                    throw new URIParserException.FoundIDInCuidList(curID);
                }
                validParents.add(intID);
                whereClause.append(curID);
                continue;
            }
            catch (NumberFormatException nfe) {
                if (!usingCUIDs) {
                    LOG.error((Object)("Found a CUID in a list of IDs: " + curID));
                    throw new URIParserException.FoundCuidInIDList(curID);
                }
                whereClause.append("'");
                whereClause.append(curID);
                whereClause.append("'");
            }
        }
        whereClause.append("))");
        if (remainingPath.length() > 0) {
            if (usingCUIDs) {
                String tempSQL = "SELECT SI_ID FROM CI_INFOOBJECTS,CI_SYSTEMOBJECTS,CI_APPOBJECTS WHERE " + whereClause;
                ++this.queryCount;
                IInfoObjects curObjects = null;
                try {
                    curObjects = this.infoStore.query(tempSQL);
                }
                catch (SDKException sdke) {
                    throw new URIParserException.CESDKException((Exception)((Object)sdke));
                }
                if (curObjects != null) {
                    int numObjects = curObjects.size();
                    for (int i = 0; i < numObjects; ++i) {
                        validParents.add(new Integer(((IInfoObject)curObjects.get(i)).getID()));
                    }
                }
            }
            if (validParents.size() <= 0) {
                LOG.error((Object)("Invalid URI path node - could not find objects matching the following cuids: " + idExpression));
                throw new URIParserException.InvalidPathNode(idExpression);
            }
            this.queryWhere = "";
            if (!remainingPath.startsWith("/")) {
                this.queryParentsOnly = true;
            }
            this.handlePathNodes(remainingPath, validParents);
            return new SQLQueryHolder(this.querySelect, this.queryFrom, this.queryWhere, this.queryPagingWhere, this.queryOrderBy, opt);
        }
        this.queryWhere = whereClause.toString();
        return new SQLQueryHolder(this.querySelect, this.queryFrom, this.queryWhere, this.queryPagingWhere, this.queryOrderBy, opt);
    }

    private SQLQueryHolder handleQuery(String expression, boolean skipDecode, PagingQueryOptions opt) throws URIParserException {
        Matcher selectFromMatcher;
        Matcher whereMatcher;
        String sql;
        String partialQuery;
        Matcher orderByMatcher;
        int iQueryStart = expression.indexOf(123);
        int iQueryEnd = expression.lastIndexOf(125);
        if (iQueryStart != 0 || iQueryEnd < 0 || iQueryStart > iQueryEnd) {
            LOG.error((Object)("ERROR: Malformed query protocol: " + expression));
            throw new URIParserException.MalformedQueryExpression(expression);
        }
        int paramsIndex = expression.indexOf("?", iQueryEnd);
        if (paramsIndex >= 0) {
            expression = this.handleParameters(expression);
        }
        if ((orderByMatcher = ORDER_BY_REGEX.matcher(partialQuery = (sql = expression.substring(iQueryStart + 1, iQueryEnd)))).matches()) {
            this.queryOrderBy = orderByMatcher.group(2);
            partialQuery = orderByMatcher.group(1);
        }
        if ((whereMatcher = WHERE_REGEX.matcher(partialQuery)).matches()) {
            StringBuffer buff = new StringBuffer(this.queryWhere);
            if (this.queryWhere.length() > 0) {
                buff.append(" AND ");
            }
            if (skipDecode) {
                buff.append(whereMatcher.group(2));
            } else {
                buff.append(StringHelper.decodeURI(whereMatcher.group(2)));
            }
            this.queryWhere = buff.toString();
            partialQuery = whereMatcher.group(1);
        }
        if (!(selectFromMatcher = SELECT_FROM_REGEX.matcher(partialQuery)).matches()) {
            throw new URIParserException.InvalidSQLQuery(expression);
        }
        this.queryFrom = selectFromMatcher.group(2);
        this.querySelect = selectFromMatcher.group(1);
        SQLQueryHolder query = new SQLQueryHolder(this.querySelect, this.queryFrom, this.queryWhere, this.queryPagingWhere, this.queryOrderBy, this.pagesize, opt);
        return query;
    }

    private SQLQueryHolder handleSearch(String expression, PagingQueryOptions opt) throws URIParserException {
        int optionsIndex = expression.indexOf("?");
        int startSearch = expression.indexOf(123);
        int endSearch = expression.indexOf(125);
        if (startSearch != 0 || endSearch <= 0) {
            LOG.error((Object)"Malformed search protocol call, expression must be search://{...}?OPTION1=X&OPTION2=Y");
            throw new URIParserException.MalformedSearchExpression(expression);
        }
        int searchOptions = 0;
        if (optionsIndex >= 0 && optionsIndex > endSearch) {
            expression = this.handleParameters(expression);
            searchOptions = this.paramList.getSearchOptions();
        } else {
            searchOptions = 3;
        }
        String searchString = expression.substring(startSearch + 1, endSearch);
        String splitOn = "'";
        String[] quoteSplit = searchString.split(splitOn, -1);
        int numQS = quoteSplit.length;
        if (numQS % 2 != 1) {
            LOG.error((Object)"Malformed search expression: Unterminated quote found.");
            throw new URIParserException.MalformedSearchExpression(searchString);
        }
        SearchHelper search = new SearchHelper(searchOptions);
        for (int i = 0; i < numQS; ++i) {
            if (i % 2 == 1) {
                String nextWord = quoteSplit[i].trim();
                if (nextWord.length() <= 0) continue;
                search.addSearchWord(search.formatSearchWord(nextWord));
                continue;
            }
            String[] searchWords = quoteSplit[i].split("(\\s+)");
            int numSW = searchWords.length;
            for (int j = 0; j < numSW; ++j) {
                String nextWord = searchWords[j].trim();
                if (nextWord.length() <= 0) continue;
                search.addSearchWord(search.formatSearchWord(nextWord));
            }
        }
        search.finishSQL();
        this.querySelect = search.getQuerySelect();
        this.queryFrom = search.getQueryFrom();
        if (this.queryWhere.length() > 0) {
            this.queryWhere = this.queryWhere + " AND ";
        }
        this.queryWhere = this.queryWhere + "(" + search.getQueryWhere() + ")";
        SQLQueryHolder query = new SQLQueryHolder(this.querySelect, this.queryFrom, this.queryWhere, this.queryPagingWhere, this.queryOrderBy, opt);
        return query;
    }

    static {
        PAGESIZE = "BPPSIZE";
        SELECT_FROM_REGEX = Pattern.compile("(?is)\\s*select\\s+(.*)\\s+from\\s+(.*)\\s*");
        WHERE_REGEX = Pattern.compile("(?is)(.*)\\s+where\\s+(.*)\\s*");
        ORDER_BY_REGEX = Pattern.compile("(?is)(.*)\\s+order\\s+by\\s+(.*)\\s*");
        PROP_URI_SELECT_LIST = "defaultSelectList";
        PROP_DEF_URI_SELECT_LIST = "static";
        DEFAULT_SELECT_LIST = ConfigurationHelper.getInstance("META-INF/CrystalEnterprise.Services/URIQueryParser.properties").getProperty(PROP_URI_SELECT_LIST, PROP_DEF_URI_SELECT_LIST);
        INDEXED_PROPERTIES = new HashSet();
        INDEXED_PROPERTIES.add("SI_INSTANCE_OBJECT");
        INDEXED_PROPERTIES.add("SI_PLUGIN_OBJECT");
        INDEXED_PROPERTIES.add("SI_TABLE");
        INDEXED_PROPERTIES.add("SI_HIDDEN_OBJECT");
        INDEXED_PROPERTIES.add("SI_RECURRING");
        INDEXED_PROPERTIES.add("SI_NAME");
        INDEXED_PROPERTIES.add("SI_ID");
        INDEXED_PROPERTIES.add("SI_OBTYPE");
        INDEXED_PROPERTIES.add("SI_PARENTID");
        INDEXED_PROPERTIES.add("SI_INDEX_PROPERTY_NAME");
        INDEXED_PROPERTIES.add("SI_OWNERID");
        INDEXED_PROPERTIES.add("SI_SCHEDULE_STATUS");
        INDEXED_PROPERTIES.add("SI_NEXTRUNTIME");
        INDEXED_PROPERTIES.add("SI_UPDATE_TS");
        INDEXED_PROPERTIES.add("SI_INSTANCE");
        INDEXED_PROPERTIES.add("SI_RUNNABLE_OBJECT");
        INDEXED_PROPERTIES.add("SI_KIND");
    }
}

