/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CaseInsensMap
implements Map {
    private Map m_map;
    private Set m_keySet;
    private Set m_entrySet;

    public CaseInsensMap(Map map) {
        this.m_map = map;
    }

    public int size() {
        return this.m_map.size();
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.m_map.containsKey(new IgnoreCase(key));
    }

    public boolean containsValue(Object value) {
        return this.m_map.containsValue(value);
    }

    public Object get(Object key) {
        return this.m_map.get(new IgnoreCase(key));
    }

    public Object put(Object key, Object value) {
        return this.m_map.put(new IgnoreCase(key), value);
    }

    public Object remove(Object key) {
        return this.m_map.remove(new IgnoreCase(key));
    }

    public void putAll(Map t) {
        this.m_map.clear();
        Iterator iter = t.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.m_map.clear();
    }

    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new KeyIterator(CaseInsensMap.this.m_map.keySet().iterator());
                }

                public int size() {
                    return CaseInsensMap.this.size();
                }

                public boolean contains(Object o) {
                    return CaseInsensMap.this.keySet().contains(new IgnoreCase(o));
                }

                public boolean remove(Object o) {
                    return CaseInsensMap.this.keySet().remove(new IgnoreCase(o));
                }

                public void clear() {
                    CaseInsensMap.this.clear();
                }
            };
        }
        return this.m_keySet;
    }

    public Collection values() {
        return this.m_map.values();
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EntryIterator(CaseInsensMap.this.m_map.entrySet().iterator());
                }

                public int size() {
                    return CaseInsensMap.this.size();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    return CaseInsensMap.this.keySet().contains(new IgnoreCase(((Map.Entry)o).getKey()));
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    return CaseInsensMap.this.keySet().remove(new IgnoreCase(((Map.Entry)o).getKey()));
                }

                public void clear() {
                    CaseInsensMap.this.clear();
                }
            };
        }
        return this.m_entrySet;
    }

    static class IgnoreCase {
        private String m_string;
        private int m_hashcode;

        public IgnoreCase(Object string) {
            if (!(string instanceof String)) {
                throw new UnsupportedOperationException(string.toString());
            }
            this.m_string = (String)string;
            this.m_hashcode = this.m_string.toLowerCase().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof IgnoreCase) {
                return ((IgnoreCase)object).m_string.equalsIgnoreCase(this.m_string);
            }
            return false;
        }

        public int hashCode() {
            return this.m_hashcode;
        }

        public String getString() {
            return this.m_string;
        }
    }

    static class CIEntry
    implements Map.Entry {
        private Map.Entry m_internal;

        public CIEntry(Map.Entry internal) {
            this.m_internal = internal;
        }

        public Object getKey() {
            return ((IgnoreCase)this.m_internal.getKey()).getString();
        }

        public Object getValue() {
            return this.m_internal.getValue();
        }

        public Object setValue(Object value) {
            return this.m_internal.setValue(value);
        }
    }

    static class EntryIterator
    implements Iterator {
        private Iterator m_internal;

        public EntryIterator(Iterator internal) {
            this.m_internal = internal;
        }

        public boolean hasNext() {
            return this.m_internal.hasNext();
        }

        public Object next() {
            return new CIEntry((Map.Entry)this.m_internal.next());
        }

        public void remove() {
            this.m_internal.remove();
        }
    }

    static class KeyIterator
    implements Iterator {
        private Iterator m_internal;

        public KeyIterator(Iterator internal) {
            this.m_internal = internal;
        }

        public boolean hasNext() {
            return this.m_internal.hasNext();
        }

        public Object next() {
            return ((IgnoreCase)this.m_internal.next()).getString();
        }

        public void remove() {
            this.m_internal.remove();
        }
    }
}

