/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.collections;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class EmptyCollections {
    public static final Map MAP = new EmptyMap();
    private static final Iterator ITERATOR = new EmptyIterator();
    private static final ListIterator LIST_ITERATOR = new EmptyListIterator();
    public static final Set SET = new EmptySet();
    public static final List LIST = new EmptyList();

    private static class EmptyListIterator
    implements ListIterator {
        private EmptyListIterator() {
        }

        public int nextIndex() {
            return 0;
        }

        public int previousIndex() {
            return -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public void add(Object o) {
        }

        public void set(Object o) {
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyList
    extends AbstractList {
        private EmptyList() {
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object obj) {
            return false;
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        public boolean remove(Object o) {
            return false;
        }

        public Iterator iterator() {
            return ITERATOR;
        }

        public int indexOf(Object o) {
            return -1;
        }

        public int lastIndexOf(Object o) {
            return -1;
        }

        public ListIterator listIterator(int index) {
            return LIST_ITERATOR;
        }
    }

    private static class EmptySet
    extends AbstractSet {
        private EmptySet() {
        }

        public Iterator iterator() {
            return ITERATOR;
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object obj) {
            return false;
        }

        public boolean remove(Object o) {
            return false;
        }
    }

    private static class EmptyMap
    extends AbstractMap {
        private EmptyMap() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Set keySet() {
            return SET;
        }

        public Collection values() {
            return SET;
        }

        public Set entrySet() {
            return SET;
        }

        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        public int hashCode() {
            return 0;
        }

        public Object remove(Object key) {
            return null;
        }
    }
}

