/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.collections;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class FastSimpleTable {
    private Map m_map = null;
    private Map m_preloadMap = null;

    public FastSimpleTable(Map map) {
        if (!(map instanceof Cloneable)) {
            throw new IllegalArgumentException("Map must be cloneable");
        }
        this.m_map = map;
        try {
            Method cloneMethod = map.getClass().getMethod("clone", new Class[0]);
            this.m_preloadMap = (Map)cloneMethod.invoke((Object)this.m_map, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void preload() {
        this.m_preloadMap.putAll(this.m_map);
        this.m_map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object obj = this.m_preloadMap.get(key);
        if (obj == null) {
            Map map = this.m_map;
            synchronized (map) {
                return this.m_map.get(key);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Map map = this.m_map;
        synchronized (map) {
            return this.m_map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putUnlessExists(Object key, Object value) {
        Map map = this.m_map;
        synchronized (map) {
            Object result = this.m_map.get(key);
            if (result == null) {
                result = this.m_preloadMap.get(key);
                if (result == null) {
                    this.m_map.put(key, value);
                }
                result = value;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Map map = this.m_map;
        synchronized (map) {
            return this.m_map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map map = this.m_map;
        synchronized (map) {
            return this.m_map.size() + this.m_preloadMap.size();
        }
    }
}

