/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.commandline;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.util.ArrayList;
import java.util.List;

public class ArgsWriter {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.commandline");
    private List m_names = new ArrayList();
    private List m_values = new ArrayList();
    private String m_progName;

    public ArgsWriter() {
    }

    public ArgsWriter(String progName) {
        this();
        this.m_progName = progName;
    }

    public void setProgramName(String progName) {
        this.m_progName = progName;
    }

    public String getProgamName() {
        return this.m_progName;
    }

    public void setArg(String name, String value) {
        LOG.assertNotNull((Object)name, "name is null.");
        this.m_names.add(name);
        this.m_values.add(value);
    }

    public String getValue(String name) {
        LOG.assertNotNull((Object)name, "name is null.");
        int index = this.m_names.indexOf(name);
        if (index != -1) {
            return (String)this.m_values.get(index);
        }
        return null;
    }

    public String getCommandLine() {
        StringBuffer result = new StringBuffer();
        if (this.m_progName != null) {
            result.append(this.quote(this.m_progName));
            result.append(" ");
        }
        if (this.m_names != null) {
            for (int i = 0; i < this.m_names.size(); ++i) {
                String name = (String)this.m_names.get(i);
                result.append('-');
                result.append(name);
                result.append(' ');
                String value = (String)this.m_values.get(i);
                if (value == null) continue;
                result.append(this.quote(value));
                result.append(' ');
            }
        }
        return result.toString();
    }

    public String[] getMainArgs() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_progName != null) {
            result.add(this.m_progName);
        }
        if (this.m_names != null) {
            for (int i = 0; i < this.m_names.size(); ++i) {
                result.add("-" + this.m_names.get(i));
                String value = (String)this.m_values.get(i);
                if (value == null) continue;
                result.add(value);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private String quote(String seed) {
        StringBuffer result = new StringBuffer(seed);
        if (seed.indexOf(32) != -1 && !seed.startsWith("\"")) {
            result.insert(0, '\"');
            if (seed.charAt(seed.length() - 1) == '\\') {
                result.append('\\');
            }
            result.append('\"');
        }
        return result.toString();
    }

    public String toString() {
        return this.getCommandLine();
    }

    public void clear() {
        this.m_names.clear();
        this.m_values.clear();
        this.m_progName = null;
    }
}

