/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.conversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateConversion {
    private static TimeZone s_GMT = TimeZone.getTimeZone("GMT");
    private static final long COM_OFFSET;
    private static final int MS_PER_DAY = 86400000;
    private static final int MS_PER_HALF_SECOND = 500;
    private static final String s_DateIdentifier = "Date";
    private static final String s_DateTimeIdentifier = "DateTime";
    private static final String s_TimeIdentifier = "Time";
    public static final long INVALID_DATETIME = -185544796348800000L;

    public static Date convertVariantDate(double variantDate, TimeZone tz) {
        int day = (int)variantDate;
        int ms = (int)Math.round((variantDate - Math.floor(variantDate)) * 8.64E7);
        if (tz == null) {
            long time = COM_OFFSET + (long)day * 86400000L + (long)ms;
            return new Date(time);
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setLenient(true);
        c.setTimeZone(tz);
        c.set(1899, 11, 30, 0, 0, 0);
        c.add(5, day);
        c.add(14, ms);
        Date result = c.getTime();
        return result;
    }

    public static double convertToVariantDate(Date date, TimeZone tz) {
        if (tz == null) {
            long time = date.getTime();
            long mills = time - COM_OFFSET;
            return (double)mills / 8.64E7;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setLenient(true);
        c.setTimeZone(tz);
        c.set(1899, 11, 30, 0, 0, 0);
        long baseMillis = c.getTime().getTime();
        long millis = date.getTime() - baseMillis;
        double variantDate = (double)millis / 8.64E7;
        return variantDate;
    }

    public static String convertToQueryString(Date date, TimeZone tz) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy MM dd HH mm ss SSS", Locale.ENGLISH);
        if (tz != null) {
            formatter.setTimeZone(tz);
        } else {
            formatter.setTimeZone(s_GMT);
        }
        return formatter.format(date);
    }

    public static Date convertCRDate(String dateString, TimeZone tz) {
        int[] timeFields = DateConversion.parseDateTimeString(dateString, s_DateIdentifier, 3);
        if (timeFields != null) {
            try {
                GregorianCalendar c = new GregorianCalendar(timeFields[0], timeFields[1] - 1, timeFields[2]);
                c.setLenient(false);
                if (tz != null) {
                    c.setTimeZone(tz);
                }
                return c.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date convertCRDateTime(String dateString, TimeZone tz) {
        int[] timeFields = DateConversion.parseDateTimeString(dateString, s_DateTimeIdentifier, 6);
        if (timeFields != null) {
            try {
                GregorianCalendar c = new GregorianCalendar(timeFields[0], timeFields[1] - 1, timeFields[2], timeFields[3], timeFields[4], timeFields[5]);
                c.setLenient(false);
                if (tz != null) {
                    c.setTimeZone(tz);
                }
                return c.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date convertCRTime(String dateString, TimeZone tz) {
        int[] timeFields = DateConversion.parseDateTimeString(dateString, s_TimeIdentifier, 3);
        if (timeFields != null) {
            try {
                GregorianCalendar today = new GregorianCalendar();
                if (tz != null) {
                    today.setTimeZone(tz);
                }
                today.set(11, timeFields[0]);
                today.set(12, timeFields[1]);
                today.set(13, timeFields[2]);
                today.set(14, 0);
                today.setLenient(false);
                return today.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int[] parseDateTimeString(String dateString, String identifier, int numExpectedFields) {
        dateString = dateString.trim();
        int length = identifier.length();
        if (dateString.length() > length + 2 && identifier.equalsIgnoreCase(dateString.substring(0, length))) {
            String rest = dateString.substring(length);
            rest = rest.trim();
            length = rest.length();
            if (rest.charAt(0) == '(' && rest.charAt(length - 1) == ')') {
                rest = rest.substring(1, length - 1);
                StringTokenizer strTok = new StringTokenizer(rest.trim(), ",");
                try {
                    int numFields;
                    int[] timefields = new int[numExpectedFields];
                    for (numFields = 0; strTok.hasMoreTokens() && numFields < numExpectedFields; ++numFields) {
                        timefields[numFields] = Integer.parseInt(strTok.nextToken().trim());
                    }
                    return (int[])(numFields == numExpectedFields ? timefields : null);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    static {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setLenient(true);
        c.set(1899, 11, 30, 0, 0, 0);
        c.setTimeZone(s_GMT);
        COM_OFFSET = c.getTime().getTime();
    }
}

