/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.conversion;

public class EncodeUtils {
    private static final char[] BASE64_MAP;
    private static final char BASE64_PAD = '=';
    private static final byte[] DECODETABLE;

    private static int decode0(char[] ibuf, byte[] obuf, int wp) {
        int outlen = 3;
        if (ibuf[3] == '=') {
            outlen = 2;
        }
        if (ibuf[2] == '=') {
            outlen = 1;
        }
        byte b0 = DECODETABLE[ibuf[0]];
        byte b1 = DECODETABLE[ibuf[1]];
        byte b2 = DECODETABLE[ibuf[2]];
        byte b3 = DECODETABLE[ibuf[3]];
        switch (outlen) {
            case 1: {
                obuf[wp] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
        }
        obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
        obuf[wp++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
        obuf[wp] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
        return 3;
    }

    public static String base64Encode(byte[] buffer) {
        int i;
        int rest;
        if (buffer.length <= 0) {
            return "";
        }
        char[] out = new char[buffer.length / 3 * 4 + 4];
        int rindex = 0;
        int windex = 0;
        for (rest = buffer.length; rest >= 3; rest -= 3) {
            i = ((buffer[rindex] & 0xFF) << 16) + ((buffer[rindex + 1] & 0xFF) << 8) + (buffer[rindex + 2] & 0xFF);
            out[windex++] = BASE64_MAP[i >> 18];
            out[windex++] = BASE64_MAP[i >> 12 & 0x3F];
            out[windex++] = BASE64_MAP[i >> 6 & 0x3F];
            out[windex++] = BASE64_MAP[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            i = buffer[rindex] & 0xFF;
            out[windex++] = BASE64_MAP[i >> 2];
            out[windex++] = BASE64_MAP[i << 4 & 0x3F];
            out[windex++] = 61;
            out[windex++] = 61;
        } else if (rest == 2) {
            i = ((buffer[rindex] & 0xFF) << 8) + (buffer[rindex + 1] & 0xFF);
            out[windex++] = BASE64_MAP[i >> 10];
            out[windex++] = BASE64_MAP[i >> 4 & 0x3F];
            out[windex++] = BASE64_MAP[i << 2 & 0x3F];
            out[windex++] = 61;
        }
        return new String(out, 0, windex);
    }

    public static byte[] base64Decode(String stream) {
        char[] ibuf = new char[4];
        int ibufcount = 0;
        byte[] obuf = new byte[stream.length() / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = 0; i < stream.length(); ++i) {
            char ch = stream.charAt(i);
            if (ch != '=' && (ch >= DECODETABLE.length || DECODETABLE[ch] == 127)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            obufcount += EncodeUtils.decode0(ibuf, obuf, obufcount);
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static String base64EncodeCxlib(byte[] buffer) {
        String base64Str = EncodeUtils.base64Encode(buffer);
        base64Str = base64Str.replaceAll("=", "");
        base64Str = base64Str.replace('+', '_');
        base64Str = base64Str.replace('/', '.');
        return base64Str;
    }

    public static byte[] base64DecodeCxlib(String stream) {
        String paddingStream = stream;
        paddingStream = paddingStream.replace('_', '+');
        paddingStream = paddingStream.replace('.', '/');
        int remaining = stream.length() % 4;
        if (remaining == 2) {
            paddingStream = paddingStream + "==";
        } else if (remaining == 3) {
            paddingStream = paddingStream + "=";
        }
        return EncodeUtils.base64Decode(paddingStream);
    }

    static {
        int i;
        BASE64_MAP = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DECODETABLE = new byte[128];
        for (i = 0; i < DECODETABLE.length; ++i) {
            EncodeUtils.DECODETABLE[i] = 127;
        }
        for (i = 0; i < BASE64_MAP.length; ++i) {
            EncodeUtils.DECODETABLE[EncodeUtils.BASE64_MAP[i]] = (byte)i;
        }
    }
}

