/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.conversion;

public class LongConversion {
    public static final Long ZERO = new Long(0L);

    public static Long parseLong(String s) {
        return LongConversion.parseLong(s, 10);
    }

    public static Long parseLong(String s, int radix) {
        return LongConversion.parseLong(s, 0, s.length(), radix);
    }

    public static Long parseLong(String s, int offset, int end, int radix) {
        if (s == null) {
            return null;
        }
        if (radix < 2) {
            return null;
        }
        if (radix > 36) {
            return null;
        }
        long result = 0L;
        boolean negative = false;
        int i = offset;
        int max = end;
        if (max > 0) {
            int digit;
            long limit;
            if (s.charAt(offset) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return null;
                }
                if (result < multmin) {
                    return null;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return null;
                }
                result -= (long)digit;
            }
        } else {
            return LongConversion.getDefaultLong(0L);
        }
        if (negative) {
            if (i - offset > 1) {
                return new Long(result);
            }
            return null;
        }
        return new Long(-result);
    }

    public static Long parseLong(char[] s, int offset, int end, int radix) {
        if (s == null) {
            return null;
        }
        if (radix < 2) {
            return null;
        }
        if (radix > 36) {
            return null;
        }
        long result = 0L;
        boolean negative = false;
        int i = offset;
        int max = end;
        if (max > 0) {
            int digit;
            long limit;
            if (s[offset] == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < max) {
                if ((digit = Character.digit(s[i++], radix)) < 0) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s[i++], radix)) < 0) {
                    return null;
                }
                if (result < multmin) {
                    return null;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return null;
                }
                result -= (long)digit;
            }
        } else {
            return LongConversion.getDefaultLong(0L);
        }
        if (negative) {
            if (i - offset > 1) {
                return new Long(result);
            }
            return null;
        }
        return new Long(-result);
    }

    public static Long getDefaultLong(long value) {
        return value == 0L ? ZERO : new Long(value);
    }
}

