/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.conversion;

import java.util.TimeZone;

public class TimeZoneConversion {
    public static final int ID_BASE = 46000;
    static String[] s_timezones = new String[]{"GMT", "Europe/London", "Europe/Berlin", "Europe/Warsaw", "Europe/Paris", "Europe/Prague", "Africa/Tunis", "Africa/Ndjamena", "Europe/Helsinki", "Africa/Cairo", "Africa/Johannesburg", "Europe/Sofia", "Asia/Jerusalem", "Asia/Damascus", "Asia/Riyadh", "Europe/Moscow", "Africa/Nairobi", "Asia/Tehran", "Asia/Baghdad", "Asia/Tbilisi", "Asia/Kabul", "Asia/Yekaterinburg", "Asia/Karachi", "Asia/Calcutta", "Asia/Katmandu", "Asia/Almaty", "Asia/Dacca", "Asia/Colombo", "Asia/Rangoon", "Asia/Bangkok", "Asia/Krasnoyarsk", "Asia/Shanghai", "Asia/Irkutsk", "Asia/Singapore", "Australia/Perth", "Asia/Taipei", "Asia/Tokyo", "Asia/Seoul", "Asia/Yakutsk", "Australia/Adelaide", "Australia/Darwin", "Australia/Sydney", "Australia/Brisbane", "Pacific/Guam", "Australia/Hobart", "Asia/Vladivostok", "Asia/Magadan", "Pacific/Auckland", "Pacific/Fiji", "Pacific/Tongatapu", "Atlantic/Cape_Verde", "Atlantic/Azores", "Atlantic/South_Georgia", "GMT-3", "America/Buenos_Aires", "America/Sao_Paulo", "America/St_Johns", "America/Santiago", "America/Caracas", "America/Halifax", "America/New_York", "America/Montreal", "America/Lima", "America/Winnipeg", "America/Mexico_City", "US/Central", "America/Chicago", "America/Edmonton", "America/Phoenix", "America/Los_Angeles", "America/Anchorage", "Pacific/Honolulu", "Pacific/Apia", "GMT-12"};

    public static int convertToID(TimeZone timezone) {
        if (TimeZone.getDefault().equals(timezone)) {
            return 0;
        }
        for (int i = 0; i < s_timezones.length; ++i) {
            String id = s_timezones[i];
            if (!TimeZone.getTimeZone(id).equals(timezone)) continue;
            return i * 2 + 46000;
        }
        return 0;
    }

    public static TimeZone convertToTimeZone(int id) {
        if (id < 46000) {
            return TimeZone.getDefault();
        }
        int index = (id - 46000) / 2;
        return TimeZone.getTimeZone(s_timezones[index]);
    }
}

